/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;

final class TroubleParser {
    private static final boolean DONE = true;
    private static final boolean WANT_MORE = false;
    private final Report.Trouble trouble;
    private final RegexpUtils regexp;
    private final boolean callstackOnly;
    private Report.Trouble currTrouble;
    private List<String> callstackBuffer;
    private int emptyLines = 0;
    private boolean isHiddenComparisonFailure;

    TroubleParser(Report.Trouble trouble, RegexpUtils regexpUtils) {
        this.trouble = trouble;
        this.regexp = regexpUtils;
        this.callstackOnly = trouble.exceptionClsName != null;
        this.currTrouble = trouble;
    }

    boolean processMessage(String string) {
        Matcher matcher;
        if (this.trouble.exceptionClsName == null && (matcher = this.regexp.getTestcaseExceptionPattern().matcher(string)).matches()) {
            this.trouble.exceptionClsName = matcher.group(1);
            this.trouble.message = matcher.group(2);
            this.isHiddenComparisonFailure = false;
            return false;
        }
        if (string.length() == 0) {
            if (this.trouble.exceptionClsName != null && this.callstackBuffer != null || ++this.emptyLines == 2) {
                this.finishProcessing();
                return true;
            }
        } else {
            this.emptyLines = 0;
        }
        if (this.trouble.exceptionClsName != null && this.callstackBuffer != null && string.startsWith("Caused by: ") && (matcher = this.regexp.getNestedExceptionPattern().matcher(string.substring("Caused by: ".length()))).matches()) {
            this.fixateStackTrace();
            Report.Trouble trouble = new Report.Trouble(false);
            trouble.exceptionClsName = matcher.group(1);
            trouble.message = matcher.group(2);
            this.currTrouble.nestedTrouble = trouble;
            this.currTrouble = trouble;
            return false;
        }
        String string2 = RegexpUtils.specialTrim(string);
        if (string2.startsWith("[catch] ")) {
            string2 = string2.substring("[catch] ".length());
        }
        if (string2.startsWith("at ") && (matcher = this.regexp.getCallstackLinePattern().matcher(string)).matches()) {
            if (this.isHiddenComparisonFailure && this.trouble.exceptionClsName == null) {
                this.trouble.exceptionClsName = "org.junit.ComparisonFailure";
            }
            if (this.callstackBuffer == null) {
                this.callstackBuffer = new ArrayList<String>(8);
            }
            this.callstackBuffer.add(string2.substring("at ".length()));
            return false;
        }
        if (!this.callstackOnly && this.currTrouble == this.trouble && this.callstackBuffer == null) {
            int n;
            if (this.trouble.exceptionClsName == null && this.trouble.message == null && (n = string.indexOf("expected:<")) != -1) {
                this.isHiddenComparisonFailure = true;
                if (n == 5 && string.startsWith("null ")) {
                    string = string.substring(5);
                }
            }
            this.trouble.message = this.trouble.message != null ? this.trouble.message + '\n' + string : string;
        }
        return false;
    }

    void finishProcessing() {
        if (this.callstackBuffer != null) {
            this.fixateStackTrace();
        }
        if (this.isHiddenComparisonFailure && this.trouble.exceptionClsName == null) {
            this.trouble.exceptionClsName = "org.junit.ComparisonFailure";
        }
    }

    private void fixateStackTrace() {
        this.currTrouble.stackTrace = this.callstackBuffer.toArray(new String[this.callstackBuffer.size()]);
        this.callstackBuffer = null;
    }
}

