/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultTreeView;
import org.netbeans.modules.junit.output.RootNode;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResultPanelTree
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static ResourceBundle bundle = NbBundle.getBundle(ResultPanelTree.class);
    private final ExplorerManager explorerManager;
    private final RootNode rootNode;
    private final ResultTreeView treeView;
    private boolean filtered = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private final RegexpUtils regexpUtils = RegexpUtils.getInstance();
    private final ResultDisplayHandler displayHandler;

    ResultPanelTree(ResultDisplayHandler resultDisplayHandler) {
        super(new BorderLayout());
        this.treeView = new ResultTreeView();
        this.treeView.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TestResults"));
        this.treeView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TestResults"));
        this.add((Component)((Object)this.treeView), "Center");
        this.explorerManager = new ExplorerManager();
        this.rootNode = new RootNode(this.filtered);
        this.explorerManager.setRootContext((Node)this.rootNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initAccessibility();
        this.displayHandler = resultDisplayHandler;
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_ResultPanelTree"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ResultPanelTree"));
        accessibleContext = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
        accessibleContext = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
    }

    void displayMsg(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessage(string);
    }

    void displayMsgSessionFinished(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessageSessionFinished(string);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.displayHandler.setTreePanel(this);
    }

    void displaySuiteRunning(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displaySuiteRunning(string);
    }

    void displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode testsuiteNode = this.rootNode.displayReport(report);
        if (testsuiteNode != null && report.containsFailed()) {
            this.treeView.expandReportNode(testsuiteNode);
        }
    }

    void displayReports(List<Report> list) {
        assert (EventQueue.isDispatchThread());
        if (list.size() == 1) {
            this.displayReport(list.get(0));
        } else {
            this.rootNode.displayReports(list);
        }
    }

    int getSuccessDisplayedLevel() {
        return this.rootNode.getSuccessDisplayedLevel();
    }

    void viewOpened() {
        assert (EventQueue.isDispatchThread());
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        this.rootNode.setFiltered(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.nodeSelectionChanged();
        }
    }

    private void nodeSelectionChanged() {
        assert (EventQueue.isDispatchThread());
        this.fireChange();
    }

    void setChangeListener(ChangeListener changeListener) {
        assert (EventQueue.isDispatchThread());
        this.changeListener = changeListener;
        if (this.changeListener == null) {
            this.changeEvent = null;
        } else if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    private void fireNodeSelectionChange() {
        this.fireChange();
    }

    private void fireChange() {
        assert (EventQueue.isDispatchThread());
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    Node[] getSelectedNodes() {
        return this.explorerManager.getSelectedNodes();
    }

    private void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.fireNodeSelectionChange();
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.fireNodeSelectionChange();
            }
            catch (PropertyVetoException propertyVetoException2) {
                ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException2);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }
}

