/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.annotate;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.annotate.AnnotationBar;
import org.netbeans.modules.versioning.annotate.AnnotationBarManager;
import org.netbeans.modules.versioning.annotate.VcsAnnotations;
import org.netbeans.modules.versioning.annotate.VcsAnnotationsProvider;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VcsAnnotateAction
extends AbstractAction {
    private final VcsAnnotationsProvider provider;
    private final Collection<? extends Node> nodes;

    public VcsAnnotateAction(VCSContext vCSContext, VcsAnnotationsProvider vcsAnnotationsProvider) {
        this.provider = vcsAnnotationsProvider;
        this.nodes = vCSContext.getElements().lookupAll(Node.class);
        this.putValue("Name", this.cumputeActionName());
    }

    public boolean isEnabled() {
        return this.activatedEditorCookie() != null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.visible()) {
            JEditorPane jEditorPane = this.activatedEditorPane();
            AnnotationBarManager.hideAnnotationBar(jEditorPane);
        } else {
            EditorCookie editorCookie = this.activatedEditorCookie();
            if (editorCookie == null) {
                return;
            }
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null) {
                editorCookie.open();
            }
            if ((jEditorPaneArray = editorCookie.getOpenedPanes()) == null) {
                return;
            }
            JEditorPane jEditorPane = jEditorPaneArray[0];
            AnnotationBar annotationBar = AnnotationBarManager.showAnnotationBar(jEditorPane);
            annotationBar.setAnnotationMessage(NbBundle.getMessage(VcsAnnotateAction.class, (String)"CTL_AnnotationSubstitute"));
            this.computeAnnotationsAsync(annotationBar);
        }
    }

    private void computeAnnotationsAsync(final AnnotationBar annotationBar) {
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                VcsAnnotateAction.this.computeAnnotations(annotationBar);
            }
        });
        task.schedule(0);
    }

    private void computeAnnotations(AnnotationBar annotationBar) {
        VcsAnnotations vcsAnnotations = this.provider.getAnnotations();
        File file = new File("");
        annotationBar.annotationLines(file, vcsAnnotations);
    }

    private String cumputeActionName() {
        if (this.visible()) {
            return NbBundle.getMessage(VcsAnnotateAction.class, (String)"Action_HideAnnotations");
        }
        return NbBundle.getMessage(VcsAnnotateAction.class, (String)"Action_ShowAnnotations");
    }

    public boolean visible() {
        JEditorPane jEditorPane = this.activatedEditorPane();
        return AnnotationBarManager.annotationBarVisible(jEditorPane);
    }

    private JEditorPane activatedEditorPane() {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = this.activatedEditorCookie();
        if (editorCookie != null && SwingUtilities.isEventDispatchThread() && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie() {
        if (this.nodes != null && this.nodes.size() == 1) {
            Node node = this.nodes.iterator().next();
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }
}

