/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingActionsProvider;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private final Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            CallStackActionsProvider.this.makeCurrent((CallStackFrame)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action COPY_TO_CLBD_ACTION = new AbstractAction(NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_Copy2CLBD_Label")){

        public boolean isEnabled() {
            JPDAThread jPDAThread = CallStackActionsProvider.this.debugger.getCurrentThread();
            return jPDAThread != null && jPDAThread.isSuspended();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallStackActionsProvider.this.stackToCLBD();
        }
    };
    private static final Action POP_TO_HERE_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(final Object[] objectArray) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CallStackActionsProvider.popToHere((CallStackFrame)objectArray[0]);
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private JPDADebugger debugger;
    private ContextProvider lookupProvider;

    public CallStackActionsProvider(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[]{this.COPY_TO_CLBD_ACTION};
        }
        if (!(object instanceof CallStackFrame)) {
            throw new UnknownTypeException(object);
        }
        boolean bl = this.debugger.canPopFrames();
        if (bl) {
            return new Action[]{this.MAKE_CURRENT_ACTION, POP_TO_HERE_ACTION, DebuggingActionsProvider.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
        }
        return new Action[]{this.MAKE_CURRENT_ACTION, DebuggingActionsProvider.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof CallStackFrame) {
            this.makeCurrent((CallStackFrame)object);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static void popToHere(CallStackFrame callStackFrame) {
        try {
            JPDAThread jPDAThread = callStackFrame.getThread();
            CallStackFrame[] callStackFrameArray = jPDAThread.getCallStack();
            int n = callStackFrameArray.length;
            if (n < 2) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                if (!callStackFrameArray[i].equals(callStackFrame)) continue;
                if (i > 0) {
                    callStackFrameArray[i - 1].popFrame();
                }
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    private void stackToCLBD() {
        CallStackFrame[] callStackFrameArray;
        JPDAThread jPDAThread = this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        try {
            callStackFrameArray = jPDAThread.getCallStack();
        }
        catch (AbsentInformationException absentInformationException) {
            stringBuffer.append(NbBundle.getMessage(CallStackActionsProvider.class, (String)"MSG_NoSourceInfo"));
            callStackFrameArray = null;
        }
        if (callStackFrameArray != null) {
            int n = callStackFrameArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callStackFrameArray[i].getClassName());
                stringBuffer.append(".");
                stringBuffer.append(callStackFrameArray[i].getMethodName());
                try {
                    String string = callStackFrameArray[i].getSourceName(null);
                    stringBuffer.append("(");
                    stringBuffer.append(string);
                    int n2 = callStackFrameArray[i].getLineNumber(null);
                    if (n2 > 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(n2);
                    }
                    stringBuffer.append(")");
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                if (i == n - 1) continue;
                stringBuffer.append('\n');
            }
        }
        Clipboard clipboard = CallStackActionsProvider.getClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private void makeCurrent(final CallStackFrame callStackFrame) {
        if (this.debugger.getCurrentCallStackFrame() != callStackFrame) {
            callStackFrame.makeCurrent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
                    SourcePath sourcePath = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, SourcePath.class);
                    sourcePath.showSource(callStackFrame, string);
                }
            });
        }
    }
}

