/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import org.netbeans.modules.glassfish.eecommon.Status;
import org.openide.util.RequestProcessor;

public class ProgressEventSupport {
    private Object obj;
    private Vector listeners;
    private DeploymentStatus status;
    private TargetModuleID tmID;

    public ProgressEventSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.obj = object;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        boolean bl = false;
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(progressListener);
        if (this.status != null && !this.status.isRunning()) {
            bl = true;
        }
        if (bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ProgressEventSupport.this.fireHandleProgressEvent(ProgressEventSupport.this.tmID, ProgressEventSupport.this.status);
                }
            });
        }
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent progressEvent = new ProgressEvent(this.obj, targetModuleID, deploymentStatus);
        this.status = deploymentStatus;
        this.tmID = targetModuleID;
        Vector vector = null;
        ProgressEventSupport progressEventSupport = this;
        synchronized (progressEventSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ProgressListener progressListener = (ProgressListener)vector.elementAt(i);
                progressListener.handleProgressEvent(progressEvent);
            }
        }
    }

    public synchronized DeploymentStatus getDeploymentStatus() {
        return this.status;
    }

    public synchronized void clearProgressListener() {
        this.listeners = null;
    }

    public static DeploymentStatus createStatus(ActionType actionType, CommandType commandType, String string, StateType stateType) {
        return new Status(actionType, commandType, string, stateType);
    }
}

