/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.visitor.DefaultSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.MessageDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceCustomizer<T extends SchemaComponent>
extends AbstractSchemaComponentCustomizer<T>
implements PropertyChangeListener {
    static final long serialVersionUID = 1L;
    public JPanel mPanel;
    public JPanel typePanel;
    private transient ReferenceVisitor refVisitor;

    public ReferenceCustomizer(SchemaComponentReference<T> schemaComponentReference, SchemaComponent schemaComponent) {
        super(schemaComponentReference, schemaComponent);
        this.refVisitor = new ReferenceVisitor(schemaComponentReference.get());
        this.initComponents();
        this.reset();
    }

    public void applyChanges() throws IOException {
        if (this.canApply()) {
            this.setRef();
        }
    }

    public void reset() {
        this.initializeModel();
        this.initializeUISelection();
        if (this.hasParent() || this.getUIRef() == null) {
            this.setSaveEnabled(false);
        } else {
            this.setSaveEnabled(true);
        }
        this.setResetEnabled(false);
    }

    protected ReferenceableSchemaComponent getRef() {
        return this.refVisitor.getRef();
    }

    protected void initializeModel() {
    }

    protected void setRef() {
        this.refVisitor.setRef(this.getUIRef());
    }

    private void selectModelNode() {
        this.refVisitor.getComponentSelectionPanel().removePropertyChangeListener(this);
        this.refVisitor.reset();
        this.refVisitor.getComponentSelectionPanel().addPropertyChangeListener(this);
    }

    private void initializeTypeView() {
        this.refVisitor.getComponentSelectionPanel().addPropertyChangeListener(this);
        this.typePanel.add((Component)this.refVisitor.getComponentSelectionPanel().getTypeSelectionPanel(), "Center");
        this.refVisitor.getComponentSelectionPanel().getTypeSelectionPanel().getAccessibleContext().setAccessibleParent(this.typePanel);
    }

    private void initializeUISelection() {
        this.getMessageDisplayer().clear();
        this.selectModelNode();
    }

    protected ReferenceableSchemaComponent getUIRef() {
        return this.refVisitor.getComponentSelectionPanel().getCurrentSelection();
    }

    private void initComponents() {
        this.typePanel = new JPanel();
        this.mPanel = new JPanel();
        this.typePanel.setLayout(new BorderLayout());
        this.initializeTypeView();
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((Component)this.getMessageDisplayer().getComponent(), "Center");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.mPanel, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.typePanel, -1, 380, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.typePanel, -1, 407, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.mPanel, -1, 37, Short.MAX_VALUE)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectionChanged")) {
            this.determineValidity();
        }
    }

    private void determineValidity() {
        this.getMessageDisplayer().clear();
        ReferenceableSchemaComponent referenceableSchemaComponent = this.getUIRef();
        if (referenceableSchemaComponent != null) {
            if (this.getRef() == referenceableSchemaComponent) {
                this.setResetEnabled(false);
                this.setSaveEnabled(!this.hasParent());
            } else {
                this.setResetEnabled(true);
                this.setSaveEnabled(true);
            }
        } else {
            this.setResetEnabled(this.getRef() != null);
            this.setSaveEnabled(false);
            this.getMessageDisplayer().annotate(NbBundle.getMessage(ReferenceCustomizer.class, (String)"MSG_Reference_Error"), MessageDisplayer.Type.ERROR);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ReferenceCustomizer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceVisitor
    extends DefaultSchemaVisitor {
        private SchemaComponent component;
        private OPERATION operation;
        private ReferenceableSchemaComponent ref;
        private SchemaComponentSelectionPanel<? extends ReferenceableSchemaComponent> componentSelectionPanel;

        public ReferenceVisitor(SchemaComponent schemaComponent) {
            this.component = schemaComponent;
            this.operation = null;
            schemaComponent.accept((SchemaVisitor)this);
        }

        public void visit(ElementReference elementReference) {
            if (this.operation == null) {
                if (this.componentSelectionPanel == null) {
                    this.componentSelectionPanel = new SchemaComponentSelectionPanel<GlobalElement>(elementReference.getModel(), GlobalElement.class, (GlobalElement)this.getRef(), null, false);
                }
            } else if (this.operation == OPERATION.GET) {
                if (elementReference.getRef() != null) {
                    this.ref = (ReferenceableSchemaComponent)elementReference.getRef().get();
                }
            } else if (this.operation == OPERATION.SET) {
                elementReference.setRef(elementReference.getModel().getFactory().createGlobalReference((ReferenceableSchemaComponent)((GlobalElement)this.ref), GlobalElement.class, (SchemaComponent)elementReference));
            }
        }

        public void visit(AttributeReference attributeReference) {
            if (this.operation == null) {
                this.componentSelectionPanel = new SchemaComponentSelectionPanel<GlobalAttribute>(attributeReference.getModel(), GlobalAttribute.class, (GlobalAttribute)this.getRef(), null, false);
            } else if (this.operation == OPERATION.GET) {
                if (attributeReference.getRef() != null) {
                    this.ref = (ReferenceableSchemaComponent)attributeReference.getRef().get();
                }
            } else if (this.operation == OPERATION.SET) {
                attributeReference.setRef(attributeReference.getModel().getFactory().createGlobalReference((ReferenceableSchemaComponent)((GlobalAttribute)this.ref), GlobalAttribute.class, (SchemaComponent)attributeReference));
            }
        }

        public void visit(GroupReference groupReference) {
            if (this.operation == null) {
                this.componentSelectionPanel = new SchemaComponentSelectionPanel<GlobalGroup>(groupReference.getModel(), GlobalGroup.class, (GlobalGroup)this.getRef(), null, false);
            } else if (this.operation == OPERATION.GET) {
                if (groupReference.getRef() != null) {
                    this.ref = (ReferenceableSchemaComponent)groupReference.getRef().get();
                }
            } else if (this.operation == OPERATION.SET) {
                groupReference.setRef(groupReference.getModel().getFactory().createGlobalReference((ReferenceableSchemaComponent)((GlobalGroup)this.ref), GlobalGroup.class, (SchemaComponent)groupReference));
            }
        }

        public void visit(AttributeGroupReference attributeGroupReference) {
            if (this.operation == null) {
                this.componentSelectionPanel = new SchemaComponentSelectionPanel<GlobalAttributeGroup>(attributeGroupReference.getModel(), GlobalAttributeGroup.class, (GlobalAttributeGroup)this.getRef(), null, false);
            } else if (this.operation == OPERATION.GET) {
                if (attributeGroupReference.getGroup() != null) {
                    this.ref = (ReferenceableSchemaComponent)attributeGroupReference.getGroup().get();
                }
            } else if (this.operation == OPERATION.SET) {
                attributeGroupReference.setGroup(attributeGroupReference.getModel().getFactory().createGlobalReference((ReferenceableSchemaComponent)((GlobalAttributeGroup)this.ref), GlobalAttributeGroup.class, (SchemaComponent)attributeGroupReference));
            }
        }

        public SchemaComponentSelectionPanel<? extends ReferenceableSchemaComponent> getComponentSelectionPanel() {
            return this.componentSelectionPanel;
        }

        public ReferenceableSchemaComponent getRef() {
            this.operation = OPERATION.GET;
            this.ref = null;
            this.component.accept((SchemaVisitor)this);
            return this.ref;
        }

        public void setRef(ReferenceableSchemaComponent referenceableSchemaComponent) {
            this.operation = OPERATION.SET;
            this.ref = referenceableSchemaComponent;
            this.component.accept((SchemaVisitor)this);
        }

        public void reset() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum OPERATION {
            GET,
            SET;

        }
    }
}

