/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.ComplexTypeDefinition;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.ui.customizer.MessageDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ElementCustomizer<T extends Element>
extends AbstractSchemaComponentCustomizer<T>
implements PropertyChangeListener {
    static final long serialVersionUID = 1L;
    public JRadioButton anonymousComplexRadioButton;
    public JRadioButton anonymousSimpleRadioButton;
    public ButtonGroup elementTypeButtonGroup;
    public JRadioButton existingRadioButton;
    public JScrollPane jScrollPane1;
    public JPanel mPanel;
    public JLabel nameLabel;
    public JPanel namePanel;
    public JTextField nameTextField;
    public JRadioButton noTypeRadioButton;
    public JLabel previewLabel;
    public JEditorPane previewPane;
    public JLabel typeLabel;
    public JPanel typePanel;
    private DocumentListener nameListener;
    private ItemListener typeButtonsListener;
    private transient ElementTypeStyle currentStyle;
    private transient GlobalType currentGlobalType;
    private transient SchemaComponentSelectionPanel<GlobalType> componentSelectionPanel;

    public ElementCustomizer(SchemaComponentReference<T> schemaComponentReference, SchemaComponent schemaComponent) {
        super(schemaComponentReference, schemaComponent);
        this.initComponents();
        this.reset();
    }

    public void applyChanges() throws IOException {
        this.saveName();
        if (this._getType() != this.getUIType() || this._getStyle() != this.getUIStyle()) {
            this.setModelType();
        }
    }

    public void reset() {
        this.removeListeners();
        this.initializeModel();
        this.initializeUISelection();
        this.addListeners();
        if (this.hasParent()) {
            this.setSaveEnabled(false);
        } else {
            this.setSaveEnabled(true);
        }
        this.setResetEnabled(false);
    }

    @Override
    protected String _getName() {
        String string = super._getName();
        return string == null ? "" : string;
    }

    private GlobalType _getType() {
        return this.currentGlobalType;
    }

    private ElementTypeStyle _getStyle() {
        return this.currentStyle;
    }

    protected void _setType(GlobalType globalType) {
        this.currentGlobalType = globalType;
        this.currentStyle = ElementTypeStyle.EXISTING;
    }

    protected void _setType(LocalType localType) {
        this.currentGlobalType = null;
        this.currentStyle = ElementTypeStyle.NO_TYPE;
        if (localType instanceof LocalSimpleType) {
            this.currentStyle = ElementTypeStyle.ANONYMOUS_SIMPLE;
        } else if (localType instanceof LocalComplexType) {
            this.currentStyle = ElementTypeStyle.ANONYMOUS_COMPLEX;
        }
    }

    protected abstract void initializeModel();

    protected abstract void setModelType();

    private void selectModelNode() {
        this.componentSelectionPanel.setInitialSelection(this._getType());
    }

    private void initializeTypeView() {
        this.componentSelectionPanel = new SchemaComponentSelectionPanel<Object>(((Element)this.getReference().get()).getModel(), GlobalType.class, null, null, true);
        this.componentSelectionPanel.addPropertyChangeListener(this);
        this.typePanel.add((Component)this.componentSelectionPanel.getTypeSelectionPanel(), "Center");
        this.componentSelectionPanel.getTypeSelectionPanel().getAccessibleContext().setAccessibleParent(this.typePanel);
    }

    private void initializeUISelection() {
        this.getMessageDisplayer().clear();
        this.nameTextField.getDocument().removeDocumentListener(this.nameListener);
        this.nameTextField.setText(this._getName());
        if (!this.hasParent()) {
            this.nameTextField.setSelectionStart(0);
        }
        this.nameTextField.getDocument().addDocumentListener(this.nameListener);
        ElementTypeStyle elementTypeStyle = this._getStyle();
        switch (elementTypeStyle) {
            case NO_TYPE: {
                this.noTypeRadioButton.setSelected(true);
                break;
            }
            case ANONYMOUS_COMPLEX: {
                this.anonymousComplexRadioButton.setSelected(true);
                break;
            }
            case ANONYMOUS_SIMPLE: {
                this.anonymousSimpleRadioButton.setSelected(true);
                break;
            }
            case EXISTING: {
                this.existingRadioButton.setSelected(true);
            }
        }
        this.enableDisableListView();
        if (elementTypeStyle == ElementTypeStyle.EXISTING) {
            this.selectModelNode();
        }
        this.setPreviewText();
    }

    protected LocalType createLocalType(SchemaComponentFactory schemaComponentFactory, ElementTypeStyle elementTypeStyle, GlobalType globalType) {
        switch (elementTypeStyle) {
            case ANONYMOUS_COMPLEX: {
                LocalComplexType localComplexType = schemaComponentFactory.createLocalComplexType();
                Sequence sequence = schemaComponentFactory.createSequence();
                localComplexType.setDefinition((ComplexTypeDefinition)sequence);
                return localComplexType;
            }
            case ANONYMOUS_SIMPLE: {
                LocalSimpleType localSimpleType = schemaComponentFactory.createLocalSimpleType();
                SimpleTypeRestriction simpleTypeRestriction = schemaComponentFactory.createSimpleTypeRestriction();
                simpleTypeRestriction.setBase(ElementCustomizer.createStringTypeReference(schemaComponentFactory, (SchemaComponent)simpleTypeRestriction));
                localSimpleType.setDefinition((SimpleTypeDefinition)simpleTypeRestriction);
                return localSimpleType;
            }
        }
        return null;
    }

    @Override
    protected String getUIName() {
        return this.nameTextField.getText();
    }

    protected GlobalType getUIType() {
        ElementTypeStyle elementTypeStyle = this.getUIStyle();
        if (elementTypeStyle == ElementTypeStyle.NO_TYPE || elementTypeStyle == ElementTypeStyle.ANONYMOUS_COMPLEX || elementTypeStyle == ElementTypeStyle.ANONYMOUS_SIMPLE) {
            return null;
        }
        return this.componentSelectionPanel.getCurrentSelection();
    }

    protected ElementTypeStyle getUIStyle() {
        if (this.noTypeRadioButton.isSelected()) {
            return ElementTypeStyle.NO_TYPE;
        }
        if (this.anonymousComplexRadioButton.isSelected()) {
            return ElementTypeStyle.ANONYMOUS_COMPLEX;
        }
        if (this.anonymousSimpleRadioButton.isSelected()) {
            return ElementTypeStyle.ANONYMOUS_SIMPLE;
        }
        if (this.existingRadioButton.isSelected()) {
            return ElementTypeStyle.EXISTING;
        }
        return null;
    }

    private void initComponents() {
        this.elementTypeButtonGroup = new ButtonGroup();
        this.previewLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane(){
            static final long serialVersionUID = 1L;

            protected void processMouseEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        };
        this.typeLabel = new JLabel();
        this.anonymousComplexRadioButton = new JRadioButton();
        this.anonymousSimpleRadioButton = new JRadioButton();
        this.noTypeRadioButton = new JRadioButton();
        this.existingRadioButton = new JRadioButton();
        this.typePanel = new JPanel();
        this.mPanel = new JPanel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.previewLabel.setLabelFor(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"TITLE_CustomizerForm_Preview"));
        this.previewLabel.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_Preview"));
        this.previewPane.setEditable(false);
        this.previewPane.setContentType("text/xml");
        this.previewPane.setEnabled(false);
        this.jScrollPane1.setViewportView(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"LBL_CustomizerForm_Type", (Object[])new Object[0]));
        this.typeLabel.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_Type"));
        this.elementTypeButtonGroup.add(this.anonymousComplexRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousComplexRadioButton, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"LBL_ElementForm_AnonComplexType"));
        this.anonymousComplexRadioButton.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_ComplexType"));
        this.anonymousComplexRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousComplexRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.elementTypeButtonGroup.add(this.anonymousSimpleRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousSimpleRadioButton, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"LBL_ElementForm_AnonSimpleType"));
        this.anonymousSimpleRadioButton.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_SimpleType"));
        this.anonymousSimpleRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousSimpleRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.elementTypeButtonGroup.add(this.noTypeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.noTypeRadioButton, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"LBL_ElementForm_NoType"));
        this.noTypeRadioButton.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_NoType"));
        this.noTypeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noTypeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.elementTypeButtonGroup.add(this.existingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.existingRadioButton, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"LBL_ElementForm_ExistingType"));
        this.existingRadioButton.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_ExistingType"));
        this.existingRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.existingRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.typePanel.setLayout(new BorderLayout());
        this.initializeTypeView();
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((Component)this.getMessageDisplayer().getComponent(), "Center");
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ElementCustomizer.class, (String)"LBL_CustomizerForm_Name"));
        this.nameLabel.setToolTipText(NbBundle.getMessage(ElementCustomizer.class, (String)"HINT_ElementForm_Name"));
        this.nameTextField.setEditable(!this.hasParent());
        GroupLayout groupLayout = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.nameTextField, -1, 445, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTextField, -2, -1, -2))));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.typeLabel).addContainerGap(462, Short.MAX_VALUE)).add((Component)this.namePanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 480, Short.MAX_VALUE).add((Component)this.previewLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.anonymousSimpleRadioButton).add((Component)this.anonymousComplexRadioButton).add((Component)this.noTypeRadioButton).add((Component)this.existingRadioButton)))).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(38, 38, 38).add((Component)this.typePanel, -1, 452, Short.MAX_VALUE).addContainerGap()).add((Component)this.mPanel, -1, 500, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.namePanel, -2, -1, -2).add(11, 11, 11).add((Component)this.typeLabel).addPreferredGap(0).add((Component)this.anonymousComplexRadioButton).addPreferredGap(0).add((Component)this.anonymousSimpleRadioButton).addPreferredGap(0).add((Component)this.noTypeRadioButton).addPreferredGap(0).add((Component)this.existingRadioButton).addPreferredGap(0).add((Component)this.typePanel, -1, 217, Short.MAX_VALUE).add(11, 11, 11).add((Component)this.previewLabel).add(5, 5, 5).add((Component)this.jScrollPane1, -1, 97, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.mPanel, -1, 60, Short.MAX_VALUE)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectionChanged")) {
            this.setPreviewText();
            this.determineValidity();
        }
    }

    private void enableDisableListView() {
        switch (this.getUIStyle()) {
            case NO_TYPE: 
            case ANONYMOUS_COMPLEX: 
            case ANONYMOUS_SIMPLE: {
                this.componentSelectionPanel.setEnabled(false);
                break;
            }
            case EXISTING: {
                this.componentSelectionPanel.setEnabled(true);
            }
        }
    }

    private void determineValidity() {
        this.getMessageDisplayer().clear();
        if (!this.isNameChanged() && this._getStyle() == this.getUIStyle() && this._getType() == this.getUIType()) {
            if (this.hasParent()) {
                this.setSaveEnabled(false);
            } else {
                this.setSaveEnabled(true);
            }
            this.setResetEnabled(false);
        } else {
            this.setResetEnabled(true);
            boolean bl = false;
            ElementTypeStyle elementTypeStyle = this.getUIStyle();
            if (elementTypeStyle == ElementTypeStyle.NO_TYPE || elementTypeStyle == ElementTypeStyle.ANONYMOUS_COMPLEX || elementTypeStyle == ElementTypeStyle.ANONYMOUS_SIMPLE) {
                bl = true;
            } else if (this.getUIType() != null) {
                bl = true;
            }
            this.setSaveEnabled(bl && (!this.isNameChanged() || this.isNameValid()));
            if (!bl) {
                this.getMessageDisplayer().annotate(NbBundle.getMessage(ElementCustomizer.class, (String)"MSG_Type_Error"), MessageDisplayer.Type.ERROR);
            }
        }
    }

    private void addListeners() {
        if (this.nameListener == null) {
            this.nameListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    ElementCustomizer.this.setPreviewText();
                    ElementCustomizer.this.determineValidity();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    ElementCustomizer.this.setPreviewText();
                    ElementCustomizer.this.determineValidity();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ElementCustomizer.this.setPreviewText();
                    ElementCustomizer.this.determineValidity();
                }
            };
        }
        this.nameTextField.getDocument().addDocumentListener(this.nameListener);
        if (this.typeButtonsListener == null) {
            this.typeButtonsListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ElementCustomizer.this.enableDisableListView();
                        ElementCustomizer.this.setPreviewText();
                        ElementCustomizer.this.determineValidity();
                    }
                }
            };
        }
        this.noTypeRadioButton.addItemListener(this.typeButtonsListener);
        this.anonymousComplexRadioButton.addItemListener(this.typeButtonsListener);
        this.anonymousSimpleRadioButton.addItemListener(this.typeButtonsListener);
        this.existingRadioButton.addItemListener(this.typeButtonsListener);
    }

    private void removeListeners() {
        this.nameTextField.getDocument().removeDocumentListener(this.nameListener);
        this.noTypeRadioButton.removeItemListener(this.typeButtonsListener);
        this.anonymousComplexRadioButton.removeItemListener(this.typeButtonsListener);
        this.anonymousSimpleRadioButton.removeItemListener(this.typeButtonsListener);
        this.existingRadioButton.removeItemListener(this.typeButtonsListener);
    }

    private void setPreviewText() {
        StringBuffer stringBuffer = new StringBuffer("<");
        String string = ((Element)this.getReference().get()).getPeer().getPrefix();
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("element name=\"");
        stringBuffer.append(this.getUIName());
        stringBuffer.append("\"");
        switch (this.getUIStyle()) {
            case NO_TYPE: {
                stringBuffer.append(">");
                break;
            }
            case EXISTING: {
                stringBuffer.append(" type=\"");
                GlobalType globalType = this.getUIType();
                if (globalType != null) {
                    stringBuffer.append(globalType.getName());
                }
                stringBuffer.append("\">");
                break;
            }
            case ANONYMOUS_COMPLEX: {
                stringBuffer.append(">");
                stringBuffer.append("\n    <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("complexType>");
                stringBuffer.append("\n        <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("sequence/>");
                stringBuffer.append("\n    </");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("complexType>");
                break;
            }
            case ANONYMOUS_SIMPLE: {
                stringBuffer.append(">");
                stringBuffer.append("\n    <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("simpleType>");
                stringBuffer.append("\n        <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("restriction base=\"");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("string\"/>");
                stringBuffer.append("\n    </");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("simpleType>");
            }
        }
        stringBuffer.append("\n</");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("element>\n");
        this.previewPane.setText(stringBuffer.toString());
    }

    static NamedComponentReference<GlobalSimpleType> createStringTypeReference(SchemaComponentFactory schemaComponentFactory, SchemaComponent schemaComponent) {
        Collection collection = SchemaModelFactory.getDefault().getPrimitiveTypesModel().getSchema().getSimpleTypes();
        for (GlobalSimpleType globalSimpleType : collection) {
            if (!globalSimpleType.getName().equals("string")) continue;
            return schemaComponentFactory.createGlobalReference((ReferenceableSchemaComponent)globalSimpleType, GlobalSimpleType.class, schemaComponent);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ElementTypeStyle {
        NO_TYPE,
        ANONYMOUS_COMPLEX,
        ANONYMOUS_SIMPLE,
        EXISTING;

    }
}

