/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.Documentation;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AnnotationCustomizer;
import org.openide.util.NbBundle;

public class DocumentationPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    public static final String STATE_PROPERTY = "state";
    private transient Documentation documentation;
    private transient DocumentListener contentListener;
    private transient AnnotationCustomizer owner;
    private transient State state;
    private JEditorPane contentEditorPane;
    private JScrollPane contentScrollPane;
    private JPanel innerPanel;
    private JButton removeButton;
    private JButton titleButton;

    public DocumentationPanel(AnnotationCustomizer annotationCustomizer, Documentation documentation, boolean bl) {
        this.owner = annotationCustomizer;
        this.documentation = documentation;
        this.initComponents();
        this.initUI();
        this.setState(State.UNMODIFIED);
        this.addPropertyChangeListener(STATE_PROPERTY, annotationCustomizer);
        if (bl) {
            this.updateState(State.ADDED);
        }
    }

    private void initUI() {
        this.innerPanel.setVisible(false);
        if (this.contentListener == null) {
            this.contentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    DocumentationPanel.this.updateState(State.MODIFIED);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    DocumentationPanel.this.updateState(State.MODIFIED);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    DocumentationPanel.this.updateState(State.MODIFIED);
                }
            };
        } else {
            this.contentEditorPane.getDocument().removeDocumentListener(this.contentListener);
        }
        this.contentEditorPane.setText(this.getDocumentation().getContentFragment());
        this.contentEditorPane.getDocument().addDocumentListener(this.contentListener);
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    private boolean isModified() {
        return !this.getContent().equals(this.getDocumentation().getContentFragment());
    }

    public String getContent() {
        return this.contentEditorPane.getText();
    }

    private String getTitleButtonText() {
        String string = "";
        if (!this.titleButton.isSelected()) {
            string = this.getDocumentation().getContentFragment().trim();
            if (string.length() == 0) {
                string = NbBundle.getMessage(DocumentationPanel.class, (String)"LBL_DocumentationEmptyContent");
            } else if (string.length() > 20) {
                string = string.substring(0, 20);
                string = string.replaceAll("<", "&lt;");
            }
        }
        return NbBundle.getMessage(DocumentationPanel.class, (String)"LBL_Documentation", (Object)string);
    }

    public State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    private void updateState(State state) {
        State state2 = state;
        State state3 = this.getState();
        if (state3 == State.ADDED && state2 != State.REMOVED) {
            return;
        }
        if (state2 == State.MODIFIED && !this.isModified()) {
            state2 = State.UNMODIFIED;
        }
        this.setState(state2);
        this.firePropertyChange(STATE_PROPERTY, (Object)state3, (Object)state2);
    }

    private void initComponents() {
        this.titleButton = new JButton();
        this.innerPanel = new JPanel();
        this.removeButton = new JButton();
        this.contentScrollPane = new JScrollPane();
        this.contentEditorPane = new JEditorPane(){
            static final long serialVersionUID = 1L;

            protected void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    mouseEvent.consume();
                    return;
                }
                super.processMouseEvent(mouseEvent);
            }
        };
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.titleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/schema/ui/nodes/resources/plus.gif")));
        this.titleButton.setText(this.getTitleButtonText());
        this.titleButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.titleButton.setBorderPainted(false);
        this.titleButton.setContentAreaFilled(false);
        this.titleButton.setFocusPainted(false);
        this.titleButton.setHorizontalAlignment(2);
        this.titleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/schema/ui/nodes/resources/minus.gif")));
        this.titleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentationPanel.this.manageInnerPanel(actionEvent);
            }
        });
        this.innerPanel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.removeButton.setText(NbBundle.getMessage(DocumentationPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentationPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.contentScrollPane.setBorder(null);
        this.contentEditorPane.setContentType("text/xml");
        this.contentScrollPane.setViewportView(this.contentEditorPane);
        GroupLayout groupLayout = new GroupLayout((Container)this.innerPanel);
        this.innerPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.removeButton).add((Component)this.contentScrollPane, -1, 150, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.contentScrollPane, -1, 273, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.removeButton).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.innerPanel, -1, -1, Short.MAX_VALUE).add((Component)this.titleButton, -1, 172, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.titleButton).addPreferredGap(0).add((Component)this.innerPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void manageInnerPanel(ActionEvent actionEvent) {
        boolean bl = !this.titleButton.isSelected();
        this.setExpanded(bl);
    }

    void setExpanded(boolean bl) {
        this.titleButton.setSelected(bl);
        this.titleButton.setText(this.getTitleButtonText());
        this.innerPanel.setVisible(bl);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.updateState(State.REMOVED);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ADDED,
        REMOVED,
        MODIFIED,
        UNMODIFIED;

    }
}

