/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.DataEntryTableModel;
import org.netbeans.modules.identity.profile.api.configurator.MultiSelectTableModel;
import org.netbeans.modules.identity.profile.api.configurator.ProviderConfigFactory;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanismHelper;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderConfigurator
extends Configurator {
    public static final String WSP_SERVICE_TYPE = "urn:wsp";
    private static final String DUMMY_PROVIDER_NAME = "org.netbeans.modules.identity.profile.api.DummyProviderName";
    private static final String AM_CONFIG_FILE_PROP = "AM_CONFIG_FILE";
    private static final String PROVIDER_ID_PROPERTY = "ProviderID";
    private static final String SERVICE_URI_PROPERTY = "ServiceURI";
    private String providerName;
    private Type type;
    private String serverID;
    private ProviderConfig providerConfig;
    private String keystoreLocation;
    private String keystorePassword;
    private String keyPassword;
    private boolean disabled = false;
    private JLabel errorComponent;
    private String errorText;
    private Collection<ChangeListener> listeners;
    private SecurityMechanismHelper secMechHelper;

    private ProviderConfigurator(String string, Type type, String string2) {
        this.providerName = string;
        this.type = type;
        this.serverID = string2;
        this.secMechHelper = new SecurityMechanismHelper(string2);
        this.secMechHelper.getAllSecurityMechanisms();
    }

    public static ProviderConfigurator getConfigurator(String string, Type type, Configurator.AccessMethod accessMethod, Object object, String string2) {
        ProviderConfigurator providerConfigurator = new ProviderConfigurator(string, type, string2);
        providerConfigurator.init(accessMethod, object);
        return providerConfigurator;
    }

    public static Collection<ProviderConfigurator> getAllConfigurators(Type type, Configurator.AccessMethod accessMethod, Object object, String string) {
        ProviderConfig providerConfig = ProviderConfigFactory.newInstance(accessMethod, DUMMY_PROVIDER_NAME, type, object);
        Collection<String> collection = providerConfig.getAllProviderNames();
        ArrayList<ProviderConfigurator> arrayList = new ArrayList<ProviderConfigurator>();
        for (String string2 : collection) {
            if (string2.equals(DUMMY_PROVIDER_NAME)) continue;
            arrayList.add(ProviderConfigurator.getConfigurator(string2, type, accessMethod, object, string));
        }
        return arrayList;
    }

    protected void init(Configurator.AccessMethod accessMethod, Object object) {
        this.providerConfig = ProviderConfigFactory.newInstance(accessMethod, this.providerName, this.type, object);
        this.setConfiguration(this.providerConfig);
        this.keystoreLocation = (String)this.getValue(Configurable.KEYSTORE_LOCATION);
        this.keystorePassword = (String)this.getValue(Configurable.KEYSTORE_PASSWORD);
        this.keyPassword = (String)this.getValue(Configurable.KEY_PASSWORD);
    }

    ProviderConfig getProviderConfig() {
        return this.providerConfig;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public void fireStateChanged() {
        if (this.listeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void addModifier(Configurable configurable, Object object) {
        this.addModifier(configurable, object, null);
    }

    public void addModifier(Configurable configurable, Object object, Object object2) {
        if (this.providerConfig == null) {
            return;
        }
        switch (configurable) {
            case SECURITY_MECH: {
                if (!(object instanceof JComboBox)) break;
                this.setModel((JComboBox)object, (Collection)object2);
                break;
            }
            case SECURITY_MECH_COLLECTION: {
                if (!(object instanceof JTable)) break;
                this.setMultiSelectTableModel((JTable)object, (Collection)object2, "LBL_SecurityMechanisms");
                break;
            }
            case SECURITY_MECH_ORDERING: {
                this.setSecurityMechOrderingModel((JTable)object, (Collection)object2);
                return;
            }
            case USERNAME_PASSWORD_PAIRS: {
                this.setDataEntryTableModel((JTable)object, new String[]{"LBL_UserName", "LBL_Password"});
                break;
            }
            case SERVER_PROPERTIES: {
                this.setModel((JComboBox)object, (Collection)object2);
                break;
            }
            case SIGN_RESPONSE: 
            case USE_DEFAULT_KEYSTORE: {
                if (object instanceof JCheckBox) break;
                break;
            }
            case KEY_ALIAS: 
            case KEY_PASSWORD: 
            case KEYSTORE_PASSWORD: 
            case KEYSTORE_LOCATION: 
            case PROVIDER_ID: 
            case SERVICE_URI: 
            case WSP_ENDPOINT: 
            case SERVICE_TYPE: 
            case USERNAME: 
            case PASSWORD: {
                assert (object instanceof JTextField);
                break;
            }
        }
        this.addModifierInternal(configurable, object);
    }

    public void addErrorComponent(JLabel jLabel) {
        this.errorComponent = jLabel;
        this.validate();
    }

    @Override
    public Object getValue(Enum enum_) {
        if (this.providerConfig == null) {
            return null;
        }
        if (enum_ instanceof Configurable) {
            switch ((Configurable)enum_) {
                case SECURITY_MECH: {
                    return this.getSecurityMechanism();
                }
                case SECURITY_MECH_COLLECTION: {
                    return this.getSecurityMechanisms();
                }
                case SIGN_RESPONSE: {
                    if (this.providerConfig.isResponseSignEnabled()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case KEY_ALIAS: {
                    return this.providerConfig.getKeyAlias();
                }
                case KEY_PASSWORD: {
                    return this.providerConfig.getKeyPassword();
                }
                case KEYSTORE_PASSWORD: {
                    return this.providerConfig.getKeyStorePassword();
                }
                case KEYSTORE_LOCATION: {
                    return this.providerConfig.getKeyStoreFile();
                }
                case PROVIDER_ID: {
                    return this.providerConfig.getProperty(PROVIDER_ID_PROPERTY);
                }
                case SERVICE_URI: {
                    return this.providerConfig.getProperty(SERVICE_URI_PROPERTY);
                }
                case WSP_ENDPOINT: {
                    return this.providerConfig.getWSPEndpoint();
                }
                case SERVER_PROPERTIES: {
                    return this.providerConfig.getServerProperties(this.serverID);
                }
                case USERNAME: {
                    return this.providerConfig.getUserName();
                }
                case PASSWORD: {
                    return this.providerConfig.getPassword();
                }
                case USERNAME_PASSWORD_PAIRS: {
                    return this.providerConfig.getUserNamePasswordPairs();
                }
                case SERVICE_TYPE: {
                    return this.providerConfig.getServiceType();
                }
                case USE_DEFAULT_KEYSTORE: {
                    return this.providerConfig.useDefaultKeyStore();
                }
            }
        }
        return null;
    }

    @Override
    public void setValue(Enum enum_, Object object) {
        if (this.providerConfig == null) {
            return;
        }
        if (enum_ instanceof Configurable) {
            switch ((Configurable)enum_) {
                case SECURITY_MECH: {
                    this.setSecurityMechanism((SecurityMechanism)object);
                    break;
                }
                case SECURITY_MECH_COLLECTION: {
                    this.setSecurityMechanisms((Collection)object);
                    break;
                }
                case SIGN_RESPONSE: {
                    if (Boolean.TRUE.equals(object)) {
                        this.providerConfig.setResponseSignEnabled(true);
                        break;
                    }
                    this.providerConfig.setResponseSignEnabled(false);
                    break;
                }
                case KEY_ALIAS: {
                    this.providerConfig.setKeyAlias((String)object);
                    break;
                }
                case KEYSTORE_PASSWORD: {
                    this.keystorePassword = (String)object;
                    break;
                }
                case KEYSTORE_LOCATION: {
                    this.keystoreLocation = (String)object;
                    break;
                }
                case KEY_PASSWORD: {
                    this.keyPassword = (String)object;
                    break;
                }
                case PROVIDER_ID: {
                    this.providerConfig.setProperty(PROVIDER_ID_PROPERTY, (String)object);
                    break;
                }
                case SERVICE_URI: {
                    this.providerConfig.setProperty(SERVICE_URI_PROPERTY, (String)object);
                    break;
                }
                case WSP_ENDPOINT: {
                    this.providerConfig.setWSPEndpoint((String)object);
                    break;
                }
                case SERVER_PROPERTIES: {
                    this.providerConfig.setServerProperties((ServerProperties)object);
                    break;
                }
                case USERNAME: {
                    this.providerConfig.setUserName((String)object);
                    break;
                }
                case PASSWORD: {
                    this.providerConfig.setPassword((String)object);
                    break;
                }
                case USERNAME_PASSWORD_PAIRS: {
                    this.providerConfig.setUserNamePasswordPairs((Collection)object);
                    break;
                }
                case SERVICE_TYPE: {
                    this.providerConfig.setServiceType((String)object);
                    break;
                }
                case USE_DEFAULT_KEYSTORE: {
                    if (Boolean.TRUE.equals(object)) {
                        this.providerConfig.setDefaultKeyStore(true);
                        break;
                    }
                    this.providerConfig.setDefaultKeyStore(false);
                }
            }
            this.validate();
            this.fireStateChanged();
        }
    }

    public SecurityMechanismHelper getSecMechHelper() {
        return this.secMechHelper;
    }

    public void setError(String string) {
        if (this.errorComponent != null) {
            this.errorComponent.setText(string);
        }
        this.errorText = string;
    }

    public void clearError() {
        if (this.errorComponent != null) {
            this.errorComponent.setText("");
        }
        this.errorText = null;
    }

    public String getError() {
        return this.errorText;
    }

    @Override
    public void save() {
        try {
            if (this.providerConfig != null) {
                if (!this.disabled) {
                    this.providerConfig.saveProvider();
                } else {
                    this.providerConfig.deleteProvider();
                }
            }
        }
        catch (ConfiguratorException configuratorException) {
            configuratorException.printStackTrace();
        }
    }

    public void close() {
        if (this.providerConfig != null) {
            this.providerConfig.close();
        }
    }

    @Override
    public String validate() {
        this.clearError();
        String string = this.validateKeyStore();
        if (string != null) {
            this.setError(string);
        }
        return string;
    }

    private String validateKeyStore() {
        SecurityMechanism securityMechanism = (SecurityMechanism)this.getValue(Configurable.SECURITY_MECH);
        if (securityMechanism == null) {
            return null;
        }
        Boolean bl = (Boolean)this.getValue(Configurable.SIGN_RESPONSE);
        if (securityMechanism.isPasswordCredentialRequired() && Boolean.FALSE.equals(bl)) {
            return null;
        }
        if (Boolean.FALSE.equals(this.getValue(Configurable.USE_DEFAULT_KEYSTORE))) {
            this.setKeyStore();
            String string = this.getError();
            if (string != null) {
                return string;
            }
            String string2 = (String)this.getValue(Configurable.KEY_ALIAS);
            if (this.keystoreLocation == null || this.keystoreLocation.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeystoreLocation");
            }
            if (this.keystorePassword == null || this.keystorePassword.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeystorePassword");
            }
            if (string2 == null || string2.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeyAlias");
            }
            if (this.keyPassword == null || this.keyPassword.trim().length() == 0) {
                return NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_InvalidKeyPassword");
            }
        }
        return null;
    }

    @Override
    public void disable() {
        this.disabled = true;
    }

    @Override
    public void enable() {
        this.disabled = false;
    }

    private void setKeyStore() {
        try {
            this.providerConfig.setKeyStore(this.convertToForwardSlash(this.keystoreLocation), this.keystorePassword, this.keyPassword);
        }
        catch (ConfiguratorException configuratorException) {
            this.setError(configuratorException.getCause().getMessage());
        }
    }

    private String convertToForwardSlash(String string) {
        return string == null ? null : string.replace('\\', '/');
    }

    private Collection<SecurityMechanism> getSecurityMechanisms() {
        return this.secMechHelper.getSecurityMechanismsFromURIs(this.providerConfig.getSecurityMechanisms());
    }

    private SecurityMechanism getSecurityMechanism() {
        Collection<SecurityMechanism> collection = this.getSecurityMechanisms();
        if (collection.size() > 0) {
            return collection.iterator().next();
        }
        return null;
    }

    private void setSecurityMechanisms(Collection<SecurityMechanism> collection) {
        this.providerConfig.setSecurityMechanisms(this.secMechHelper.getSecurityMechanismURIs(collection));
    }

    private void setSecurityMechanism(SecurityMechanism securityMechanism) {
        ArrayList<SecurityMechanism> arrayList = new ArrayList<SecurityMechanism>();
        if (arrayList != null) {
            arrayList.add(securityMechanism);
        }
        this.setSecurityMechanisms(arrayList);
    }

    private void setModel(JComboBox jComboBox, Collection<Object> collection) {
        Object[] objectArray = new Object[collection.size()];
        objectArray = collection.toArray(objectArray);
        jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        jComboBox.setSelectedIndex(0);
    }

    private void setMultiSelectTableModel(JTable jTable, Collection<Object> collection, String string) {
        Object[] objectArray = new Object[collection.size()];
        objectArray = collection.toArray(objectArray);
        MultiSelectTableModel multiSelectTableModel = new MultiSelectTableModel();
        multiSelectTableModel.addColumn((Object)NbBundle.getMessage(ProviderConfigurator.class, (String)string), objectArray);
        jTable.setModel(multiSelectTableModel);
    }

    private void setDataEntryTableModel(JTable jTable, String[] stringArray) {
        DataEntryTableModel dataEntryTableModel = new DataEntryTableModel();
        for (String string : stringArray) {
            dataEntryTableModel.addColumn(NbBundle.getMessage(ProviderConfigurator.class, (String)string));
        }
        jTable.setModel(dataEntryTableModel);
    }

    private void setSecurityMechOrderingModel(JTable jTable, Collection<SecurityMechanism> collection) {
        Collection<SecurityMechanism> collection2 = this.getSecurityMechanisms();
        SecurityMechanism[] securityMechanismArray = new SecurityMechanism[collection.size()];
        securityMechanismArray = collection.toArray(securityMechanismArray);
        SecurityMechanism[] securityMechanismArray2 = null;
        if (collection2 == null || collection2.size() != securityMechanismArray.length) {
            securityMechanismArray2 = securityMechanismArray;
        } else {
            securityMechanismArray2 = new SecurityMechanism[collection2.size()];
            securityMechanismArray2 = collection2.toArray(securityMechanismArray2);
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn((Object)NbBundle.getMessage(ProviderConfigurator.class, (String)"LBL_SecurityMechanismOrdering"), securityMechanismArray2);
        jTable.setModel(defaultTableModel);
        jTable.setSelectionMode(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Configurable {
        SECURITY_MECH,
        SECURITY_MECH_ORDERING,
        SECURITY_MECH_COLLECTION,
        SIGN_RESPONSE,
        KEY_ALIAS,
        KEY_PASSWORD,
        KEYSTORE_PASSWORD,
        KEYSTORE_LOCATION,
        PROVIDER_ID,
        SERVICE_URI,
        WSP_ENDPOINT,
        SERVER_PROPERTIES,
        USERNAME,
        PASSWORD,
        USERNAME_PASSWORD_PAIRS,
        SERVICE_TYPE,
        USE_DEFAULT_KEYSTORE,
        TRUST_AUTHORITY_CONFIG_LIST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WSP,
        WSC;

    }
}

