/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.column;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LinkButton
extends JButton
implements FocusListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private static final Color LINK_COLOR = new Color(0, 0, 255);
    private static final int FONT_SIZE;
    private boolean ignoreRevalidate = false;
    private Color defaultColor;

    public LinkButton(String string) {
        super(string);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addFocusListener(this);
        this.defaultColor = this.getForeground();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.ignoreRevalidate = true;
        this.setForeground(LINK_COLOR);
        this.ignoreRevalidate = false;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.ignoreRevalidate = true;
        this.setForeground(this.defaultColor);
        this.ignoreRevalidate = false;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map == null && Boolean.getBoolean("swing.aatext")) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (map != null) {
            graphics2D.addRenderingHints(map);
        }
        super.paintComponent(graphics2D);
    }

    public void revalidate() {
        if (!this.ignoreRevalidate) {
            super.revalidate();
        }
    }

    public void invalidate() {
        if (!this.ignoreRevalidate) {
            super.invalidate();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Rectangle rectangle = this.getBounds();
        rectangle.grow(0, FONT_SIZE);
        this.scrollRectToVisible(rectangle);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    static {
        Font font = UIManager.getFont("TextField.font");
        FONT_SIZE = font != null ? font.getSize() : 12;
    }
}

