/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.netbeans.modules.visualweb.classloaderprovider.CommonClassloaderProvider;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibManifest;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionComplib
extends Complib {
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private File packageFile;
    private File absoluteLibDir;
    private ResourceClassLoader resourceClassLoader;
    private LibraryClassLoader libClassLoader;

    ExtensionComplib(File file) throws ComplibException, IOException {
        assert (file != null);
        File file2 = new File(file, MANIFEST_FILE);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        Manifest manifest = new Manifest(bufferedInputStream);
        URL uRL = file.toURI().toURL();
        this.resourceClassLoader = new ResourceClassLoader(uRL);
        ComplibManifest complibManifest = ComplibManifest.getInstance(manifest, (ClassLoader)this.resourceClassLoader);
        this.initCompLibManifest(complibManifest);
        ((InputStream)bufferedInputStream).close();
        this.absoluteLibDir = file;
        this.initPaths();
    }

    @Override
    protected List<File> convertConfigPathToFileList(List<String> list) throws ComplibException {
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (String string : list) {
            File file = new File(this.absoluteLibDir, string);
            if (!file.canRead()) {
                throw new ComplibException("Unable to read '" + file + "'");
            }
            arrayList.add(file);
        }
        return arrayList;
    }

    protected File[] convertConfigPathToFileArray(List<String> list) throws ComplibException {
        File[] fileArray = new File[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            File file = new File(this.absoluteLibDir, string);
            if (!file.canRead()) {
                throw new ComplibException("Unable to read '" + file + "'");
            }
            fileArray[i] = file;
        }
        return fileArray;
    }

    String getPackageFileBaseName() {
        return this.packageFile == null ? null : this.packageFile.getName();
    }

    public String getDirectoryBaseName() {
        return this.getDirectory().getName();
    }

    public File getDirectory() {
        return this.absoluteLibDir;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.libClassLoader == null) {
            this.libClassLoader = new LibraryClassLoader();
            this.libClassLoader.appendToClassPath(this.getRuntimePath());
            this.libClassLoader.appendToClassPath(this.getDesignTimePath());
            this.libClassLoader.appendToClassPath(this.getHelpPath());
        }
        return this.libClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    BeanInfo getBeanInfo(String string) throws ClassNotFoundException, IntrospectionException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Class<?> clazz = Class.forName(string, true, this.getClassLoader());
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return beanInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public String toString() {
        return this.getIdentifier().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryClassLoader
    extends URLClassLoader {
        private static final ClassLoader parentClassLoader;

        public LibraryClassLoader() {
            super(new URL[0], parentClassLoader);
        }

        public void appendToClassPath(List<File> list) {
            for (File file : list) {
                try {
                    super.addURL(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    IdeUtil.logWarning(malformedURLException);
                }
            }
        }

        static {
            CommonClassloaderProvider commonClassloaderProvider = null;
            Properties properties = new Properties();
            properties.put("j2ee.platform", "1.5");
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(CommonClassloaderProvider.class));
            for (CommonClassloaderProvider commonClassloaderProvider2 : result.allInstances()) {
                if (!commonClassloaderProvider2.isCapableOf(properties)) continue;
                commonClassloaderProvider = commonClassloaderProvider2;
                break;
            }
            if (commonClassloaderProvider == null) {
                throw new RuntimeException("No Common Classloader Provider found.");
            }
            parentClassLoader = commonClassloaderProvider.getClassLoader();
        }
    }

    private static class ResourceClassLoader
    extends URLClassLoader {
        public ResourceClassLoader(URL uRL) {
            super(new URL[0], ResourceClassLoader.class.getClassLoader());
            this.addURL(uRL);
        }
    }
}

