/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.extension.openide.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RaveFileCopy {
    private static boolean use_nio = true;

    public static boolean fileCopy(File file, File file2) throws IOException {
        if (!file.exists() || file2.exists()) {
            return false;
        }
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        file2.createNewFile();
        if (use_nio) {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileChannel.close();
            fileChannel2.close();
        } else {
            int n;
            int n2 = 65536;
            byte[] byArray = new byte[n2];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), n2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), n2);
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, n2)) > -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            ((InputStream)bufferedInputStream).close();
        }
        return true;
    }

    static {
        try {
            Pattern pattern;
            Matcher matcher;
            if (System.getProperty("os.name").equalsIgnoreCase("Linux") && (matcher = (pattern = Pattern.compile("(\\d)\\.(\\d+)\\..*")).matcher(System.getProperty("os.version"))).matches() && Integer.parseInt(matcher.group(1)) == 2 && Integer.parseInt(matcher.group(2)) > 4) {
                use_nio = false;
            }
            if (System.getProperty("openide.noniocopy") != null) {
                use_nio = false;
            }
            if (System.getProperty("openide.niocopy") != null) {
                use_nio = true;
            }
        }
        catch (Exception exception) {
            use_nio = false;
        }
    }
}

