/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.spi;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.xml.search.api.SearchElement;
import org.netbeans.modules.xml.search.api.SearchTarget;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.ui.ModelCookie;
import org.netbeans.modules.xml.xam.ui.highlight.Highlight;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightGroup;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.w3c.dom.Element;

public interface SearchProvider {
    public Object getRoot();

    public SearchTarget[] getTargets();

    public SearchElement getElement(Object var1);

    public static class Adapter
    implements SearchProvider {
        private Object myRoot;
        private DataObject myData;
        private Map<Component, SearchElement> myElements;

        public Adapter(Object object) {
            this(object, null);
        }

        public Adapter(Object object, DataObject dataObject) {
            this.myData = dataObject;
            this.myRoot = object;
            this.myElements = new WeakHashMap<Component, SearchElement>();
        }

        protected Component getRoot(DataObject dataObject) {
            return null;
        }

        protected String getType(Component component) {
            return null;
        }

        protected Node getNode(Component component) {
            return null;
        }

        protected void gotoVisual(Component component) {
        }

        protected void gotoSource(Component component) {
        }

        protected Icon getIcon(Component component) {
            return new ImageIcon(this.getNode(component).getIcon(1));
        }

        protected String getName(Component component) {
            String string = null;
            if (component instanceof Named) {
                string = ((Named)component).getName();
            }
            if (string == null && component instanceof DocumentComponent) {
                string = this.getDocumentName((DocumentComponent)component);
            }
            if (string == null) {
                string = "";
            }
            return string;
        }

        private String getDocumentName(DocumentComponent documentComponent) {
            org.w3c.dom.Element element = documentComponent.getPeer();
            if (element == null) {
                return null;
            }
            return element.getTagName();
        }

        protected String getToolTip(Component component) {
            String string = this.getType(component);
            if (string != null) {
                int n = string.lastIndexOf(".");
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                return "<html>" + string + " <b>" + this.getName(component) + "</b></html>";
            }
            return this.getName(component);
        }

        public final Object getRoot() {
            if (this.myRoot == null) {
                this.myRoot = this.getRoot(this.myData);
            }
            return this.myRoot;
        }

        public SearchTarget[] getTargets() {
            return null;
        }

        public final SearchElement getElement(Object object) {
            if (!(object instanceof Component)) {
                return null;
            }
            Component component = (Component)object;
            SearchElement searchElement = this.myElements.get(component);
            if (searchElement != null) {
                return searchElement;
            }
            Component component2 = component.getParent();
            SearchElement searchElement2 = null;
            if (component2 != null) {
                searchElement2 = this.getElement(component2);
            }
            searchElement = new Element(component, searchElement2);
            this.myElements.put(component, searchElement);
            return searchElement;
        }

        protected final DataObject getDataObject() {
            return this.myData;
        }

        protected final Model getModel(DataObject dataObject) {
            ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
            if (modelCookie == null) {
                return null;
            }
            try {
                return modelCookie.getModel();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        protected final void highlight(Component component) {
            HighlightGroup highlightGroup2;
            HighlightManager highlightManager = HighlightManager.getDefault();
            List list = highlightManager.getHighlightGroups("search");
            if (list != null) {
                for (HighlightGroup highlightGroup2 : list) {
                    highlightManager.removeHighlightGroup(highlightGroup2);
                }
            }
            HighlightGroup highlightGroup3 = new HighlightGroup("search");
            highlightGroup2 = new Highlight(component, "searchResult");
            highlightGroup3.addHighlight((Highlight)highlightGroup2);
            highlightManager.addHighlightGroup(highlightGroup3);
        }

        private final class Element
        extends SearchElement.Adapter {
            private Component myComponent;

            private Element(Component component, SearchElement searchElement) {
                super(Adapter.this.getName(component), Adapter.this.getToolTip(component), Adapter.this.getIcon(component), searchElement);
                this.myComponent = component;
            }

            public void gotoSource() {
                Adapter.this.gotoSource(this.myComponent);
            }

            public void gotoVisual() {
                Adapter.this.gotoVisual(this.myComponent);
            }

            public boolean isDeleted() {
                return this.myComponent.getModel() == null;
            }
        }
    }
}

