/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModuleFilter;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class AddModulePanel
extends JPanel {
    private static final String FILTER_DESCRIPTION = AddModulePanel.getMessage("LBL_FilterDescription");
    private static Rectangle lastSize;
    private CustomizerComponentFactory.DependencyListModel universeModules;
    private RequestProcessor.Task filterTask;
    private AddModuleFilter filterer;
    private URL currectJavadoc;
    private final SingleModuleProperties props;
    private JLabel descLabel;
    private JTextPane descValue;
    private JScrollPane descValueSP;
    private JLabel filter;
    JTextField filterValue;
    private JLabel moduleLabel;
    JList moduleList;
    private JScrollPane moduleSP;
    private JButton showJavadocButton;
    private JCheckBox showNonAPIModules;

    public static ModuleDependency[] selectDependencies(SingleModuleProperties singleModuleProperties) {
        final AddModulePanel addModulePanel = new AddModulePanel(singleModuleProperties);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addModulePanel, AddModulePanel.getMessage("CTL_AddModuleDependencyTitle"));
        dialogDescriptor.setHelpCtx(new HelpCtx(AddModulePanel.class));
        dialogDescriptor.setClosingOptions(new Object[0]);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogDescriptor.setButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource()) && addModulePanel.getSelectedDependencies().length == 0) {
                    return;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        if (lastSize != null) {
            dialog.setBounds(lastSize);
        }
        dialog.setVisible(true);
        lastSize = dialog.getBounds();
        dialog.dispose();
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            return addModulePanel.getSelectedDependencies();
        }
        return new ModuleDependency[0];
    }

    public AddModulePanel(final SingleModuleProperties singleModuleProperties) {
        this.props = singleModuleProperties;
        this.initComponents();
        this.initAccessibility();
        this.filterValue.setText(FILTER_DESCRIPTION);
        this.fillUpUniverseModules();
        this.moduleList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.moduleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AddModulePanel.this.showDescription();
                AddModulePanel.this.currectJavadoc = null;
                ModuleDependency[] moduleDependencyArray = AddModulePanel.this.getSelectedDependencies();
                if (moduleDependencyArray.length == 1) {
                    NbPlatform nbPlatform = singleModuleProperties.getActivePlatform();
                    if (nbPlatform == null) {
                        AddModulePanel.this.currectJavadoc = Util.findJavadocForNetBeansOrgModules(moduleDependencyArray[0]);
                    } else {
                        AddModulePanel.this.currectJavadoc = Util.findJavadoc(moduleDependencyArray[0], nbPlatform);
                    }
                }
                AddModulePanel.this.showJavadocButton.setEnabled(AddModulePanel.this.currectJavadoc != null);
            }
        });
        this.filterValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!FILTER_DESCRIPTION.equals(AddModulePanel.this.filterValue.getText())) {
                    AddModulePanel.this.search();
                }
            }
        });
        String[][] stringArray = new String[][]{{"selectPreviousRow", "selectPreviousRow"}, {"selectNextRow", "selectNextRow"}, {"selectFirstRow", "selectFirstRow"}, {"selectLastRow", "selectLastRow"}, {"scrollUp", "scrollUp"}, {"scrollDown", "scrollDown"}};
        String[][] stringArray2 = new String[][]{{"selection-page-up", "page-up"}, {"selection-page-down", "page-down"}, {"selection-up", "caret-up"}, {"selection-down", "caret-down"}};
        AddModulePanel.exchangeCommands(stringArray, this.moduleList, this.filterValue);
        AddModulePanel.exchangeCommands(stringArray2, this.descValue, this.filterValue);
    }

    private static void exchangeCommands(String[][] stringArray, final JComponent jComponent, JComponent jComponent2) {
        InputMap inputMap = jComponent.getInputMap();
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        ActionMap actionMap = jComponent.getActionMap();
        InputMap inputMap2 = jComponent2.getInputMap();
        ActionMap actionMap2 = jComponent2.getActionMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            String string2 = stringArray[i][1];
            final Action action = actionMap.get(string2);
            if (action == null) continue;
            actionMap2.put(string2, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    action.actionPerformed(new ActionEvent(jComponent, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                }
            });
            for (int j = 0; j < keyStrokeArray.length; ++j) {
                if (!inputMap.get(keyStrokeArray[j]).equals(string)) continue;
                inputMap2.put(keyStrokeArray[j], string2);
            }
        }
    }

    private void fillUpUniverseModules() {
        this.filterValue.setEnabled(false);
        this.moduleList.setEnabled(false);
        this.showNonAPIModules.setEnabled(false);
        final String string = this.filterValue.getText();
        this.filterValue.setText(CustomizerComponentFactory.WAIT_VALUE);
        this.moduleList.setModel(CustomizerComponentFactory.createListWaitModel());
        final boolean bl = this.showNonAPIModules.isSelected();
        ModuleProperties.RP.post(new Runnable(){

            public void run() {
                final Set<ModuleDependency> set = AddModulePanel.this.props.getUniverseDependencies(true, !bl);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        AddModulePanel.this.universeModules = CustomizerComponentFactory.createSortedDependencyListModel(set);
                        AddModulePanel.this.filterer = null;
                        AddModulePanel.this.moduleList.setModel(AddModulePanel.this.universeModules);
                        AddModulePanel.this.moduleList.setEnabled(true);
                        AddModulePanel.this.filterValue.setEnabled(true);
                        AddModulePanel.this.showNonAPIModules.setEnabled(true);
                        AddModulePanel.this.filterValue.setText(string);
                        if (!FILTER_DESCRIPTION.equals(string)) {
                            AddModulePanel.this.search();
                        } else {
                            AddModulePanel.this.filterValue.selectAll();
                        }
                        AddModulePanel.this.filterValue.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void showDescription() {
        StyledDocument styledDocument = this.descValue.getStyledDocument();
        try {
            String string;
            styledDocument.remove(0, styledDocument.getLength());
            ModuleDependency[] moduleDependencyArray = this.getSelectedDependencies();
            if (moduleDependencyArray.length != 1) {
                return;
            }
            String string2 = moduleDependencyArray[0].getModuleEntry().getLongDescription();
            if (string2 != null) {
                styledDocument.insertString(0, string2, null);
            }
            if ((string = this.filterValue.getText().trim()).length() != 0 && !FILTER_DESCRIPTION.equals(string)) {
                styledDocument.insertString(styledDocument.getLength(), "\n\n", null);
                Style style = styledDocument.addStyle(null, null);
                style.addAttribute(StyleConstants.Bold, Boolean.TRUE);
                styledDocument.insertString(styledDocument.getLength(), AddModulePanel.getMessage("TEXT_matching_filter_contents"), style);
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
                if (string.length() > 0) {
                    String string3 = string.toLowerCase(Locale.US);
                    Style style2 = styledDocument.addStyle(null, null);
                    style2.addAttribute(StyleConstants.Background, new Color(246, 248, 139));
                    boolean bl = false;
                    Style style3 = styledDocument.addStyle(null, null);
                    style3.addAttribute(StyleConstants.Background, new Color(235, 235, 235));
                    if (this.filterer == null) {
                        return;
                    }
                    for (String string4 : this.filterer.getMatchesFor(string, moduleDependencyArray[0])) {
                        int n = styledDocument.getLength();
                        styledDocument.insertString(n, string4, bl ? style3 : null);
                        int n2 = string4.toLowerCase(Locale.US).indexOf(string3);
                        while (n2 != -1) {
                            styledDocument.setCharacterAttributes(n + n2, string3.length(), style2, true);
                            n2 = string4.toLowerCase(Locale.US).indexOf(string3, n2 + 1);
                        }
                        styledDocument.insertString(styledDocument.getLength(), "\n", bl ? style3 : null);
                        bl ^= true;
                    }
                } else {
                    Style style4 = styledDocument.addStyle(null, null);
                    style4.addAttribute(StyleConstants.Italic, Boolean.TRUE);
                    styledDocument.insertString(styledDocument.getLength(), AddModulePanel.getMessage("TEXT_no_filter_specified"), style4);
                }
            }
            this.descValue.setCaretPosition(0);
        }
        catch (BadLocationException badLocationException) {
            Util.err.notify(1, (Throwable)badLocationException);
        }
    }

    public ModuleDependency[] getSelectedDependencies() {
        ModuleDependency[] moduleDependencyArray;
        if (CustomizerComponentFactory.isWaitModel(this.moduleList.getModel())) {
            moduleDependencyArray = new ModuleDependency[]{};
        } else {
            Object[] objectArray = this.moduleList.getSelectedValues();
            moduleDependencyArray = new ModuleDependency[objectArray.length];
            System.arraycopy(objectArray, 0, moduleDependencyArray, 0, objectArray.length);
        }
        return moduleDependencyArray;
    }

    private void search() {
        String string;
        if (this.filterTask != null) {
            this.filterTask.cancel();
            this.filterTask = null;
        }
        if ((string = this.filterValue.getText()).length() == 0) {
            this.moduleList.setModel(this.universeModules);
            this.moduleList.setSelectedIndex(0);
            this.moduleList.ensureIndexIsVisible(0);
        } else {
            final Runnable runnable = new Runnable(){

                public void run() {
                    final Set<ModuleDependency> set = AddModulePanel.this.filterer.getMatches(string);
                    AddModulePanel.this.filterTask = null;
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            if (!string.equals(AddModulePanel.this.filterValue.getText())) {
                                return;
                            }
                            AddModulePanel.this.moduleList.setModel(CustomizerComponentFactory.createDependencyListModel(set));
                            int n = set.isEmpty() ? -1 : 0;
                            AddModulePanel.this.moduleList.setSelectedIndex(n);
                            AddModulePanel.this.moduleList.ensureIndexIsVisible(n);
                        }
                    });
                }
            };
            if (this.filterer == null) {
                this.moduleList.setModel(CustomizerComponentFactory.createListWaitModel());
                this.filterTask = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (AddModulePanel.this.filterer == null) {
                            AddModulePanel.this.filterer = new AddModuleFilter(AddModulePanel.this.universeModules.getDependencies(), AddModulePanel.this.props.getCodeNameBase());
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_AddModuleDependency"));
        this.filterValue.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_LBL_Filter"));
        this.moduleList.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_CTL_ModuleList"));
        this.moduleSP.getVerticalScrollBar().getAccessibleContext().setAccessibleName(AddModulePanel.getMessage("ACS_CTL_ModuleListVerticalScroll"));
        this.moduleSP.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_CTL_ModuleListVerticalScroll"));
        this.moduleSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(AddModulePanel.getMessage("ACS_CTL_ModuleListHorizontalScroll"));
        this.moduleSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_CTL_ModuleListHorizontalScroll"));
        this.showNonAPIModules.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_ShowNonApiModules"));
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(AddModulePanel.class, (String)string);
    }

    private void initComponents() {
        this.moduleLabel = new JLabel();
        this.moduleSP = new JScrollPane();
        this.moduleList = new JList();
        this.descLabel = new JLabel();
        this.filter = new JLabel();
        this.filterValue = new JTextField();
        this.descValueSP = new JScrollPane();
        this.descValue = new JTextPane();
        this.showJavadocButton = new JButton();
        this.showNonAPIModules = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(400, 400));
        this.moduleLabel.setLabelFor(this.moduleList);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage(AddModulePanel.class, (String)"LBL_Module"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.moduleLabel, gridBagConstraints);
        this.moduleSP.setViewportView(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.moduleSP, gridBagConstraints);
        this.descLabel.setLabelFor(this.descValue);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(AddModulePanel.class, (String)"LBL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.descLabel, gridBagConstraints);
        this.filter.setLabelFor(this.filterValue);
        Mnemonics.setLocalizedText((JLabel)this.filter, (String)NbBundle.getMessage(AddModulePanel.class, (String)"LBL_Filter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.filter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.filterValue, gridBagConstraints);
        this.descValue.setEditable(false);
        this.descValue.setPreferredSize(new Dimension(6, 100));
        this.descValueSP.setViewportView(this.descValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.descValueSP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showJavadocButton, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("CTL_ShowJavadoc"));
        this.showJavadocButton.setEnabled(false);
        this.showJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddModulePanel.this.showJavadoc(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.showJavadocButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showNonAPIModules, (String)NbBundle.getMessage(AddModulePanel.class, (String)"CTL_ShowNonAPIModules"));
        this.showNonAPIModules.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showNonAPIModules.setMargin(new Insets(0, 0, 0, 0));
        this.showNonAPIModules.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddModulePanel.this.showNonAPIModulesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.showNonAPIModules, gridBagConstraints);
    }

    private void showNonAPIModulesActionPerformed(ActionEvent actionEvent) {
        this.fillUpUniverseModules();
    }

    private void showJavadoc(ActionEvent actionEvent) {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.currectJavadoc);
    }
}

