/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrandingSupport {
    private final SuiteProject suiteProject;
    private final SuiteProperties suiteProperties;
    private Set<ModuleEntry> brandedModules;
    private Set<BundleKey> brandedBundleKeys;
    private Set<BrandedFile> brandedFiles;
    private NbPlatform platform;
    private final File brandingDir;
    public static final String BRANDING_DIR_PROPERTY = "branding.dir";
    private static final String BUNDLE_NAME = "Bundle.properties";

    public static BrandingSupport getInstance(SuiteProperties suiteProperties) throws IOException {
        return new BrandingSupport(suiteProperties);
    }

    private BrandingSupport(SuiteProperties suiteProperties) throws IOException {
        this.suiteProperties = suiteProperties;
        this.suiteProject = suiteProperties.getProject();
        File file = this.suiteProject.getProjectDirectoryFile();
        assert (file != null && file.exists());
        this.brandingDir = new File(file, this.getNameOfBrandingFolder());
        this.init();
    }

    public File getProjectDirectory() {
        return this.suiteProject.getProjectDirectoryFile();
    }

    public File getBrandingRoot() {
        return new File(this.getProjectDirectory(), this.getNameOfBrandingFolder());
    }

    public File getModuleEntryDirectory(ModuleEntry moduleEntry) {
        String string = PropertyUtils.relativizeFile((File)moduleEntry.getClusterDirectory(), (File)moduleEntry.getJarLocation());
        return new File(this.getBrandingRoot(), string);
    }

    public File getLocalizingBundle(ModuleEntry moduleEntry) {
        String string;
        ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(moduleEntry.getJarLocation());
        File file = null;
        if (manifestManager != null && (string = manifestManager.getLocalizingBundle()) != null) {
            file = new File(this.getModuleEntryDirectory(moduleEntry), string);
        }
        return file;
    }

    public boolean isBranded(BundleKey bundleKey) {
        boolean bl = this.getBrandedBundleKeys().contains(bundleKey);
        return bl;
    }

    public boolean isBranded(BrandedFile brandedFile) {
        return this.getBrandedFiles().contains(brandedFile);
    }

    public boolean isBranded(ModuleEntry moduleEntry) {
        boolean bl = this.getBrandedModules().contains(moduleEntry);
        assert (bl == this.getModuleEntryDirectory(moduleEntry).exists());
        return bl;
    }

    public Set<ModuleEntry> getBrandedModules() {
        return this.brandedModules;
    }

    public Set<BundleKey> getBrandedBundleKeys() {
        return this.brandedBundleKeys;
    }

    public Set getBrandedFiles() {
        return this.brandedFiles;
    }

    public Set<BundleKey> getLocalizingBundleKeys(String string, Set<String> set) {
        ModuleEntry moduleEntry = this.getModuleEntry(string);
        return moduleEntry != null ? this.getLocalizingBundleKeys(moduleEntry, set) : null;
    }

    public Set<BundleKey> getLocalizingBundleKeys(ModuleEntry moduleEntry, Set<String> set) {
        HashSet<BundleKey> hashSet = new HashSet<BundleKey>();
        Iterator<BundleKey> iterator = this.getBrandedBundleKeys().iterator();
        while (iterator.hasNext() && hashSet.size() != set.size()) {
            BundleKey bundleKey = iterator.next();
            if (!set.contains(bundleKey.getKey())) continue;
            hashSet.add(bundleKey);
        }
        if (hashSet.size() != set.size()) {
            this.loadLocalizedBundlesFromPlatform(moduleEntry, set, hashSet);
        }
        return hashSet.size() != set.size() ? null : hashSet;
    }

    public BrandedFile getBrandedFile(String string, String string2) {
        ModuleEntry moduleEntry = this.getModuleEntry(string);
        return moduleEntry != null ? this.getBrandedFile(moduleEntry, string2) : null;
    }

    public BrandedFile getBrandedFile(ModuleEntry moduleEntry, String string) {
        BrandedFile brandedFile = null;
        try {
            brandedFile = new BrandedFile(moduleEntry, string);
            for (BrandedFile brandedFile2 : this.getBrandedFiles()) {
                if (!brandedFile.equals(brandedFile2)) continue;
                brandedFile = brandedFile2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            brandedFile = null;
        }
        return brandedFile;
    }

    public BundleKey getBundleKey(String string, String string2, String string3) {
        Set<BundleKey> set = this.getBundleKeys(string, string2, Collections.singleton(string3));
        return set == null ? null : (BundleKey)set.toArray()[0];
    }

    public Set<BundleKey> getBundleKeys(String string, String string2, Set<String> set) {
        ModuleEntry moduleEntry = this.getModuleEntry(string);
        return moduleEntry != null ? this.getBundleKeys(moduleEntry, string2, set) : null;
    }

    public Set<BundleKey> getBundleKeys(ModuleEntry moduleEntry, String string, Set<String> set) {
        HashSet<BundleKey> hashSet = new HashSet<BundleKey>();
        Iterator<BundleKey> iterator = this.getBrandedBundleKeys().iterator();
        while (iterator.hasNext() && hashSet.size() != set.size()) {
            BundleKey bundleKey = iterator.next();
            if (!set.contains(bundleKey.getKey())) continue;
            hashSet.add(bundleKey);
        }
        if (hashSet.size() != set.size()) {
            try {
                this.loadLocalizedBundlesFromPlatform(moduleEntry, string, set, hashSet);
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        return hashSet.size() != set.size() ? null : hashSet;
    }

    private ModuleEntry getModuleEntry(String string) {
        NbPlatform nbPlatform = this.getActivePlatform();
        return nbPlatform != null ? nbPlatform.getModule(string) : null;
    }

    private NbPlatform getActivePlatform() {
        NbPlatform nbPlatform = this.suiteProperties.getActivePlatform();
        if (nbPlatform != null) {
            return nbPlatform;
        }
        return NbPlatform.getDefaultPlatform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brandFile(BrandedFile brandedFile) throws IOException {
        if (!brandedFile.isModified()) {
            return;
        }
        File file = brandedFile.getFileLocation();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        assert (file.exists());
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = brandedFile.getBrandingSource().openStream();
            outputStream = new FileOutputStream(file);
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            this.brandedFiles.add(brandedFile);
            brandedFile.modified = false;
        }
    }

    public void brandFile(BrandedFile brandedFile, Runnable runnable) throws IOException {
        if (!brandedFile.isModified()) {
            return;
        }
        runnable.run();
        this.brandedFiles.add(brandedFile);
        brandedFile.modified = false;
    }

    public void brandBundleKey(BundleKey bundleKey) throws IOException {
        if (bundleKey == null) {
            return;
        }
        this.brandBundleKeys(Collections.singleton(bundleKey));
    }

    public void brandBundleKeys(Set<BundleKey> set) throws IOException {
        Object object;
        this.init();
        HashMap<File, Object> hashMap = new HashMap<File, Object>();
        for (BundleKey object2 : set) {
            if (!object2.isModified()) continue;
            object = (EditableProperties)hashMap.get(object2.getBrandingBundle());
            if (object == null) {
                File file = object2.getBrandingBundle();
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                object = BrandingSupport.getEditableProperties(file);
                hashMap.put(object2.getBrandingBundle(), object);
            }
            object.setProperty(object2.getKey(), object2.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (File)entry.getKey();
            assert (((File)object).exists());
            BrandingSupport.storeEditableProperties((EditableProperties)entry.getValue(), (File)object);
            for (BundleKey bundleKey : set) {
                File file = bundleKey.getBrandingBundle();
                if (!file.equals(object)) continue;
                this.brandedBundleKeys.add(bundleKey);
                bundleKey.modified = false;
                this.brandedModules.add(bundleKey.getModuleEntry());
            }
        }
    }

    private void init() throws IOException {
        NbPlatform nbPlatform = this.getActivePlatform();
        if (nbPlatform == null) {
            return;
        }
        if (this.brandedModules == null || !nbPlatform.equals(this.platform)) {
            this.brandedModules = new HashSet<ModuleEntry>();
            this.brandedBundleKeys = new HashSet<BundleKey>();
            this.brandedFiles = new HashSet<BrandedFile>();
            this.platform = nbPlatform;
            if (this.brandingDir.exists()) {
                assert (this.brandingDir.isDirectory());
                this.scanModulesInBrandingDir(this.brandingDir, this.platform.getModules());
            }
        }
    }

    private void scanModulesInBrandingDir(File file, ModuleEntry[] moduleEntryArray) throws IOException {
        if (file.getName().endsWith(".jar")) {
            ModuleEntry moduleEntry = null;
            for (ModuleEntry moduleEntry2 : moduleEntryArray) {
                if (!this.isBrandingForModuleEntry(file, moduleEntry2)) continue;
                this.scanBrandedFiles(file, moduleEntry2);
                moduleEntry = moduleEntry2;
                break;
            }
            if (moduleEntry != null) {
                this.brandedModules.add(moduleEntry);
            }
        } else {
            String[] stringArray = file.list();
            assert (stringArray != null);
            for (String string : stringArray) {
                File file2 = new File(file, string);
                if (!file2.isDirectory()) continue;
                this.scanModulesInBrandingDir(file2, moduleEntryArray);
            }
        }
    }

    private void scanBrandedFiles(File file, ModuleEntry moduleEntry) throws IOException {
        String[] stringArray = file.list();
        assert (stringArray != null);
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (!file2.isDirectory()) {
                if (file2.getName().endsWith(BUNDLE_NAME)) {
                    this.loadBundleKeys(moduleEntry, file2);
                    continue;
                }
                this.loadBrandedFiles(moduleEntry, file2);
                continue;
            }
            this.scanBrandedFiles(file2, moduleEntry);
        }
    }

    private void loadBundleKeys(ModuleEntry moduleEntry, File file) throws IOException {
        EditableProperties editableProperties = BrandingSupport.getEditableProperties(file);
        for (Map.Entry entry : editableProperties.entrySet()) {
            this.brandedBundleKeys.add(new BundleKey(moduleEntry, file, (String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void loadBrandedFiles(ModuleEntry moduleEntry, File file) throws IOException {
        String string = PropertyUtils.relativizeFile((File)this.getModuleEntryDirectory(moduleEntry), (File)file);
        BrandedFile brandedFile = new BrandedFile(moduleEntry, file.toURI().toURL(), string);
        this.brandedFiles.add(brandedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableProperties getEditableProperties(File file) throws IOException {
        EditableProperties editableProperties = new EditableProperties(true);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            editableProperties.load((InputStream)fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return editableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEditableProperties(EditableProperties editableProperties, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            editableProperties.store((OutputStream)fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private void loadLocalizedBundlesFromPlatform(ModuleEntry moduleEntry, Set<String> set, Set<BundleKey> set2) {
        EditableProperties editableProperties = ModuleList.loadBundleInfo(moduleEntry.getSourceLocation()).toEditableProperties();
        for (String string : editableProperties.keySet()) {
            if (!set.contains(string)) continue;
            String string2 = editableProperties.getProperty(string);
            set2.add(new BundleKey(moduleEntry, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedBundlesFromPlatform(ModuleEntry moduleEntry, String string, Set<String> set, Set<BundleKey> set2) throws IOException {
        EditableProperties editableProperties = new EditableProperties();
        JarFile jarFile = new JarFile(moduleEntry.getJarLocation());
        JarEntry jarEntry = jarFile.getJarEntry(string);
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        File file = new File(this.getModuleEntryDirectory(moduleEntry), string);
        try {
            editableProperties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        for (String string2 : editableProperties.keySet()) {
            if (!set.contains(string2)) continue;
            String string3 = editableProperties.getProperty(string2);
            set2.add(new BundleKey(moduleEntry, file, string2, string3));
        }
    }

    private boolean isBrandingForModuleEntry(File file, ModuleEntry moduleEntry) {
        boolean bl = moduleEntry.getJarLocation().getName().equals(file.getName());
        if (bl) {
            String string = PropertyUtils.relativizeFile((File)moduleEntry.getClusterDirectory(), (File)moduleEntry.getJarLocation().getParentFile());
            String string2 = PropertyUtils.relativizeFile((File)this.brandingDir, (File)file.getParentFile());
            bl = string.equals(string2);
        }
        return bl;
    }

    public String getNameOfBrandingFolder() {
        String string = this.suiteProject.getEvaluator().getProperty(BRANDING_DIR_PROPERTY);
        if (string == null) {
            string = "branding";
        }
        return string;
    }

    public class BrandedFile {
        private final ModuleEntry moduleEntry;
        private final String entryPath;
        private URL brandingSource;
        private boolean modified = false;

        private BrandedFile(ModuleEntry moduleEntry, String string) throws MalformedURLException {
            this(moduleEntry, null, string);
        }

        private BrandedFile(ModuleEntry moduleEntry, URL uRL, String string) throws MalformedURLException {
            this.moduleEntry = moduleEntry;
            this.entryPath = string;
            if (uRL == null) {
                this.brandingSource = moduleEntry.getJarLocation().toURI().toURL();
                this.brandingSource = new URL("jar:" + this.brandingSource + "!/" + this.entryPath);
            } else {
                this.brandingSource = uRL;
            }
        }

        public ModuleEntry getModuleEntry() {
            return this.moduleEntry;
        }

        public String getEntryPath() {
            return this.entryPath;
        }

        public File getFileLocation() {
            return new File(BrandingSupport.this.getModuleEntryDirectory(this.getModuleEntry()), this.getEntryPath());
        }

        public URL getBrandingSource() {
            return this.brandingSource;
        }

        public void setBrandingSource(URL uRL) {
            if (!Utilities.compareObjects((Object)uRL, (Object)this.brandingSource)) {
                this.modified = true;
            }
            this.brandingSource = uRL;
        }

        public void setBrandingSource(File file) throws MalformedURLException {
            this.setBrandingSource(file.toURI().toURL());
        }

        public boolean isModified() {
            return this.modified;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof BrandedFile) {
                BrandedFile brandedFile = (BrandedFile)object;
                bl = this.getModuleEntry().equals(brandedFile.getModuleEntry()) && this.getFileLocation().equals(brandedFile.getFileLocation());
            }
            return bl;
        }

        public int hashCode() {
            return 0;
        }
    }

    public final class BundleKey {
        private final File brandingBundle;
        private final ModuleEntry moduleEntry;
        private final String key;
        private String value;
        private boolean modified = false;

        private BundleKey(ModuleEntry moduleEntry, File file, String string, String string2) {
            this.moduleEntry = moduleEntry;
            this.key = string;
            this.value = string2;
            this.brandingBundle = file;
        }

        private BundleKey(ModuleEntry moduleEntry, String string, String string2) {
            this(moduleEntry, brandingSupport.getLocalizingBundle(moduleEntry), string, string2);
        }

        public ModuleEntry getModuleEntry() {
            return this.moduleEntry;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            if (!this.value.equals(string)) {
                this.modified = true;
            }
            this.value = string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof BundleKey) {
                BundleKey bundleKey = (BundleKey)object;
                bl = this.getKey().equals(bundleKey.getKey()) && this.getModuleEntry().equals(bundleKey.getModuleEntry()) && this.getBrandingBundle().equals(bundleKey.getBrandingBundle());
            }
            return bl;
        }

        public int hashCode() {
            return 0;
        }

        boolean isModified() {
            return this.modified;
        }

        public File getBrandingBundle() {
            return this.brandingBundle;
        }
    }
}

