/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.ImportCDCProjectPanel;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.NewCDCProjectWizardIterator;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ProjectPanel;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportCDCProjectWizardIterator
implements TemplateWizard.Iterator {
    boolean platformInstall;
    int currentIndex;
    PlatformInstallPanel.WizardPanel platformPanel;
    ImportCDCProjectPanel.WizardPanel sourcesPanel;
    ProjectPanel.WizardPanel projectPanel;
    static final String CDC55 = "org.netbeans.modules.j2me.cdc.nbproject";
    static final String CDCTOOLKIT = "org.netbeans.modules.j2me.cdc.project";
    static final String CDC55TYPE = "CDC Pack 5.5";
    static final String CDCTOOLKITTYPE = "CDC Toolkit";
    final String prjType;

    public ImportCDCProjectWizardIterator() {
        this(CDC55);
    }

    public static ImportCDCProjectWizardIterator toolkit() {
        return new ImportCDCProjectWizardIterator(CDCTOOLKIT);
    }

    ImportCDCProjectWizardIterator(String string) {
        this.prjType = string;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        if (this.platformInstall) {
            switch (this.currentIndex) {
                case 0: {
                    return this.platformPanel;
                }
                case 1: {
                    return this.sourcesPanel;
                }
                case 2: {
                    return this.projectPanel;
                }
            }
        } else {
            switch (this.currentIndex) {
                case 0: {
                    return this.sourcesPanel;
                }
                case 1: {
                    return this.projectPanel;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        if (this.platformInstall) {
            return this.currentIndex < 2;
        }
        return this.currentIndex < 1;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.platformInstall = PlatformInstallPanel.isPlatformInstalled((String)"cdc") ^ true;
        if (this.platformInstall) {
            this.platformPanel = new PlatformInstallPanel.WizardPanel("cdc");
            ((JComponent)this.platformPanel.getComponent()).putClientProperty("NewProjectWizard_Title", CDC55.equals(this.prjType) ? NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_Import55Project") : NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_ImportToolkitProject"));
        }
        this.sourcesPanel = new ImportCDCProjectPanel.WizardPanel(this.prjType);
        ((JComponent)this.sourcesPanel.getComponent()).putClientProperty("NewProjectWizard_Title", CDC55.equals(this.prjType) ? NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_Import55Project") : NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_ImportToolkitProject"));
        this.projectPanel = new ProjectPanel.WizardPanel(false, true);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.platformPanel = null;
        this.sourcesPanel = null;
        this.projectPanel = null;
        this.currentIndex = -1;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        final String string = (String)templateWizard.getProperty("ImportProjectLocation");
        File file = (File)templateWizard.getProperty("ProjectLocation");
        String string2 = (String)templateWizard.getProperty("ProjectName");
        final EditableProperties editableProperties = new EditableProperties();
        editableProperties.load((InputStream)new FileInputStream(string + File.separator + "nbproject/project.properties"));
        File file2 = new File(string + File.separator + "nbproject/private/private.properties");
        final EditableProperties editableProperties2 = new EditableProperties();
        if (file2.exists()) {
            editableProperties2.load((InputStream)new FileInputStream(file2));
        }
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        PlatformSelectionPanel.PlatformDescription platformDescription = new PlatformSelectionPanel.PlatformDescription();
        AntProjectHelper antProjectHelper = J2MEProjectGenerator.createProject((File)file, (String)string2, (PlatformSelectionPanel.PlatformDescription)platformDescription, (J2MEProjectGenerator.ProjectGeneratorCallback)new J2MEProjectGenerator.ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject, File file, ArrayList<String> arrayList) throws IOException {
                Object object;
                String string3;
                File file22;
                Object object22;
                EditableProperties editableProperties3 = antProjectHelper.getProperties("nbproject/project.properties");
                EditableProperties editableProperties22 = antProjectHelper.getProperties("nbproject/private/private.properties");
                if (editableProperties.getProperty("main.class.applet") != null && editableProperties.getProperty("main.class.applet").equals("true")) {
                    editableProperties3.setProperty("main.class.class", "applet");
                } else if (editableProperties.getProperty("main.class.xlet") != null && editableProperties.getProperty("main.class.xlet").equals("true")) {
                    editableProperties3.setProperty("main.class.class", "xlet");
                } else {
                    editableProperties3.setProperty("main.class.class", "main");
                }
                for (Object object22 : Lookup.getDefault().lookup(new Lookup.Template(ProjectPropertiesDescriptor.class)).allInstances()) {
                    for (File file22 : object22.getPropertyDescriptors()) {
                        string3 = file22.getName();
                        if (file22.isShared()) {
                            object = editableProperties.getProperty(string3);
                            if (object == null) continue;
                            editableProperties3.setProperty(string3, (String)object);
                            continue;
                        }
                        object = editableProperties2.getProperty(string3);
                        if (object == null) continue;
                        editableProperties22.setProperty(string3, (String)object);
                    }
                }
                FileObject fileObject2 = fileObject.createFolder("src");
                object22 = FileUtil.toFile((FileObject)fileObject2);
                FileObject fileObject3 = fileObject.createFolder("lib");
                file22 = FileUtil.toFile((FileObject)fileObject3);
                string3 = fileObject.createFolder("resources");
                object = FileUtil.toFile((FileObject)string3);
                J2MEProjectGenerator.copyJavaFolder((File)new File(string, "src"), (File)object22, (Pattern)J2MEProjectGenerator.IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder((File)new File(string, "resources"), (File)object, (Pattern)J2MEProjectGenerator.IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder((File)new File(string, "lib"), (File)file22, (Pattern)J2MEProjectGenerator.IMPORT_EXCLUDES);
                String string2 = editableProperties.getProperty("platform.active");
                if (string2 != null) {
                    editableProperties3.setProperty("platform.active.description", string2.replace('_', ' '));
                }
                editableProperties3.setProperty("platform.trigger", "CDC");
                editableProperties3.setProperty("libs.classpath", editableProperties.getProperty("javac.classpath"));
                editableProperties3.setProperty("src.dir", editableProperties.getProperty("src.dir"));
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties3);
            }
        });
        NewCDCProjectWizardIterator.createManifest(antProjectHelper.getProjectDirectory(), "manifest.mf");
        return Collections.singleton(DataObject.find((FileObject)antProjectHelper.getProjectDirectory()));
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent jComponent = (JComponent)this.current().getComponent();
        if (jComponent == null) {
            return;
        }
        String[] stringArray = this.platformInstall ? new String[]{NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"), NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"TITLE_Project", (Object)(this.prjType.equals(CDC55) ? CDC55TYPE : CDCTOOLKITTYPE)), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project")} : new String[]{NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"TITLE_Project", (Object)(this.prjType.equals(CDC55) ? CDC55TYPE : CDCTOOLKITTYPE)), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project")};
        jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }
}

