/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.ui.DerbyPropertiesPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateDatabasePanel
extends JPanel {
    private File derbySystemHome;
    private DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private Color nbWarningForeground;
    private DocumentListener docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent documentEvent) {
            CreateDatabasePanel.this.validateDatabaseName();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CreateDatabasePanel.this.validateDatabaseName();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            CreateDatabasePanel.this.validateDatabaseName();
        }
    };
    public JLabel databaseLocationLabel;
    public JTextField databaseLocationTextField;
    public JLabel databaseNameLabel;
    public JTextField databaseNameTextField;
    public JLabel messageLabel;
    public JLabel passwordLabel;
    public JTextField passwordTextField;
    public JButton propertiesButton;
    public JLabel userLabel;
    public JTextField userTextField;

    public CreateDatabasePanel(String string) {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
        if (this.nbWarningForeground == null) {
            this.nbWarningForeground = new Color(51, 51, 51);
        }
        this.derbySystemHome = new File(string);
        this.initComponents();
        this.databaseNameTextField.getDocument().addDocumentListener(this.docListener);
        this.userTextField.getDocument().addDocumentListener(this.docListener);
        this.passwordTextField.getDocument().addDocumentListener(this.docListener);
        this.updateLocation();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.validateDatabaseName();
    }

    public String getDatabaseName() {
        return this.databaseNameTextField.getText().trim();
    }

    public String getUser() {
        String string = this.userTextField.getText().trim();
        return string.length() > 0 ? string : null;
    }

    public String getPassword() {
        String string = this.passwordTextField.getText().trim();
        return string.length() > 0 ? string : null;
    }

    private void validateDatabaseName() {
        if (this.descriptor == null) {
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = this.getDatabaseName();
        int n = DerbyDatabases.getFirstIllegalCharacter(string3);
        int n2 = this.getFirstUnsupportedCharacter(string3);
        if (string3.length() <= 0) {
            string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseNameEmpty");
        } else if (n >= 0) {
            string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseNameIllegalChar", (Object)new Character((char)n));
        } else if (string3.length() > 0 && new File(this.derbySystemHome, string3).exists()) {
            string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseDirectoryExists", (Object)string3);
        } else if (n2 >= 0) {
            string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseNameUnsupportedChar", (Object)new Character((char)n2));
        } else if (this.getUser() == null || this.getPassword() == null) {
            string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_UserNamePasswordRecommended");
        }
        if (string != null) {
            this.messageLabel.setForeground(this.nbErrorForeground);
            this.messageLabel.setText(string);
            this.messageLabel.setToolTipText(string);
            this.descriptor.setValid(false);
        } else if (string2 != null) {
            this.messageLabel.setForeground(this.nbWarningForeground);
            this.messageLabel.setText(string2);
            this.messageLabel.setToolTipText(string2);
            this.descriptor.setValid(true);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    private void updateLocation() {
        this.databaseLocationTextField.setText(this.derbySystemHome.getAbsolutePath());
    }

    private int getFirstUnsupportedCharacter(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '\u00ff') continue;
            return c;
        }
        return -1;
    }

    private void initComponents() {
        this.databaseNameLabel = new JLabel();
        this.databaseNameTextField = new JTextField();
        this.databaseLocationLabel = new JLabel();
        this.databaseLocationTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JTextField();
        this.messageLabel = new JLabel();
        this.propertiesButton = new JButton();
        this.databaseNameLabel.setLabelFor(this.databaseNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.databaseNameLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_DatabaseName"));
        this.databaseLocationLabel.setLabelFor(this.databaseLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.databaseLocationLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_DatabaseLocation"));
        this.databaseLocationTextField.setEditable(false);
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_UserName"));
        this.userTextField.setColumns(15);
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_Password"));
        this.passwordTextField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)" ");
        Mnemonics.setLocalizedText((AbstractButton)this.propertiesButton, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_Properties"));
        this.propertiesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateDatabasePanel.this.propertiesButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.messageLabel, -1, 544, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.databaseNameLabel).add((Component)this.passwordLabel).add((Component)this.userLabel).add((Component)this.databaseLocationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.databaseNameTextField, -1, 290, Short.MAX_VALUE).add((Component)this.passwordTextField, -1, 290, Short.MAX_VALUE).add((Component)this.userTextField, -1, 290, Short.MAX_VALUE).add((Component)this.databaseLocationTextField, -1, 290, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.propertiesButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.databaseNameLabel).add((Component)this.databaseNameTextField, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.userLabel).add((Component)this.userTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.passwordLabel).add((Component)this.passwordTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.databaseLocationLabel).add((Component)this.databaseLocationTextField, -2, -1, -2).add((Component)this.propertiesButton)).add(16, 16, 16).add((Component)this.messageLabel, -2, 14, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.databaseLocationTextField, this.databaseNameTextField, this.passwordTextField, this.userTextField}, 2);
        this.databaseNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseNameTextField"));
        this.databaseLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseLocationTextField"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_userTextField"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_passwordTextField"));
        this.propertiesButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSN_CreateDatabasePanel_propertiesButton"));
        this.propertiesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_propertiesButton"));
    }

    private void propertiesButtonActionPerformed(ActionEvent actionEvent) {
        DerbyPropertiesPanel.showDerbyProperties();
        this.databaseLocationTextField.setText(DerbyOptions.getDefault().getSystemHome());
    }
}

