/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.visualweb.insync.faces.refactoring.SearchVisitor;

final class StringLiteralTransformer
extends SearchVisitor {
    private final String oldString;
    private final String newString;
    private final MatchKind matchKind;

    public StringLiteralTransformer(WorkingCopy workingCopy, String string, String string2, MatchKind matchKind) {
        super(workingCopy);
        this.oldString = string;
        this.newString = string2;
        this.matchKind = matchKind;
    }

    public Tree visitLiteral(LiteralTree literalTree, Element element) {
        if (literalTree.getKind() == Tree.Kind.STRING_LITERAL) {
            this.transformStringLiteral(this.getCurrentPath(), literalTree);
        }
        return (Tree)super.visitLiteral(literalTree, element);
    }

    private void transformStringLiteral(TreePath treePath, LiteralTree literalTree) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        Object object = literalTree.getValue();
        if (object instanceof String) {
            String string = (String)object;
            switch (this.matchKind) {
                case EXACT: {
                    if (!string.equals(this.oldString)) break;
                    LiteralTree literalTree2 = this.make.Literal((Object)this.newString);
                    this.workingCopy.rewrite((Tree)literalTree, (Tree)literalTree2);
                    break;
                }
                case PREFIX: {
                    if (!string.startsWith(this.oldString)) break;
                    LiteralTree literalTree3 = this.make.Literal((Object)(this.newString + string.substring(this.oldString.length())));
                    this.workingCopy.rewrite((Tree)literalTree, (Tree)literalTree3);
                    break;
                }
                case SUFFIX: {
                    if (!string.endsWith(this.oldString)) break;
                    LiteralTree literalTree4 = this.make.Literal((Object)(string.substring(0, string.length() - this.oldString.length()) + this.newString));
                    this.workingCopy.rewrite((Tree)literalTree, (Tree)literalTree4);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MatchKind {
        EXACT,
        PREFIX,
        SUFFIX;

    }
}

