/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.insync.ModelSet;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.SourceUnit;
import org.netbeans.modules.visualweb.insync.SourceUnitListener;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.UndoManager;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.filesystems.FileObject;

public abstract class Model
implements SourceUnitListener {
    public static final Model[] EMPTY_ARRAY = new Model[0];
    public static final boolean CHECK_CIRCULAR_SYNC = false;
    protected Exception syncInProgress;
    protected UndoManager undoManager = new UndoManager();
    protected ModelSet owner;
    protected FileObject file;
    protected boolean needSyncing = true;

    protected static Model getInstance(FileObject fileObject, Class clazz, boolean bl) {
        ModelSet modelSet = ModelSet.getInstance(fileObject, clazz);
        if (modelSet != null) {
            return modelSet.getModel(fileObject);
        }
        return null;
    }

    protected static Model getModel(FileObject fileObject) {
        ModelSet modelSet = ModelSet.getModelSet(fileObject);
        if (modelSet != null) {
            return modelSet.getModel(fileObject);
        }
        return null;
    }

    protected Model(ModelSet modelSet, FileObject fileObject) {
        assert (fileObject != null);
        this.owner = modelSet;
        this.file = fileObject;
    }

    public void destroy() {
        this.owner = null;
        this.file = null;
    }

    public void resetOwner() {
        this.owner = null;
    }

    public ModelSet getOwner() {
        return this.owner;
    }

    public abstract ParserAnnotation[] getErrors();

    public FileObject getFile() {
        return this.file;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public Project getProject() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getProject();
    }

    public FileObject getWebFolder() {
        return JsfProjectUtils.getDocumentRoot((Project)this.getProject());
    }

    public abstract UndoEvent writeLock(String var1);

    public abstract void writeUnlock(UndoEvent var1);

    public abstract boolean isWriteLocked();

    protected void beginMdrTransation() {
    }

    protected void endMdrTransaction() {
    }

    public void sync() {
        this.syncImpl();
    }

    protected abstract void syncImpl();

    public void fireModelChanged() {
        this.getOwner().fireModelChanged(this);
    }

    public abstract void saveUnits();

    public void flush() {
        this.flushImpl();
    }

    public abstract void flushImpl();

    public void flushNonJavaUnits() {
        this.flushNonJavaUnitsImpl();
    }

    public abstract void flushNonJavaUnitsImpl();

    public void fileRenamed(String string, String string2, String string3, FileObject fileObject, boolean bl) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        this.toString(stringBuffer);
        stringBuffer.append("]");
        return super.toString() + stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.file == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(" file: ");
            stringBuffer.append(this.file.getNameExt());
        }
    }

    public void sourceUnitSaved(SourceUnit sourceUnit) {
    }

    public void sourceUnitModelDirtied(SourceUnit sourceUnit) {
    }

    public void sourceUnitSourceDirtied(SourceUnit sourceUnit) {
        if (this.isValid()) {
            this.needSyncing = true;
            this.getOwner().addToModelsToSync(this);
        }
    }

    public boolean isValid() {
        return this.getOwner() != null;
    }

    public static interface Factory {
        public Model newInstance(ModelSet var1, FileObject var2);
    }
}

