/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.insync.faces.FacesUnit;
import org.netbeans.modules.visualweb.insync.models.FacesConfigModel;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class InSyncServiceProviderQuery {
    protected boolean hasInitializedFileObject;
    protected FileObject fileObject;
    protected boolean hasInitializedDataObject;
    protected DataObject dataObject;
    protected boolean hasInitializedProject;
    protected Project project;
    protected boolean hasInitializedFacesModelSet;
    protected FacesModelSet facesModelSet;
    protected Boolean isInProjectJspRoot;
    protected Boolean isInProjectJavaRoot;
    protected Boolean isTemplateFileObject;

    public InSyncServiceProviderQuery(FileObject fileObject, DataObject dataObject) {
        if (fileObject == null && dataObject == null) {
            throw new RuntimeException("Cannot pass in null for both");
        }
        this.fileObject = fileObject;
        this.hasInitializedFileObject = fileObject != null;
        this.dataObject = dataObject;
        this.hasInitializedDataObject = dataObject != null;
    }

    public String getBeanName() {
        if (this.isInProjectJspRoot()) {
            String string = FileUtil.getRelativePath((FileObject)this.getProjectJspRoot(), (FileObject)this.getQueriedFileObject());
            String string2 = string.replace('/', '$');
            string2 = FacesUnit.fixPossiblyImplicitBeanName(string2);
            return string2;
        }
        if (this.isInProjectJavaRoot()) {
            String string = FileUtil.getRelativePath((FileObject)this.getProjectJavaRoot(), (FileObject)this.getQueriedFileObject());
            String string3 = string.replace('/', '.');
            ManagedBean managedBean = this.getManagedBeanWithBeanClass(string3);
            if (managedBean != null) {
                return managedBean.getManagedBeanName();
            }
            return null;
        }
        return null;
    }

    public String getBeanNameViaJsp() {
        String string;
        if (this.isTemplateFileObject()) {
            string = "";
        } else {
            if (!this.isInProjectJspRoot()) {
                return null;
            }
            String string2 = FileUtil.getRelativePath((FileObject)this.getProjectJspRoot(), (FileObject)this.getQueriedFileObject().getParent());
            string = string2.replace('/', '$');
            if (string.length() > 0) {
                string = string + "$";
            }
        }
        string = string + this.getQueriedFileObject().getName();
        string = FacesUnit.fixPossiblyImplicitBeanName(string);
        return string;
    }

    public DataObject getDataObject() {
        if (this.hasInitializedDataObject) {
            return this.dataObject;
        }
        this.hasInitializedDataObject = true;
        try {
            this.dataObject = DataObject.find((FileObject)this.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return this.dataObject;
    }

    public FacesModelSet getFacesModelSet() {
        if (this.hasInitializedFacesModelSet) {
            return this.facesModelSet;
        }
        this.hasInitializedFacesModelSet = true;
        this.facesModelSet = FacesModelSet.getInstance(this.getProject());
        return this.facesModelSet;
    }

    public FileObject getFileObject() {
        if (this.hasInitializedFileObject) {
            return this.fileObject;
        }
        this.hasInitializedFileObject = true;
        DataObject dataObject = this.getDataObject();
        if (dataObject != null) {
            this.fileObject = dataObject.getPrimaryFile();
        }
        return this.fileObject;
    }

    public DataObject getJavaDataObjectEquivalent(String string, boolean bl) {
        FileObject fileObject = this.getJavaFileObjectEquivalent(string, bl);
        if (fileObject == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    public FileObject getJavaFileObjectEquivalent(String string, boolean bl) {
        if (this.getFileObject() == null) {
            return null;
        }
        if (this.isInProjectJavaRoot()) {
            return this.getFileObject();
        }
        if (!this.isInProjectJspRoot()) {
            return null;
        }
        if (this.getFileObject().isFolder()) {
            if (this.getFileObject() == this.getProjectJspRoot()) {
                return this.getProjectPageBeanRoot();
            }
            FileObject fileObject = string == null ? this.getFileObject() : this.getFileObject().getParent();
            String string2 = FileUtil.getRelativePath((FileObject)this.getProjectJspRoot(), (FileObject)fileObject);
            string2 = this.getProjectPageBeanPackageNameWithSlash() + string2;
            fileObject = this.getProjectJavaRoot().getFileObject(string2);
            if (fileObject == null) {
                if (!bl) {
                    return null;
                }
                try {
                    fileObject = FileUtil.createFolder((FileObject)this.getProjectJavaRoot(), (String)string2);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            if (string != null && (fileObject = fileObject.getFileObject(string)) == null) {
                if (!bl) {
                    return null;
                }
                try {
                    fileObject = FileUtil.createFolder((FileObject)fileObject, (String)string);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            return fileObject;
        }
        String string3 = string == null ? this.getFileObject().getName() : string;
        String string4 = FileUtil.getRelativePath((FileObject)this.getProjectJspRoot(), (FileObject)this.getFileObject().getParent());
        string4 = this.getProjectPageBeanPackageNameWithSlash() + string4;
        FileObject fileObject = this.getProjectJavaRoot().getFileObject(string4);
        if (fileObject == null) {
            return null;
        }
        fileObject = fileObject.getFileObject(string3, "java");
        return fileObject;
    }

    public FileObject getJavaFolderForJsp() {
        return null;
    }

    public FileObject getJavaForJsp() {
        if (!this.isInProjectJspRoot()) {
            return null;
        }
        throw new RuntimeException("No implemented yet !!!");
    }

    public ManagedBean getManagedBeanNamed(String string) {
        FacesConfigModel facesConfigModel = this.getFacesModelSet().getFacesConfigModel();
        ManagedBean managedBean = facesConfigModel.getManagedBean(string);
        return managedBean;
    }

    public ManagedBean getManagedBeanWithBeanClass(String string) {
        FacesConfigModel facesConfigModel = this.getFacesModelSet().getFacesConfigModel();
        ManagedBean[] managedBeanArray = facesConfigModel.getManagedBeans();
        ManagedBean managedBean = null;
        for (int i = 0; i < managedBeanArray.length; ++i) {
            ManagedBean managedBean2 = managedBeanArray[i];
            if (!string.equals(managedBean2.getManagedBeanClass())) continue;
            if (managedBean == null) {
                managedBean = managedBean2;
                continue;
            }
            return null;
        }
        return managedBean;
    }

    public Project getProject() {
        if (this.hasInitializedProject) {
            return this.project;
        }
        this.hasInitializedProject = true;
        this.project = FileOwnerQuery.getOwner((FileObject)this.getQueriedFileObject());
        return this.project;
    }

    public String getProjectPageBeanPackageNameWithDot() {
        String string = JsfProjectUtils.getProjectProperty((Project)this.getProject(), (String)"jsf.pagebean.package");
        if (string.length() > 0) {
            string = string + ".";
        }
        return string;
    }

    public String getProjectPageBeanPackageNameWithSlash() {
        String string = this.getProjectPageBeanPackageNameWithDot();
        string = string.replace('.', '/');
        return string;
    }

    public FileObject getProjectJavaRoot() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        FileObject fileObject = JsfProjectUtils.getSourceRoot((Project)project);
        return fileObject;
    }

    public FileObject getProjectJspRoot() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        FileObject fileObject = JsfProjectUtils.getDocumentRoot((Project)project);
        return fileObject;
    }

    public FileObject getProjectPageBeanRoot() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        FileObject fileObject = JsfProjectUtils.getPageBeanRoot((Project)project);
        return fileObject;
    }

    public FileObject getQueriedFileObject() {
        return this.fileObject;
    }

    public boolean isInProjectJavaRoot() {
        if (this.isInProjectJavaRoot == null) {
            FileObject fileObject = this.getProjectJavaRoot();
            boolean bl = fileObject == null ? false : fileObject == this.getQueriedFileObject() || FileUtil.isParentOf((FileObject)fileObject, (FileObject)this.getQueriedFileObject());
            this.isInProjectJavaRoot = bl;
        }
        return this.isInProjectJavaRoot;
    }

    public boolean isInProjectJspRoot() {
        if (this.isInProjectJspRoot == null) {
            FileObject fileObject = this.getProjectJspRoot();
            boolean bl = fileObject == null ? false : fileObject == this.getQueriedFileObject() || FileUtil.isParentOf((FileObject)fileObject, (FileObject)this.getQueriedFileObject());
            this.isInProjectJspRoot = bl;
        }
        return this.isInProjectJspRoot;
    }

    public boolean isTemplateFileObject() {
        if (this.isTemplateFileObject == null) {
            FileObject fileObject;
            FileObject fileObject2 = this.getQueriedFileObject();
            Object object = fileObject2.getAttribute("template");
            boolean bl = object instanceof Boolean ? (Boolean)object : false;
            boolean bl2 = bl ? true : ((fileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Templates")) != null ? FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) : false);
            this.isTemplateFileObject = bl2;
        }
        return this.isTemplateFileObject;
    }
}

