/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import com.sun.rave.designtime.Customizer2;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.netbeans.modules.visualweb.insync.ResultHandler;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerDisplayer
implements ActionListener,
PropertyChangeListener {
    private DesignBean bean;
    private Customizer2 customizer;
    private String help;
    private DialogDescriptor descriptor;
    private JButton applyButton;
    private JButton closeButton;
    private FacesModel model;
    private UndoEvent undoEvent = null;
    private static BatchListener batchListener;

    public CustomizerDisplayer(DesignBean designBean, Customizer2 customizer2, String string, FacesModel facesModel) {
        this.bean = designBean;
        this.customizer = customizer2;
        this.help = string;
        this.model = facesModel;
    }

    public void show() {
        if (this.customizer == null) {
            return;
        }
        Component component = this.customizer.getCustomizerPanel(this.bean);
        if (component == null) {
            return;
        }
        HelpCtx helpCtx = null;
        if (this.help != null && this.help.length() > 0) {
            helpCtx = new HelpCtx(this.help);
        }
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        if (this.customizer.isApplyCapable()) {
            this.applyButton = new JButton(NbBundle.getMessage(CustomizerDisplayer.class, (String)"Apply"));
            this.applyButton.setMnemonic(NbBundle.getMessage(CustomizerDisplayer.class, (String)"Apply_mnemonic").charAt(0));
            this.applyButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDisplayer.class, (String)"APPLY_ACCESS_NAME"));
            this.applyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDisplayer.class, (String)"APPLY_ACCESS_DESC"));
            boolean bl = this.customizer.isModified();
            this.applyButton.setEnabled(bl);
            objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION, this.applyButton};
            objectArray2 = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        } else {
            this.closeButton = new JButton(NbBundle.getMessage(CustomizerDisplayer.class, (String)"Close"));
            this.closeButton.setMnemonic(NbBundle.getMessage(CustomizerDisplayer.class, (String)"Close_mnemonic").charAt(0));
            this.closeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDisplayer.class, (String)"CLOSE_ACCESS_NAME"));
            this.closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDisplayer.class, (String)"CLOSE_ACCESS_DESC"));
            objectArray2 = objectArray = new Object[]{this.closeButton};
        }
        this.descriptor = new DialogDescriptor((Object)component, this.customizer.getDisplayName(), true, objectArray, DialogDescriptor.OK_OPTION, 0, helpCtx, (ActionListener)this);
        this.descriptor.setClosingOptions(objectArray2);
        this.customizer.addPropertyChangeListener((PropertyChangeListener)this);
        JDialog jDialog = (JDialog)DialogDisplayer.getDefault().createDialog(this.descriptor);
        jDialog.getAccessibleContext().setAccessibleDescription(this.customizer.getDisplayName());
        jDialog.show();
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = this.customizer.isModified();
        if (this.applyButton != null) {
            this.applyButton.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.descriptor == null) {
            return;
        }
        Object object = this.descriptor.getValue();
        if (object == DialogDescriptor.OK_OPTION || object == this.closeButton || object == this.applyButton) {
            try {
                this.startTask();
                Result result = this.customizer.applyChanges();
                ResultHandler.handleResult(result, this.model);
            }
            finally {
                this.finishTask();
            }
            if (this.applyButton != null) {
                boolean bl = this.customizer.isModified();
                this.applyButton.setEnabled(bl);
            }
        }
        if (object == DialogDescriptor.OK_OPTION || object == this.closeButton || object == DialogDescriptor.CANCEL_OPTION) {
            this.customizer.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void startTask() {
        this.undoEvent = this.model.writeLock(NbBundle.getMessage(CustomizerDisplayer.class, (String)"Customize"));
        if (this.bean instanceof MarkupDesignBean) {
            this.batchModifyBean((MarkupDesignBean)this.bean, true);
        }
    }

    private void finishTask() {
        if (this.undoEvent != null) {
            this.model.writeUnlock(this.undoEvent);
            this.undoEvent = null;
        }
        if (this.bean instanceof MarkupDesignBean) {
            this.batchModifyBean((MarkupDesignBean)this.bean, false);
        }
    }

    private void batchModifyBean(MarkupDesignBean markupDesignBean, boolean bl) {
        if (batchListener != null) {
            if (bl) {
                batchListener.beanModifyBegin(markupDesignBean, this.model);
            } else {
                batchListener.beanModifyEnd(markupDesignBean, this.model);
            }
        }
    }

    public static void setBatchListener(BatchListener batchListener) {
        if (CustomizerDisplayer.batchListener != null) {
            throw new UnsupportedOperationException("There can only be one batch listener");
        }
        CustomizerDisplayer.batchListener = batchListener;
    }

    public static interface BatchListener {
        public void beanModifyBegin(MarkupDesignBean var1, FacesModel var2);

        public void beanModifyEnd(MarkupDesignBean var1, FacesModel var2);
    }
}

