/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyFileUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static List<File> listFiles(File file, FilenameFilter filenameFilter, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (filenameFilter == null || filenameFilter.accept(file, file2.getName())) {
                    arrayList.add(file2);
                }
                if (!bl || !file2.isDirectory()) continue;
                arrayList.addAll(MyFileUtil.listFiles(file2, filenameFilter, bl));
            }
        }
        return arrayList;
    }

    public static String getRelativePath(File file, File file2) {
        int n;
        String string = file.getAbsolutePath().replaceAll("\\\\", "/");
        String string2 = file2.getAbsolutePath().replaceAll("\\\\", "/");
        while (true) {
            int n2 = string.indexOf("/");
            n = string2.indexOf("/");
            if (n2 == -1 || n == -1 || !string.substring(0, n2).equals(string2.substring(0, n))) break;
            string = string.substring(n2 + 1);
            string2 = string2.substring(n + 1);
        }
        String string3 = "";
        while (string != null) {
            n = string.indexOf("/");
            string3 = string3 + "../";
            if (n == -1) break;
            string = string.substring(n);
        }
        if (string2 != null) {
            string3 = string3 + string2;
        }
        return string3;
    }

    public static void replaceAll(FileObject fileObject, String string, String string2, boolean bl) throws FileNotFoundException, IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        MyFileUtil.replaceAll(file, string, string2, bl);
    }

    public static void replaceAll(File file, String string, String string2, boolean bl) throws FileNotFoundException, IOException {
        assert (string != null && string2 != null);
        if (string.equals(string2)) {
            return;
        }
        String string3 = file.getName();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        File file2 = File.createTempFile(string3, "tmp");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        if (bl) {
            String string4;
            while ((string4 = bufferedReader.readLine()) != null) {
                string4.replaceAll(string, string2);
                bufferedWriter.write(string4 + LINE_SEPARATOR);
            }
        } else {
            String string5;
            while ((string5 = bufferedReader.readLine()) != null) {
                int n;
                while ((n = string5.indexOf(string)) != -1) {
                    string5 = string5.substring(0, n) + string2 + string5.substring(n + string.length());
                }
                bufferedWriter.write(string5 + LINE_SEPARATOR);
            }
        }
        bufferedReader.close();
        bufferedWriter.close();
        MyFileUtil.move(file2, file);
    }

    public static void move(File file, File file2) throws FileNotFoundException, IOException {
        MyFileUtil.copy(file, file2);
        file.delete();
    }

    public static void copy(File file, File file2) throws FileNotFoundException, IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string + LINE_SEPARATOR);
        }
        bufferedReader.close();
        bufferedWriter.close();
    }
}

