/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePlugin;
import org.netbeans.modules.compapp.projects.jbi.api.JbiInstalledProjectPluginInfo;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectActionPerformer;
import org.netbeans.modules.compapp.projects.jbi.ui.ActionDecorator;
import org.netbeans.modules.compapp.projects.jbi.ui.JbiModuleViewNode;
import org.netbeans.modules.compapp.projects.jbi.ui.JbiViews;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.AddProjectAction;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.test.ui.TestNode;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class JbiLogicalViewProvider
implements LogicalViewProvider {
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "jbi.content.additional", "src.dir"};
    private final JbiProject project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SubprojectProvider spp;
    private final ReferenceHelper resolver;
    private static Image mIcon = new ImageIcon(JbiLogicalViewProvider.class.getClassLoader().getResource("org/netbeans/modules/compapp/projects/jbi/ui/resources/composite_application_project.png")).getImage();
    private static Image mEmpty = new ImageIcon(JbiLogicalViewProvider.class.getClassLoader().getResource("org/netbeans/modules/compapp/projects/jbi/ui/resources/brokenProjectBadge.gif")).getImage();
    private static Image mEmptyIcon = mIcon;
    private JbiLogicalViewRootNode jRoot;
    private boolean isEmpty = false;

    public JbiLogicalViewProvider(JbiProject jbiProject, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SubprojectProvider subprojectProvider, ReferenceHelper referenceHelper) {
        this.project = jbiProject;
        assert (jbiProject != null);
        this.helper = antProjectHelper;
        assert (antProjectHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
        this.resolver = referenceHelper;
        if (mEmpty != null) {
            mEmptyIcon = ImageUtilities.mergeImages((Image)mIcon, (Image)mEmpty, (int)8, (int)0);
        }
    }

    public Node createLogicalView() {
        this.jRoot = new JbiLogicalViewRootNode();
        Children children = this.jRoot.getChildren();
        final JbiProjectProperties jbiProjectProperties = new JbiProjectProperties(this.project, this.helper, this.resolver);
        try {
            children.add(new Node[]{new JbiModuleViewNode(jbiProjectProperties, this.project)});
            if (this.project.getTestDirectory() != null) {
                children.add(new Node[]{new TestNode(jbiProjectProperties, this.project)});
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(exception.getLocalizedMessage());
        }
        FileChangeAdapter fileChangeAdapter = new FileChangeAdapter(){

            public void fileFolderCreated(FileEvent fileEvent) {
                String string = (String)JbiLogicalViewProvider.this.project.getProjectProperties().get("test.dir");
                if (fileEvent.getFile().getNameExt().equals(string)) {
                    Children children = JbiLogicalViewProvider.this.jRoot.getChildren();
                    children.add(new Node[]{new TestNode(jbiProjectProperties, JbiLogicalViewProvider.this.project)});
                    JbiLogicalViewProvider.this.jRoot.refreshNode();
                }
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                String string;
                String string2;
                String string3 = fileRenameEvent.getName();
                String string4 = fileRenameEvent.getExt();
                String string5 = string4 == null || string4.trim().equals("") ? string3 : string3 + "." + string4;
                if (string5.equals(string2 = (String)JbiLogicalViewProvider.this.project.getProjectProperties().get("test.dir"))) {
                    string = JbiLogicalViewProvider.this.jRoot.getChildren();
                    for (Children children : string.getNodes()) {
                        if (!(children instanceof TestNode)) continue;
                        string.remove(new Node[]{children});
                        break;
                    }
                }
                if ((string = fileRenameEvent.getFile().getNameExt()).equals(string2)) {
                    Children children = JbiLogicalViewProvider.this.jRoot.getChildren();
                    children.add(new Node[]{new TestNode(jbiProjectProperties, JbiLogicalViewProvider.this.project)});
                    JbiLogicalViewProvider.this.jRoot.refreshNode();
                }
            }
        };
        this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)fileChangeAdapter);
        return this.jRoot;
    }

    public void refreshRootNode() {
        boolean bl = this.isProjectEmpty();
        if (bl != this.isEmpty) {
            this.isEmpty = bl;
            if (this.jRoot != null) {
                this.jRoot.refreshNode();
            }
        }
    }

    private boolean isProjectEmpty() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("jbi.content.additional");
        if (string != null && string.trim().length() > 0) {
            return false;
        }
        return !CasaHelper.containsWSDLPort(this.project);
    }

    private boolean projectContainsBPELModule() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("jbi.content.component");
        return string != null && string.contains("sun-bpel-engine");
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof DataObject) {
            object = ((DataObject)object).getPrimaryFile();
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2 = PackageView.findPath((Node)nodeArray[i], (Object)object);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    public static boolean hasBrokenLinks(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)antProjectHelper, (ReferenceHelper)referenceHelper, (String[])BREAKABLE_PROPERTIES, (String[])new String[]{"platform.active"});
    }

    private final class JbiLogicalViewRootNode
    extends AbstractNode {
        private Action brokenLinksAction;
        private boolean broken;
        private SubprojectListener subprojectListener;

        public JbiLogicalViewRootNode() {
            super((Children)new JbiViews.LogicalViewChildren(JbiLogicalViewProvider.this.helper, JbiLogicalViewProvider.this.evaluator, JbiLogicalViewProvider.this.project), JbiLogicalViewProvider.createLookup(JbiLogicalViewProvider.this.project));
            this.setIconBaseWithExtension("org/netbeans/modules/compapp/projects/jbi/ui/resources/composite_application_project.png");
            super.setName(ProjectUtils.getInformation((Project)JbiLogicalViewProvider.this.project).getDisplayName());
            if (JbiLogicalViewProvider.hasBrokenLinks(JbiLogicalViewProvider.this.helper, JbiLogicalViewProvider.this.resolver)) {
                this.broken = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.subprojectListener = new SubprojectListener();
            final SubprojectProvider subprojectProvider = (SubprojectProvider)JbiLogicalViewProvider.this.project.getLookup().lookup(SubprojectProvider.class);
            subprojectProvider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Project project = (Project)changeEvent.getSource();
                    FileObject fileObject = project.getProjectDirectory();
                    if (subprojectProvider.getSubprojects().contains(project)) {
                        fileObject.addFileChangeListener((FileChangeListener)JbiLogicalViewRootNode.this.subprojectListener);
                    } else {
                        fileObject.removeFileChangeListener((FileChangeListener)JbiLogicalViewRootNode.this.subprojectListener);
                    }
                }
            });
            this.updateSubprojectListeners();
        }

        private void updateSubprojectListeners() {
            SubprojectProvider subprojectProvider = (SubprojectProvider)JbiLogicalViewProvider.this.project.getLookup().lookup(SubprojectProvider.class);
            for (Project project : subprojectProvider.getSubprojects()) {
                FileObject fileObject = project.getProjectDirectory();
                fileObject.removeFileChangeListener((FileChangeListener)this.subprojectListener);
                fileObject.addFileChangeListener((FileChangeListener)this.subprojectListener);
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(JbiLogicalViewProvider.class);
        }

        public Action[] getActions(boolean bl) {
            if (bl) {
                return super.getActions(true);
            }
            return this.getAdditionalActions(bl);
        }

        public Image getIcon(int n) {
            return this.broken || JbiLogicalViewProvider.this.isEmpty ? mEmptyIcon : mIcon;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            return this.broken || JbiLogicalViewProvider.this.isEmpty ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public void refreshNode() {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)JbiLogicalViewProvider.this.project, (String)string);
        }

        private Action[] getAdditionalActions(boolean bl) {
            Object object;
            Object object2;
            ResourceBundle resourceBundle = NbBundle.getBundle(JbiLogicalViewProvider.class);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)new AddProjectAction(), (String)resourceBundle.getString("LBL_AddProjectAction_Name"), null));
            JbiInstalledProjectPluginInfo jbiInstalledProjectPluginInfo = JbiInstalledProjectPluginInfo.getProjectPluginInfo();
            if (jbiInstalledProjectPluginInfo != null) {
                object2 = jbiInstalledProjectPluginInfo.getUncategorizedProjectPluginList();
                object = object2.iterator();
                while (object.hasNext()) {
                    InternalProjectTypePlugin internalProjectTypePlugin = object.next();
                    List<JbiProjectActionPerformer> list = internalProjectTypePlugin.getProjectActions();
                    for (JbiProjectActionPerformer jbiProjectActionPerformer : list) {
                        if (!jbiProjectActionPerformer.getActionType().equalsIgnoreCase("PluginAction_AddProject")) continue;
                        arrayList.add(ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)jbiProjectActionPerformer, (String)jbiProjectActionPerformer.getLabel(), (Icon)jbiProjectActionPerformer.getIcon()));
                    }
                }
            }
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"jbiserver-build", (String)resourceBundle.getString("LBL_JbiBuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"jbiserver-clean_build", (String)resourceBundle.getString("LBL_JbiCleanBuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_DeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"undeploy", (String)resourceBundle.getString("LBL_UnDeployAction_Name"), null));
            arrayList.add(null);
            object2 = ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null);
            arrayList.add(object2);
            object = ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null);
            arrayList.add(new ActionDecorator((Action)object){

                public boolean isEnabled() {
                    return JbiLogicalViewProvider.this.projectContainsBPELModule();
                }
            });
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add(SystemAction.get(FindAction.class));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            if (this.broken) {
                arrayList.add(this.brokenLinksAction);
            }
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private class SubprojectListener
        extends FileChangeAdapter {
            private SubprojectListener() {
            }

            public void fileDeleted(FileEvent fileEvent) {
                this.checkBrokenLinks();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                this.checkBrokenLinks();
            }

            private void checkBrokenLinks() {
                boolean bl = JbiLogicalViewProvider.hasBrokenLinks(JbiLogicalViewProvider.this.helper, JbiLogicalViewProvider.this.resolver);
                if (bl != JbiLogicalViewRootNode.this.broken) {
                    JbiLogicalViewRootNode.this.broken = bl;
                    JbiLogicalViewRootNode.this.brokenLinksAction.setEnabled(JbiLogicalViewRootNode.this.broken);
                    JbiLogicalViewRootNode.this.refreshNode();
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener {
            public BrokenLinksAction() {
                JbiLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.putValue("Name", NbBundle.getMessage(JbiLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)JbiLogicalViewProvider.this.helper, (ReferenceHelper)JbiLogicalViewProvider.this.resolver, (String[])BREAKABLE_PROPERTIES, (String[])new String[]{"platform.active"});
                if (!JbiLogicalViewProvider.hasBrokenLinks(JbiLogicalViewProvider.this.helper, JbiLogicalViewProvider.this.resolver)) {
                    this.disable();
                    JbiLogicalViewProvider.this.project.getProjectProperties().fixComponentTargetList();
                    JbiLogicalViewProvider.this.project.getProjectProperties().saveAssemblyInfo();
                }
                JbiLogicalViewRootNode.this.updateSubprojectListeners();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!JbiLogicalViewRootNode.this.broken) {
                    this.disable();
                    return;
                }
                JbiLogicalViewRootNode.this.broken = JbiLogicalViewProvider.hasBrokenLinks(JbiLogicalViewProvider.this.helper, JbiLogicalViewProvider.this.resolver);
                if (!JbiLogicalViewRootNode.this.broken) {
                    this.disable();
                }
            }

            private void disable() {
                JbiLogicalViewRootNode.this.broken = false;
                this.setEnabled(false);
                JbiLogicalViewProvider.this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
                JbiLogicalViewRootNode.this.fireIconChange();
                JbiLogicalViewRootNode.this.fireOpenedIconChange();
                JbiLogicalViewRootNode.this.fireDisplayNameChange(null, null);
            }
        }
    }
}

