/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtConnection
implements Serializable {
    String porttype;
    List<Port> ports = new ArrayList<Port>();
    List<Endpoint> consumes = new ArrayList<Endpoint>();
    List<Endpoint> provides = new ArrayList<Endpoint>();

    public PtConnection() {
    }

    public PtConnection(String string) {
        this.porttype = string;
    }

    public String getPorttype() {
        return this.porttype;
    }

    public List<Endpoint> getConsumes() {
        return this.consumes;
    }

    public void addConsume(Endpoint endpoint) {
        if (!this.consumes.contains(endpoint) && !this.isDuplicate(endpoint, this.consumes)) {
            this.consumes.add(endpoint);
        }
    }

    public List<Endpoint> getProvides() {
        return this.provides;
    }

    public void addProvide(Endpoint endpoint) {
        if (!this.provides.contains(endpoint) && !this.isDuplicate(endpoint, this.provides)) {
            this.provides.add(endpoint);
        }
    }

    private boolean isDuplicate(Endpoint endpoint, List<Endpoint> list) {
        QName qName = endpoint.getServiceQName();
        String string = endpoint.getEndpointName();
        for (Endpoint endpoint2 : list) {
            QName qName2 = endpoint2.getServiceQName();
            String string2 = endpoint2.getEndpointName();
            if (!qName.equals(qName2) || !string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public void addPort(Port port) {
        if (!this.ports.contains(port)) {
            this.ports.add(port);
        }
    }

    public String dump() {
        Object object;
        int n;
        String string = "Connection [" + this.porttype + "]: " + this.ports.size() + " ports, " + this.provides.size() + " providers, " + this.consumes.size() + " consumers\n";
        for (n = 0; n < this.ports.size(); ++n) {
            object = this.ports.get(n);
            Service service = (Service)object.getParent();
            String string2 = ((Definitions)service.getParent()).getTargetNamespace();
            string = string + "\tport[" + n + "]:     {" + string2 + "}" + service.getName() + "." + object.getName() + "\n";
        }
        for (n = 0; n < this.provides.size(); ++n) {
            object = this.provides.get(n);
            string = string + "\tprovides[" + n + "]: " + ((Endpoint)object).getServiceQName() + "." + ((Endpoint)object).getEndpointName() + "\n";
        }
        for (n = 0; n < this.consumes.size(); ++n) {
            object = this.consumes.get(n);
            string = string + "\tconsumes[" + n + "]: " + ((Endpoint)object).getServiceQName() + "." + ((Endpoint)object).getEndpointName() + "\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
    }
}

