/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.web.ui.dt.component.customizers;

import com.sun.rave.designtime.CheckedDisplayAction;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.impl.BasicDisplayAction;
import com.sun.rave.web.ui.component.CheckboxGroup;
import com.sun.rave.web.ui.component.RadioButtonGroup;
import com.sun.rave.web.ui.component.RbCbSelector;
import java.util.regex.Pattern;
import org.netbeans.modules.visualweb.web.ui.dt.component.FormDesignInfo;
import org.netbeans.modules.visualweb.web.ui.dt.component.util.DesignMessageUtil;

public class AutoSubmitOnChangeAction
extends BasicDisplayAction
implements CheckedDisplayAction {
    private static final Pattern submitPattern = Pattern.compile("common_timeoutSubmitForm\\s*\\(\\s*this\\s*\\.\\s*form\\s*,\\s*'\\S+'\\s*\\)\\s*;?");
    protected DesignBean bean;

    public AutoSubmitOnChangeAction(DesignBean designBean) {
        super(DesignMessageUtil.getMessage(AutoSubmitOnChangeAction.class, "AutoSubmitOnChangeAction.label"));
        this.bean = designBean;
    }

    public boolean isChecked() {
        return this.isAutoSubmit();
    }

    public Result invoke() {
        return this.toggleAutoSubmit();
    }

    public boolean isAutoSubmit() {
        DesignProperty designProperty = this.getSubmitProperty();
        if (designProperty == null) {
            return false;
        }
        String string = (String)designProperty.getValue();
        if (string == null) {
            return false;
        }
        return submitPattern.matcher(string).find();
    }

    public Result toggleAutoSubmit() {
        DesignProperty designProperty = this.getSubmitProperty();
        if (designProperty == null) {
            return Result.FAILURE;
        }
        String string = (String)designProperty.getValue();
        if (string == null || string.length() == 0) {
            designProperty.setValue((Object)this.getSubmitScript(null));
        } else if (this.isAutoSubmit()) {
            designProperty.setValue((Object)submitPattern.matcher(string).replaceFirst(""));
        } else {
            designProperty.setValue((Object)this.getSubmitScript(string));
        }
        return Result.SUCCESS;
    }

    DesignProperty getSubmitProperty() {
        Object object = this.bean.getInstance();
        Class<?> clazz = object.getClass();
        if (RbCbSelector.class.isAssignableFrom(clazz) || object instanceof RadioButtonGroup || object instanceof CheckboxGroup) {
            return this.bean.getProperty("onClick");
        }
        return this.bean.getProperty("onChange");
    }

    String getSubmitScript(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            if (!Pattern.compile(";\\s*$").matcher(string).find()) {
                stringBuffer.append(';');
            }
            if (!Pattern.compile("\\s+$").matcher(stringBuffer.toString()).find()) {
                stringBuffer.append(' ');
            }
        }
        if ((string2 = FormDesignInfo.getFullyQualifiedId(this.bean)) == null) {
            string2 = this.bean.getInstanceName();
        } else if (string2.startsWith(String.valueOf(':')) && string2.length() > 1) {
            string2 = string2.substring(1, string2.length());
        }
        stringBuffer.append("common_timeoutSubmitForm(this.form, '");
        stringBuffer.append(string2);
        stringBuffer.append("');");
        return stringBuffer.toString();
    }
}

