/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.actions.DebugAction;
import org.netbeans.modules.glassfish.common.actions.RefreshAction;
import org.netbeans.modules.glassfish.common.actions.RestartAction;
import org.netbeans.modules.glassfish.common.actions.StartServerAction;
import org.netbeans.modules.glassfish.common.actions.StopServerAction;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewMgr {
    private static final Logger LOGGER = Logger.getLogger("glassfish");
    private static final int DELAY = 1000;
    private static final Map<String, WeakReference<LogViewMgr>> instances = new HashMap<String, WeakReference<LogViewMgr>>();
    private final String uri;
    private InputOutput io;
    private final List<WeakReference<LoggerRunnable>> readers = Collections.synchronizedList(new ArrayList());
    private final Locale logLocale = this.getLogLocale();
    private final String logBundleName = this.getLogBundle();
    private final String localizedWarning = this.getLocalized(Level.WARNING.getName());
    private final String localizedSevere = this.getLocalized(Level.SEVERE.getName());
    private final Map<String, String> localizedLevels = this.getLevelMap();
    private static final WeakHashMap<ServerInstance, InputOutput> ioWeakMap = new WeakHashMap();

    private LogViewMgr(String string) {
        this.uri = string;
        this.io = LogViewMgr.getServerIO(string);
        if (this.io == null) {
            return;
        }
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogViewMgr getInstance(String string) {
        LogViewMgr logViewMgr = null;
        Map<String, WeakReference<LogViewMgr>> map = instances;
        synchronized (map) {
            WeakReference<LogViewMgr> weakReference = instances.get(string);
            LogViewMgr logViewMgr2 = logViewMgr = weakReference != null ? (LogViewMgr)weakReference.get() : null;
            if (logViewMgr == null) {
                logViewMgr = new LogViewMgr(string);
                instances.put(string, new WeakReference<LogViewMgr>(logViewMgr));
            }
        }
        return logViewMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureActiveReader(List<Recognizer> list, File file) {
        List<WeakReference<LoggerRunnable>> list2 = this.readers;
        synchronized (list2) {
            boolean bl = false;
            for (WeakReference<LoggerRunnable> weakReference : this.readers) {
                LoggerRunnable loggerRunnable = (LoggerRunnable)weakReference.get();
                if (loggerRunnable == null) continue;
                bl = true;
                break;
            }
            if (!bl && file != null) {
                this.readFiles(list, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInputStreams(List<Recognizer> list, InputStream ... inputStreamArray) {
        List<WeakReference<LoggerRunnable>> list2 = this.readers;
        synchronized (list2) {
            this.stopReaders();
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            for (InputStream inputStream : inputStreamArray) {
                LoggerRunnable loggerRunnable = new LoggerRunnable(list, inputStream, false);
                this.readers.add(new WeakReference<LoggerRunnable>(loggerRunnable));
                requestProcessor.post((Runnable)loggerRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFiles(List<Recognizer> list, File ... fileArray) {
        List<WeakReference<LoggerRunnable>> list2 = this.readers;
        synchronized (list2) {
            this.stopReaders();
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            for (File file : fileArray) {
                try {
                    LoggerRunnable loggerRunnable = new LoggerRunnable(list, new FileInputStream(file), true);
                    this.readers.add(new WeakReference<LoggerRunnable>(loggerRunnable));
                    requestProcessor.post((Runnable)loggerRunnable);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.log(Level.FINE, fileNotFoundException.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReaders() {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            for (WeakReference<LoggerRunnable> weakReference : this.readers) {
                LoggerRunnable loggerRunnable = (LoggerRunnable)weakReference.get();
                if (loggerRunnable == null) continue;
                loggerRunnable.stop();
            }
            this.readers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReader(LoggerRunnable loggerRunnable) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            int n = this.readers.size();
            for (int i = 0; i < n; ++i) {
                WeakReference<LoggerRunnable> weakReference = this.readers.get(i);
                if (loggerRunnable != weakReference.get()) continue;
                this.readers.remove(i);
                break;
            }
        }
    }

    public synchronized void write(String string, boolean bl) {
        OutputWriter outputWriter = this.getWriter(bl);
        if (outputWriter != null) {
            outputWriter.print(string);
        }
    }

    public synchronized void write(String string, OutputListener outputListener, boolean bl, boolean bl2) {
        try {
            OutputWriter outputWriter = this.getWriter(bl2);
            if (outputWriter != null) {
                outputWriter.println(string, outputListener, bl);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, iOException.getLocalizedMessage(), iOException);
        }
    }

    private OutputWriter getWriter(boolean bl) {
        OutputWriter outputWriter;
        OutputWriter outputWriter2 = outputWriter = bl ? this.io.getErr() : this.io.getOut();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getIOWriter: closed = " + this.io.isClosed() + " [ " + (bl ? "STDERR" : "STDOUT") + " ]" + ", output error flag = " + outputWriter.checkError());
        }
        if (outputWriter.checkError()) {
            InputOutput inputOutput = LogViewMgr.getServerIO(this.uri);
            if (inputOutput == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to recreate I/O for " + this.uri + ", still in error state");
                }
                outputWriter = null;
            } else {
                this.io = inputOutput;
                outputWriter = bl ? this.io.getErr() : this.io.getOut();
            }
        }
        return outputWriter;
    }

    private Locale getLogLocale() {
        String string = System.getProperty("user.language");
        if (string != null) {
            return new Locale(string, System.getProperty("user.country", ""), System.getProperty("user.variant", ""));
        }
        return Locale.getDefault();
    }

    private String getLogBundle() {
        return Level.INFO.getResourceBundleName();
    }

    private String getLocalized(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.logBundleName, this.logLocale);
        String string2 = resourceBundle.getString(string);
        return string2 != null ? string2 : string;
    }

    private Map<String, String> getLevelMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Level level : new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.SEVERE, Level.WARNING}) {
            String string = level.getName();
            hashMap.put(string, this.getLocalized(string));
        }
        return hashMap;
    }

    private String getLocalizedLevel(String string) {
        String string2 = this.localizedLevels.get(string);
        return string2 != null ? string2 : string;
    }

    public synchronized void selectIO() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "selectIO: closed = " + this.io.isClosed() + ", output error flag = " + this.io.getOut().checkError());
        }
        this.io.select();
    }

    private static final String stripNewline(String string) {
        int n = string.length();
        if (n > 0 && '\n' == string.charAt(n - 1)) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private boolean isWarning(String string) {
        return string.startsWith(this.localizedWarning) || string.startsWith(this.localizedSevere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutput getServerIO(String string) {
        ServerInstance serverInstance = GlassfishInstanceProvider.getDefault().getInstance(string);
        if (serverInstance == null) {
            return null;
        }
        WeakHashMap<ServerInstance, InputOutput> weakHashMap = ioWeakMap;
        synchronized (weakHashMap) {
            Node node;
            InputOutput inputOutput = ioWeakMap.get(serverInstance);
            if (inputOutput != null) {
                boolean bl = true;
                if (inputOutput.isClosed() && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Output window for " + string + " is closed.");
                }
                if (inputOutput.getOut().checkError()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Standard out for " + string + " is in error state.");
                    }
                    bl = false;
                }
                if (inputOutput.getErr().checkError()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Standard error for " + string + " is in error state.");
                    }
                    bl = false;
                }
                if (bl) {
                    return inputOutput;
                }
                if (!inputOutput.isClosed()) {
                    inputOutput.closeInputOutput();
                }
                ioWeakMap.put(serverInstance, null);
            }
            if ((node = serverInstance.getFullNode()) == null) {
                return null;
            }
            GlassfishModule glassfishModule = (GlassfishModule)node.getLookup().lookup(GlassfishModule.class);
            if (glassfishModule == null) {
                return null;
            }
            Action[] actionArray = new Action[]{new StartServerAction.OutputAction(glassfishModule), new DebugAction.OutputAction(glassfishModule), new RestartAction.OutputAction(glassfishModule), new StopServerAction.OutputAction(glassfishModule), new RefreshAction.OutputAction(glassfishModule)};
            InputOutput inputOutput2 = null;
            WeakHashMap<ServerInstance, InputOutput> weakHashMap2 = ioWeakMap;
            synchronized (weakHashMap2) {
                inputOutput2 = ioWeakMap.get(serverInstance);
                if (inputOutput2 == null) {
                    inputOutput2 = IOProvider.getDefault().getIO(serverInstance.getDisplayName(), actionArray);
                    ioWeakMap.put(serverInstance, inputOutput2);
                }
            }
            return inputOutput2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogFileFilter
    extends StateFilter {
        private String time;
        private String type;
        private String version;
        private String classinfo;
        private String threadinfo;
        private boolean multiline;
        private final Map<String, String> typeMap;

        public LogFileFilter(Map<String, String> map) {
            this.typeMap = map;
            this.reset();
        }

        @Override
        protected void reset() {
            super.reset();
            this.threadinfo = "";
            this.classinfo = "";
            this.version = "";
            this.type = "";
            this.time = "";
            this.multiline = false;
        }

        private String getLocalizedType(String string) {
            String string2 = this.typeMap.get(string);
            return string2 != null ? string2 : string;
        }

        @Override
        public String process(char c) {
            String string = null;
            switch (this.state) {
                case 0: {
                    if (c == '[') {
                        this.state = 1;
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        string = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 1: {
                    if (c == '#') {
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        string = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append('[');
                    this.msg.append(c);
                    break;
                }
                case 2: {
                    if (c == '|') {
                        this.state = 3;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        string = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.state = 0;
                    this.msg.append('[');
                    this.msg.append('#');
                    this.msg.append(c);
                    break;
                }
                case 3: {
                    if (c == '|') {
                        this.state = 4;
                        this.time = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 4: {
                    if (c == '|') {
                        this.state = 5;
                        this.type = this.getLocalizedType(this.msg.toString());
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 5: {
                    if (c == '|') {
                        this.state = 6;
                        this.version = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 6: {
                    if (c == '|') {
                        this.state = 7;
                        this.classinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 7: {
                    if (c == '|') {
                        this.state = 8;
                        this.threadinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 8: {
                    if (c == '|') {
                        this.state = 9;
                        this.message = this.msg.toString();
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append('\n');
                        string = !this.multiline ? this.type + ": " + this.msg.toString() : this.msg.toString();
                        this.multiline = true;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 9: {
                    if (c == '#') {
                        this.state = 10;
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append(c);
                    break;
                }
                case 10: {
                    if (c == ']') {
                        this.state = 0;
                        this.msg.setLength(0);
                        string = (this.multiline ? this.message : this.type + ": " + this.message) + '\n';
                        this.reset();
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append('#');
                    this.msg.append(c);
                }
            }
            return string;
        }
    }

    private static final class StreamFilter
    extends StateFilter {
        private static final Pattern messagePattern = Pattern.compile("([\\p{Lu}]{0,16}?):|([^\\r\\n]{0,24}?\\d\\d?:\\d\\d?:\\d\\d?)");
        private String line;

        public StreamFilter() {
            this.reset();
        }

        protected void reset() {
            super.reset();
            this.line = "";
        }

        public String process(char c) {
            String string = null;
            if (c == '\n') {
                if (this.msg.length() > 0) {
                    this.msg.append(c);
                    this.line = this.msg.toString();
                    this.msg.setLength(0);
                    Matcher matcher = messagePattern.matcher(this.line);
                    string = matcher.find() && matcher.start() == 0 && matcher.groupCount() > 1 && matcher.group(2) != null ? null : this.line;
                }
            } else if (c != '\r') {
                this.msg.append(c);
            }
            return string;
        }
    }

    private static abstract class StateFilter
    implements Filter {
        protected String message;
        protected int state = 0;
        protected StringBuilder msg = new StringBuilder(128);

        StateFilter() {
        }

        protected void reset() {
            this.message = "";
        }

        public abstract String process(char var1);
    }

    private static interface Filter {
        public String process(char var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoggerRunnable
    implements Runnable {
        private final List<Recognizer> recognizers;
        private final InputStream inputStream;
        private final boolean ignoreEof;
        private volatile boolean shutdown;

        public LoggerRunnable(List<Recognizer> list, InputStream inputStream, boolean bl) {
            this.recognizers = list;
            this.inputStream = inputStream;
            this.ignoreEof = bl;
            this.shutdown = false;
        }

        public void stop() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            BufferedReader bufferedReader = null;
            try {
                Thread.currentThread().setName(this.getClass().getName() + " - " + this.inputStream);
                bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                StateFilter stateFilter = this.ignoreEof ? new LogFileFilter(LogViewMgr.this.localizedLevels) : new StreamFilter();
                char[] cArray = new char[1024];
                int n = 0;
                while (!this.shutdown && n != -1) {
                    if (this.ignoreEof) {
                        while (!this.shutdown && bufferedReader.ready()) {
                            String string2 = stateFilter.process((char)bufferedReader.read());
                            if (string2 == null) continue;
                            this.processLine(string2);
                        }
                    } else {
                        while (!this.shutdown && (n = bufferedReader.read(cArray)) != -1) {
                            for (int i = 0; i < n; ++i) {
                                String string3 = stateFilter.process(cArray[i]);
                                if (string3 == null) continue;
                                this.processLine(string3);
                            }
                            if (bufferedReader.ready()) continue;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "I/O exception reading server log", iOException);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "I/O exception closing server log", iOException);
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, "I/O exception closing stream buffer", iOException);
                    }
                }
                LogViewMgr.this.removeReader(this);
                Thread.currentThread().setName(string);
            }
        }

        private void processLine(String string) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "processing text: '" + string + "'");
            }
            OutputListener outputListener = null;
            Iterator<Recognizer> iterator = this.recognizers.iterator();
            while (iterator.hasNext() && outputListener == null) {
                outputListener = iterator.next().processLine(string);
            }
            boolean bl = LogViewMgr.this.isWarning(string);
            if (outputListener != null) {
                string = LogViewMgr.stripNewline(string);
                LogViewMgr.this.write(string, outputListener, false, bl);
            } else {
                LogViewMgr.this.write(string, bl);
            }
            LogViewMgr.this.selectIO();
        }
    }
}

