/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Utilities;

public final class RuntimeHelper {
    public static final String GRAILS_HOME_PROPERTY = "GRAILS_HOME";
    public static final String WIN_EXECUTABLE_FILE = "grails.bat";
    public static final String WIN_EXECUTABLE = "\\bin\\grails.bat";
    public static final String NIX_EXECUTABLE_FILE = "grails";
    public static final String NIX_EXECUTABLE = "/bin/grails";
    private static final Logger LOGGER = Logger.getLogger(RuntimeHelper.class.getName());

    private RuntimeHelper() {
    }

    public static boolean isValidRuntime(File file) {
        String string = Utilities.isWindows() ? WIN_EXECUTABLE : NIX_EXECUTABLE;
        return new File(file, string).isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRuntimeVersion(File file) {
        if (!RuntimeHelper.isValidRuntime(file)) {
            return null;
        }
        Properties properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(file, "build.properties")));
            try {
                properties.load(bufferedInputStream);
            }
            finally {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return null;
        }
        return properties.getProperty("grails.version");
    }

    public static File getSystemDefaultRuntime() {
        String string = System.getenv(GRAILS_HOME_PROPERTY);
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (RuntimeHelper.isValidRuntime(file)) {
            return file;
        }
        return null;
    }
}

