/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.spring.container.servlet;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.impl.container.servlet.PerSessionProvider;
import com.sun.jersey.impl.resource.PerRequestProvider;
import com.sun.jersey.impl.resource.SingletonProvider;
import com.sun.jersey.spi.resource.ResourceProvider;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringResourceProvider
implements ResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(SpringResourceProvider.class.getName());
    private ResourceProvider _resourceProvider;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(ComponentProvider provider, ComponentProvider resourceProvider, AbstractResource resource) {
        Class<PerRequestProvider> resourceProviderClass;
        Class resourceClass = resource.getResourceClass();
        if (!this.isAutodetectedSpringComponent(resourceClass)) {
            resourceProviderClass = PerRequestProvider.class;
        } else {
            Scope scope = resourceClass.getAnnotation(Scope.class);
            if (scope != null) {
                SupportedSpringScopes springScope = SupportedSpringScopes.valueOfSpringScope(scope.value());
                if (springScope == null) throw new RuntimeException("No jersey lifecycle annotation specified on resource class " + resourceClass.getName() + " and also no valid spring scope (valid scopes: " + SupportedSpringScopes.getSpringScopesAsCSV() + ")");
                resourceProviderClass = springScope.getResourceProviderClass();
            } else {
                resourceProviderClass = SupportedSpringScopes.defaultSpringScope().getResourceProviderClass();
            }
        }
        try {
            this._resourceProvider = (ResourceProvider)provider.getInstance(ComponentProvider.Scope.PerRequest, resourceProviderClass);
            this._resourceProvider.init(provider, resourceProvider, resource);
            return;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Could not initialize resource provider for resource class " + resourceClass.getName(), e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not initialize resource provider for resource class " + resourceClass.getName(), e);
            throw new RuntimeException("Could not initialize resource provider for resource class ", e);
        }
    }

    private boolean isAutodetectedSpringComponent(Class<?> resourceClass) {
        Annotation[] annotations = resourceClass.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.equals(Component.class) && annotationType.getAnnotation(Component.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Object getInstance(ComponentProvider provider, HttpContext context) {
        return this._resourceProvider.getInstance(provider, context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedSpringScopes {
        SINGLETON("singleton", SingletonProvider.class),
        PROTOTYPE("prototype", PerRequestProvider.class),
        REQUEST("request", PerRequestProvider.class),
        SESSION("session", PerSessionProvider.class);

        private final String _springScope;
        private final Class<? extends ResourceProvider> _resourceProviderClass;

        private SupportedSpringScopes(String springScope, Class<? extends ResourceProvider> resourceProviderClass) {
            this._springScope = springScope;
            this._resourceProviderClass = resourceProviderClass;
        }

        public Class<? extends ResourceProvider> getResourceProviderClass() {
            return this._resourceProviderClass;
        }

        public String getSpringScope() {
            return this._springScope;
        }

        public static SupportedSpringScopes defaultSpringScope() {
            return SINGLETON;
        }

        public static SupportedSpringScopes valueOfSpringScope(String springScope) {
            for (SupportedSpringScopes scope : SupportedSpringScopes.values()) {
                if (!scope.getSpringScope().equals(springScope)) continue;
                return scope;
            }
            return null;
        }

        public static String getSpringScopesAsCSV() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < SupportedSpringScopes.values().length; ++i) {
                SupportedSpringScopes item = SupportedSpringScopes.values()[i];
                sb.append(item.getSpringScope());
                if (i >= SupportedSpringScopes.values().length - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }
}

