/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.NoVarsDynamicScope;

public class OneVarDynamicScope
extends NoVarsDynamicScope {
    protected IRubyObject variableValueZero;

    public OneVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public OneVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 1) {
            throw new RuntimeException("OneVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new OneVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero};
    }

    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        return this.variableValueZero;
    }

    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        assert (offset2 == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        if (this.variableValueZero == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return this.variableValueZero;
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueZero == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return this.variableValueZero;
    }

    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        assert (offset2 == 0) : "SingleVarDynamicScope only supports one variable";
        this.variableValueZero = value2;
        return this.variableValueZero;
    }

    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        assert (offset2 == 0) : "SingleVarDynamicScope only supports one variable";
        this.variableValueZero = value2;
        return this.variableValueZero;
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject value2) {
        this.variableValueZero = value2;
        return this.variableValueZero;
    }

    public void setArgValues(IRubyObject[] values, int size2) {
        assert (values.length == 1) : "SingleVarDynamicScope only supports one variable";
        if (size2 == 1) {
            this.variableValueZero = values[0];
        }
    }

    public void setArgValues(IRubyObject arg0) {
        this.variableValueZero = arg0;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        assert (false) : "SingleVarDynamicScope only supports one variable not two";
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        assert (false) : "SingleVarDynamicScope only supports one variable not three";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 1) : "OneVarDynamicScope only supports one variable";
        if (this.staticScope.getRestArg() < 0) {
            if (totalArgs == 1) {
                return new IRubyObject[]{this.variableValueZero};
            }
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        if (totalArgs == 1) {
            argValues[0] = this.variableValueZero;
        }
        return argValues;
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names2 = this.staticScope.getVariables();
        buf.append(names2[0]).append("=");
        if (this.variableValueZero == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueZero);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

