/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jruby.objectweb.asm.ClassReader;
import org.jruby.Ruby;
import org.jruby.ast.executable.Script;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyClassLoader;

public class JavaCompiledScript
implements Library {
    private final LoadServiceResource resource;

    public JavaCompiledScript(LoadServiceResource resource2) {
        this.resource = resource2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Ruby runtime2, boolean wrap2) {
        InputStream in = null;
        try {
            try {
                in = new BufferedInputStream(this.resource.getURL().openStream());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[8196];
                int read2 = 0;
                while ((read2 = in.read(buf)) != -1) {
                    baos.write(buf, 0, read2);
                }
                buf = baos.toByteArray();
                JRubyClassLoader jcl = runtime2.getJRubyClassLoader();
                ClassReader cr = new ClassReader(buf);
                String className = cr.getClassName().replace('/', '.');
                Class<?> clazz = null;
                try {
                    clazz = jcl.loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = jcl.defineClass(className, buf);
                }
                if (Script.class.isAssignableFrom(clazz)) {
                    ((Script)clazz.newInstance()).load(runtime2.getCurrentContext(), runtime2.getTopSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                }
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
            catch (InstantiationException ie) {
                throw runtime2.newLoadError("Error loading compiled script: " + ie);
            }
            catch (IllegalAccessException iae) {
                throw runtime2.newLoadError("Error loading compiled script: " + iae);
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw runtime2.newIOErrorFromException(ioe);
            }
        }
        try {}
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        in.close();
    }
}

