/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected RubyModule protectedClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        assert (implementationClass != null);
        this.init(implementationClass, visibility, callConfig);
    }

    protected DynamicMethod() {
    }

    protected void init(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        this.visibility = visibility;
        this.implementationClass = implementationClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implementationClass);
        this.callConfig = callConfig;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg2) {
        return this.call(context, self, klazz, name2, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self, klazz, name2, arg1, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.call(context, self, klazz, name2, arg1, arg2, arg3, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2) {
        return this.call(context, self, klazz, name2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, Block block) {
        return this.call(context, self, klazz, name2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg2, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg2}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg1, arg2}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg1, arg2, arg3}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller2, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                return this.protectedAccessOk(caller2);
            }
        }
        return true;
    }

    private boolean protectedAccessOk(IRubyObject caller2) {
        return this.getProtectedClass().isInstance(caller2);
    }

    protected static RubyModule calculateProtectedClass(RubyModule cls) {
        if (cls.isSingleton()) {
            cls = cls.getSuperClass();
        }
        while (cls.isIncluded()) {
            cls = cls.getMetaClass();
        }
        if (cls instanceof MetaClass) {
            cls = ((MetaClass)cls).getRealClass();
        }
        return cls;
    }

    protected RubyModule getProtectedClass() {
        return this.protectedClass;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implClass);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public final boolean isUndefined() {
        return this instanceof UndefinedMethod;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfig) {
        this.callConfig = callConfig;
    }

    public boolean isNative() {
        return false;
    }

    protected IRubyObject handleRedo(Ruby runtime2) throws RaiseException {
        throw runtime2.newLocalJumpError("redo", runtime2.getNil(), "unexpected redo");
    }

    protected IRubyObject handleReturn(ThreadContext context, JumpException.ReturnJump rj) {
        if (rj.getTarget() == context.getFrameJumpTarget()) {
            return (IRubyObject)rj.getValue();
        }
        throw rj;
    }
}

