/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.IntByReference;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.util.Platform;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UNIXSocket"}, parent="BasicSocket")
public class RubyUNIXSocket
extends RubyBasicSocket {
    protected static LibCSocket INSTANCE = null;
    private static ObjectAllocator UNIXSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyUNIXSocket(runtime2, klass);
        }
    };
    protected int fd;
    protected String fpath;
    protected static final int F_GETFL = 3;
    protected static final int F_SETFL = 4;
    protected static final int O_NONBLOCK = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryUnixDomainSocket() {
        if (INSTANCE != null) {
            return true;
        }
        try {
            Class<RubyUNIXSocket> clazz = RubyUNIXSocket.class;
            synchronized (RubyUNIXSocket.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return true;
                }
                INSTANCE = (LibCSocket)Native.loadLibrary("c", LibCSocket.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void createUNIXSocket(Ruby runtime2) {
        RubyClass rb_cUNIXSocket = runtime2.defineClass("UNIXSocket", runtime2.fastGetClass("BasicSocket"), UNIXSOCKET_ALLOCATOR);
        runtime2.getObject().fastSetConstant("UNIXsocket", rb_cUNIXSocket);
        rb_cUNIXSocket.defineAnnotatedMethods(RubyUNIXSocket.class);
    }

    public RubyUNIXSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected void rb_sys_fail(String message) {
        RubyUNIXSocket.rb_sys_fail(this.getRuntime(), message);
    }

    protected static void rb_sys_fail(Ruby runtime2, String message) {
        int n = Native.getLastError();
        Native.setLastError(0);
        IRubyObject arg2 = message != null ? runtime2.newString(message) : runtime2.getNil();
        RubyClass instance = runtime2.getErrno(n);
        if (instance == null) {
            instance = runtime2.getSystemCallError();
            throw new RaiseException((RubyException)instance.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{arg2, runtime2.newFixnum(n)}, Block.NULL_BLOCK));
        }
        throw new RaiseException((RubyException)instance.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{arg2}, Block.NULL_BLOCK));
    }

    protected void init_unixsock(IRubyObject _path, boolean server) throws Exception {
        int status2;
        this.fd = -1;
        try {
            this.fd = INSTANCE.socket(1, 1, 0);
        }
        catch (UnsatisfiedLinkError ule) {
            // empty catch block
        }
        if (this.fd < 0) {
            this.rb_sys_fail("socket(2)");
        }
        LibCSocket.sockaddr_un sockaddr = new LibCSocket.sockaddr_un();
        sockaddr.setFamily(1);
        ByteList path2 = _path.convertToString().getByteList();
        this.fpath = path2.toString();
        if (sockaddr.sun_path.length <= path2.realSize) {
            throw this.getRuntime().newArgumentError("too long unix socket path (max: " + (sockaddr.sun_path.length - 1) + "bytes)");
        }
        System.arraycopy(path2.bytes, path2.begin, sockaddr.sun_path, 0, path2.realSize);
        if (server) {
            status2 = INSTANCE.bind(this.fd, sockaddr, 106);
        } else {
            try {
                status2 = INSTANCE.connect(this.fd, sockaddr, 106);
            }
            catch (RuntimeException e) {
                INSTANCE.close(this.fd);
                throw e;
            }
        }
        if (status2 < 0) {
            INSTANCE.close(this.fd);
            this.rb_sys_fail(this.fpath);
        }
        if (server) {
            INSTANCE.listen(this.fd, 5);
        }
        this.init_sock();
        if (server) {
            this.openFile.setPath(this.fpath);
        }
    }

    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname, IRubyObject val) {
        int level2 = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        block0 : switch (level2) {
            case 65535: {
                switch (opt) {
                    case 8: {
                        byte[] byArray;
                        if (this.asBoolean(val)) {
                            byte[] byArray2 = new byte[4];
                            byArray2[0] = 32;
                            byArray2[1] = 0;
                            byArray2[2] = 0;
                            byArray = byArray2;
                            byArray2[3] = 0;
                        } else {
                            byte[] byArray3 = new byte[4];
                            byArray3[0] = 0;
                            byArray3[1] = 0;
                            byArray3[2] = 0;
                            byArray = byArray3;
                            byArray3[3] = 0;
                        }
                        int res = INSTANCE.setsockopt(this.fd, level2, opt, byArray, 4);
                        if (res != -1) break block0;
                        this.rb_sys_fail(this.openFile.getPath());
                        break block0;
                    }
                    default: {
                        throw this.getRuntime().newErrnoENOPROTOOPTError();
                    }
                }
            }
            default: {
                throw this.getRuntime().newErrnoENOPROTOOPTError();
            }
        }
        return this.getRuntime().newFixnum(0);
    }

    protected void init_sock() throws Exception {
        ModeFlags modes = new ModeFlags(2L);
        this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(new UnixDomainSocketChannel(this.fd), RubyUNIXSocket.getNewFileno(), modes, new FileDescriptor())));
        this.openFile.setPipeStream(this.openFile.getMainStream());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.getMainStream().setSync(true);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject path2) throws Exception {
        this.init_unixsock(path2, false);
        return this;
    }

    private String unixpath(LibCSocket.sockaddr_un addr2, IntByReference len) throws Exception {
        int firstZero = 0;
        for (int i = 0; i < addr2.sun_path.length; ++i) {
            if (addr2.sun_path[i] != 0) continue;
            firstZero = i;
            break;
        }
        if (len.getValue() > 0) {
            return new String(addr2.sun_path, 0, firstZero, "ISO8859-1");
        }
        return "";
    }

    private IRubyObject unixaddr(LibCSocket.sockaddr_un addr2, IntByReference len) throws Exception {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.getRuntime().newString("AF_UNIX"), this.getRuntime().newString(this.unixpath(addr2, len))});
    }

    @JRubyMethod
    public IRubyObject path() throws Exception {
        if (this.openFile.getPath() == null) {
            LibCSocket.sockaddr_un addr2 = new LibCSocket.sockaddr_un();
            IntByReference len = new IntByReference(106);
            if (INSTANCE.getsockname(this.fd, addr2, len) < 0) {
                this.rb_sys_fail(null);
            }
            this.openFile.setPath(this.unixpath(addr2, len));
        }
        return this.getRuntime().newString(this.openFile.getPath());
    }

    @JRubyMethod
    public IRubyObject addr() throws Exception {
        LibCSocket.sockaddr_un addr2 = new LibCSocket.sockaddr_un();
        IntByReference len = new IntByReference(106);
        if (INSTANCE.getsockname(this.fd, addr2, len) < 0) {
            this.rb_sys_fail("getsockname(2)");
        }
        return this.unixaddr(addr2, len);
    }

    @JRubyMethod
    public IRubyObject peeraddr() throws Exception {
        LibCSocket.sockaddr_un addr2 = new LibCSocket.sockaddr_un();
        IntByReference len = new IntByReference(106);
        if (INSTANCE.getpeername(this.fd, addr2, len) < 0) {
            this.rb_sys_fail("getpeername(2)");
        }
        return this.unixaddr(addr2, len);
    }

    @JRubyMethod(name={"recvfrom"}, required=1, optional=1)
    public IRubyObject recvfrom(IRubyObject[] args2) throws Exception {
        ByteBuffer str = ByteBuffer.allocateDirect(1024);
        LibCSocket.sockaddr_un buf = new LibCSocket.sockaddr_un();
        IntByReference alen = new IntByReference(106);
        IRubyObject flg = Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) == 2 ? args2[1] : this.getRuntime().getNil();
        IRubyObject len = args2[0];
        int flags = flg.isNil() ? 0 : RubyNumeric.fix2int(flg);
        int buflen = RubyNumeric.fix2int(len);
        int slen = INSTANCE.recvfrom(this.fd, str, buflen, flags, buf, alen);
        if (slen < 0) {
            this.rb_sys_fail("recvfrom(2)");
        }
        if (slen < buflen) {
            buflen = slen;
        }
        byte[] outp = new byte[buflen];
        str.get(outp);
        RubyString _str = this.getRuntime().newString(new ByteList(outp, 0, buflen, false));
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{_str, this.unixaddr(buf, alen)});
    }

    @JRubyMethod
    public IRubyObject send_io(IRubyObject path2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public IRubyObject recv_io(IRubyObject[] args2) {
        return this.getRuntime().getNil();
    }

    public IRubyObject close() {
        super.close();
        INSTANCE.close(this.fd);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject open(IRubyObject recv2, IRubyObject path2) {
        return RuntimeHelpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, "new", path2);
    }

    private static int getSocketType(IRubyObject tp) {
        if (tp instanceof RubyString) {
            String str = tp.toString();
            if ("SOCK_STREAM".equals(str)) {
                return 1;
            }
            if ("SOCK_DGRAM".equals(str)) {
                return 2;
            }
            if ("SOCK_RAW".equals(str)) {
                return 3;
            }
            return -1;
        }
        return RubyNumeric.fix2int(tp);
    }

    @JRubyMethod(name={"socketpair", "pair"}, optional=2, meta=true)
    public static IRubyObject socketpair(IRubyObject recv2, IRubyObject[] args2) throws Exception {
        int domain = 1;
        Ruby runtime2 = recv2.getRuntime();
        Arity.checkArgumentCount(runtime2, args2, 0, 2);
        int type2 = args2.length == 0 ? 1 : RubyUNIXSocket.getSocketType(args2[0]);
        int protocol = args2.length <= 1 ? 0 : RubyNumeric.fix2int(args2[1]);
        int[] sp = new int[2];
        int ret = -1;
        try {
            ret = INSTANCE.socketpair(domain, type2, protocol, sp);
        }
        catch (UnsatisfiedLinkError ule) {
            // empty catch block
        }
        if (ret < 0) {
            RubyUNIXSocket.rb_sys_fail(runtime2, "socketpair(2)");
        }
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(runtime2.getCurrentContext(), runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = sp[0];
        sock.init_sock();
        RubyUNIXSocket sock2 = (RubyUNIXSocket)RuntimeHelpers.invoke(runtime2.getCurrentContext(), runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock2.fd = sp[1];
        sock2.init_sock();
        return recv2.getRuntime().newArrayNoCopy(new IRubyObject[]{sock, sock2});
    }

    public static interface LibCSocket
    extends Library {
        public int socketpair(int var1, int var2, int var3, int[] var4);

        public int socket(int var1, int var2, int var3);

        public int connect(int var1, sockaddr_un var2, int var3);

        public int bind(int var1, sockaddr_un var2, int var3);

        public int listen(int var1, int var2);

        public int accept(int var1, sockaddr_un var2, IntByReference var3);

        public int getsockname(int var1, sockaddr_un var2, IntByReference var3);

        public int getpeername(int var1, sockaddr_un var2, IntByReference var3);

        public int getsockopt(int var1, int var2, int var3, byte[] var4, IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, byte[] var4, int var5);

        public int recv(int var1, Buffer var2, int var3, int var4);

        public int recvfrom(int var1, Buffer var2, int var3, int var4, sockaddr_un var5, IntByReference var6);

        public int send(int var1, Buffer var2, int var3, int var4);

        public int fcntl(int var1, int var2, int var3);

        public int unlink(String var1);

        public int close(int var1);

        public void perror(String var1);

        public static class sockaddr_un
        extends Structure {
            public static final int LENGTH = 106;
            public static final boolean hasLen = Platform.IS_BSD;
            public header sun_header;
            public byte[] sun_path = new byte[104];

            public void setFamily(int family) {
                if (hasLen) {
                    this.sun_header.famlen.sun_family = (byte)family;
                } else {
                    this.sun_header.sun_family = (short)family;
                }
            }

            public int getFamily() {
                if (hasLen) {
                    return this.sun_header.famlen.sun_family;
                }
                return this.sun_header.sun_family;
            }

            public static final class header
            extends Union {
                public famlen famlen;
                public short sun_family;

                public header() {
                    this.setType(hasLen ? famlen.class : Short.TYPE);
                }

                public static final class famlen
                extends Structure {
                    public byte sun_len;
                    public byte sun_family;
                }
            }
        }
    }

    private static class UnixDomainSocketChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final int fd;
        private boolean open = true;

        public UnixDomainSocketChannel(int fd) {
            this.fd = fd;
        }

        public void close() throws IOException {
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public int read(ByteBuffer dst) throws IOException {
            int max2 = dst.remaining();
            int v = INSTANCE.recv(this.fd, dst, max2, 0);
            if (v != -1) {
                dst.position(dst.position() + v);
            }
            return v;
        }

        public int write(ByteBuffer src) throws IOException {
            int max2 = src.remaining();
            int v = INSTANCE.send(this.fd, src, max2, 0);
            if (v != -1) {
                src.position(src.position() + v);
            }
            return v;
        }
    }
}

