/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"BasicSocket"}, parent="IO")
public class RubyBasicSocket
extends RubyIO {
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBasicSocket(runtime2, klass);
        }
    };

    static void createBasicSocket(Ruby runtime2) {
        RubyClass rb_cBasicSocket = runtime2.defineClass("BasicSocket", runtime2.getIO(), BASICSOCKET_ALLOCATOR);
        rb_cBasicSocket.defineAnnotatedMethods(RubyBasicSocket.class);
    }

    public RubyBasicSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected void initSocket(ChannelDescriptor descriptor) {
        this.registerDescriptor(descriptor);
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.fdopen(this.getRuntime(), descriptor, new ModeFlags(0L)));
            this.openFile.setPipeStream(ChannelStream.fdopen(this.getRuntime(), descriptor, new ModeFlags(1L)));
            this.openFile.getPipeStream().setSync(true);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(11);
    }

    public IRubyObject close_write(ThreadContext context) {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        if (this.openFile.getPipeStream() == null && this.openFile.isReadable()) {
            throw this.getRuntime().newIOError("closing non-duplex IO for writing");
        }
        if (!this.openFile.isReadable()) {
            this.close();
        } else {
            Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
            if (socketChannel instanceof SocketChannel || socketChannel instanceof DatagramChannel) {
                try {
                    this.asSocket().shutdownOutput();
                }
                catch (IOException e) {
                    throw this.getRuntime().newIOError(e.getMessage());
                }
            }
            this.openFile.setPipeStream(null);
            this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFD);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        if (!this.openFile.isWritable()) {
            this.close();
        } else if (this.openFile.getPipeStream() != null) {
            Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
            if (socketChannel instanceof SocketChannel || socketChannel instanceof DatagramChannel) {
                try {
                    this.asSocket().shutdownInput();
                }
                catch (IOException e) {
                    throw runtime2.newIOError(e.getMessage());
                }
            }
            this.openFile.setMainStream(this.openFile.getPipeStream());
            this.openFile.setPipeStream(null);
            this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFE);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"send"}, rest=true)
    public IRubyObject write_send(ThreadContext context, IRubyObject[] args2) {
        return this.syswrite(context, args2[0]);
    }

    @JRubyMethod(rest=true)
    public IRubyObject recv(IRubyObject[] args2) {
        OpenFile openFile = this.getOpenFileChecked();
        try {
            return RubyString.newString(this.getRuntime(), openFile.getMainStream().read(RubyNumeric.fix2int(args2[0])));
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            if ("Socket not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    protected InetSocketAddress getLocalSocket() {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)socketChannel).socket().getLocalSocketAddress();
        }
        if (socketChannel instanceof ServerSocketChannel) {
            return (InetSocketAddress)((ServerSocketChannel)socketChannel).socket().getLocalSocketAddress();
        }
        return null;
    }

    protected InetSocketAddress getRemoteSocket() {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)socketChannel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    private Socket asSocket() {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (!(socketChannel instanceof SocketChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((SocketChannel)socketChannel).socket();
    }

    private ServerSocket asServerSocket() {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (!(socketChannel instanceof ServerSocketChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((ServerSocketChannel)socketChannel).socket();
    }

    private DatagramSocket asDatagramSocket() {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (!(socketChannel instanceof DatagramChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((DatagramChannel)socketChannel).socket();
    }

    private IRubyObject getBroadcast() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(socketChannel instanceof DatagramChannel ? this.asDatagramSocket().getBroadcast() : false);
    }

    private void setBroadcast(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setBroadcast(this.asBoolean(val));
        }
    }

    private void setKeepAlive(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setKeepAlive(this.asBoolean(val));
        }
    }

    private void setReuseAddr(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof ServerSocketChannel) {
            this.asServerSocket().setReuseAddress(this.asBoolean(val));
        }
    }

    private void setRcvBuf(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setReceiveBufferSize(this.asNumber(val));
        } else if (socketChannel instanceof ServerSocketChannel) {
            this.asServerSocket().setReceiveBufferSize(this.asNumber(val));
        } else if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setReceiveBufferSize(this.asNumber(val));
        }
    }

    private void setTimeout(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setSoTimeout(this.asNumber(val));
        } else if (socketChannel instanceof ServerSocketChannel) {
            this.asServerSocket().setSoTimeout(this.asNumber(val));
        } else if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setSoTimeout(this.asNumber(val));
        }
    }

    private void setSndBuf(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setSendBufferSize(this.asNumber(val));
        } else if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setSendBufferSize(this.asNumber(val));
        }
    }

    private void setLinger(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            if (val instanceof RubyBoolean && !val.isTrue()) {
                this.asSocket().setSoLinger(false, 0);
            } else {
                int num = this.asNumber(val);
                if (num == -1) {
                    this.asSocket().setSoLinger(false, 0);
                } else {
                    this.asSocket().setSoLinger(true, num);
                }
            }
        }
    }

    private void setOOBInline(IRubyObject val) throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setOOBInline(this.asBoolean(val));
        }
    }

    private int asNumber(IRubyObject val) {
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val);
        }
        return this.stringAsNumber(val);
    }

    private int stringAsNumber(IRubyObject val) {
        String str = val.convertToString().toString();
        int res = 0;
        res += str.charAt(0) << 24;
        res += str.charAt(1) << 16;
        res += str.charAt(2) << 8;
        return res += str.charAt(3);
    }

    protected boolean asBoolean(IRubyObject val) {
        if (val instanceof RubyString) {
            return this.stringAsNumber(val) != 0;
        }
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val) != 0;
        }
        return val.isTrue();
    }

    private IRubyObject getKeepAlive() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(socketChannel instanceof SocketChannel ? this.asSocket().getKeepAlive() : false);
    }

    private IRubyObject getLinger() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(socketChannel instanceof SocketChannel ? (long)this.asSocket().getSoLinger() : 0L);
    }

    private IRubyObject getOOBInline() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(socketChannel instanceof SocketChannel ? this.asSocket().getOOBInline() : false);
    }

    private IRubyObject getRcvBuf() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(socketChannel instanceof SocketChannel ? (long)this.asSocket().getReceiveBufferSize() : (long)(socketChannel instanceof ServerSocketChannel ? this.asServerSocket().getReceiveBufferSize() : this.asDatagramSocket().getReceiveBufferSize()));
    }

    private IRubyObject getSndBuf() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(socketChannel instanceof SocketChannel ? (long)this.asSocket().getSendBufferSize() : (long)(socketChannel instanceof DatagramChannel ? this.asDatagramSocket().getSendBufferSize() : 0));
    }

    private IRubyObject getReuseAddr() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(socketChannel instanceof ServerSocketChannel ? this.asServerSocket().getReuseAddress() : false);
    }

    private IRubyObject getTimeout() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(socketChannel instanceof SocketChannel ? (long)this.asSocket().getSoTimeout() : (long)(socketChannel instanceof ServerSocketChannel ? this.asServerSocket().getSoTimeout() : (socketChannel instanceof DatagramChannel ? this.asDatagramSocket().getSoTimeout() : 0)));
    }

    protected int getSoTypeDefault() {
        return 0;
    }

    private IRubyObject getSoType() throws IOException {
        Channel socketChannel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(socketChannel instanceof SocketChannel ? 1L : (long)(socketChannel instanceof ServerSocketChannel ? 1 : (socketChannel instanceof DatagramChannel ? 2 : this.getSoTypeDefault())));
    }

    private IRubyObject trueFalse(boolean val) {
        return this.getRuntime().newString(val ? " \u0000\u0000\u0000" : "\u0000\u0000\u0000\u0000");
    }

    private IRubyObject number(long s) {
        StringBuilder result = new StringBuilder();
        result.append((char)(s >> 24 & 0xFFL)).append((char)(s >> 16 & 0xFFL));
        result.append((char)(s >> 8 & 0xFFL)).append((char)(s & 0xFFL));
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod
    public IRubyObject getsockopt(IRubyObject lev, IRubyObject optname) {
        int level2 = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        try {
            switch (level2) {
                case 0: 
                case 6: 
                case 17: 
                case 65535: {
                    switch (opt) {
                        case 32: {
                            return this.getBroadcast();
                        }
                        case 8: {
                            return this.getKeepAlive();
                        }
                        case 128: {
                            return this.getLinger();
                        }
                        case 256: {
                            return this.getOOBInline();
                        }
                        case 4098: {
                            return this.getRcvBuf();
                        }
                        case 4: {
                            return this.getReuseAddr();
                        }
                        case 4097: {
                            return this.getSndBuf();
                        }
                        case 4101: 
                        case 4102: {
                            return this.getTimeout();
                        }
                        case 4104: {
                            return this.getSoType();
                        }
                        case 4100: {
                            return this.number(1L);
                        }
                        case 4099: {
                            return this.number(2048L);
                        }
                        case 1: 
                        case 16: 
                        case 1024: 
                        case 4103: {
                            return this.trueFalse(false);
                        }
                    }
                    throw this.getRuntime().newErrnoENOPROTOOPTError();
                }
            }
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        catch (IOException e) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
    }

    @JRubyMethod
    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname, IRubyObject val) {
        int level2 = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        try {
            block1 : switch (level2) {
                case 0: 
                case 6: 
                case 17: 
                case 65535: {
                    switch (opt) {
                        case 32: {
                            this.setBroadcast(val);
                            break block1;
                        }
                        case 8: {
                            this.setKeepAlive(val);
                            break block1;
                        }
                        case 128: {
                            this.setLinger(val);
                            break block1;
                        }
                        case 256: {
                            this.setOOBInline(val);
                            break block1;
                        }
                        case 4098: {
                            this.setRcvBuf(val);
                            break block1;
                        }
                        case 4: {
                            this.setReuseAddr(val);
                            break block1;
                        }
                        case 4097: {
                            this.setSndBuf(val);
                            break block1;
                        }
                        case 4101: 
                        case 4102: {
                            this.setTimeout(val);
                            break block1;
                        }
                        case 1: 
                        case 16: 
                        case 1024: 
                        case 4099: 
                        case 4100: 
                        case 4103: 
                        case 4104: {
                            break block1;
                        }
                    }
                    throw this.getRuntime().newErrnoENOPROTOOPTError();
                }
                default: {
                    throw this.getRuntime().newErrnoENOPROTOOPTError();
                }
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return this.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"getsockname", "__getsockname"})
    public IRubyObject getsockname() {
        InetSocketAddress sock = this.getLocalSocket();
        if (null == sock) {
            throw this.getRuntime().newIOError("Not Supported");
        }
        return this.getRuntime().newString(((Object)sock).toString());
    }

    @JRubyMethod(name={"getpeername", "__getpeername"})
    public IRubyObject getpeername() {
        InetSocketAddress sock = this.getRemoteSocket();
        if (null == sock) {
            throw this.getRuntime().newIOError("Not Supported");
        }
        return this.getRuntime().newString(((Object)sock).toString());
    }

    @JRubyMethod(optional=1)
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        if (this.getRuntime().getSafeLevel() >= 4 && this.tainted_p(context).isFalse()) {
            throw this.getRuntime().newSecurityError("Insecure: can't shutdown socket");
        }
        int how = 2;
        if (args2.length > 0) {
            how = RubyNumeric.fix2int(args2[0]);
        }
        if (how < 0 || 2 < how) {
            throw this.getRuntime().newArgumentError("`how' should be either 0, 1, 2");
        }
        if (how != 2) {
            throw this.getRuntime().newNotImplementedError("Shutdown currently only works with how=2");
        }
        return this.close();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject do_not_reverse_lookup(IRubyObject recv2) {
        return recv2.getRuntime().isDoNotReverseLookupEnabled() ? recv2.getRuntime().getTrue() : recv2.getRuntime().getFalse();
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, meta=true)
    public static IRubyObject set_do_not_reverse_lookup(IRubyObject recv2, IRubyObject flag) {
        recv2.getRuntime().setDoNotReverseLookupEnabled(flag.isTrue());
        return recv2.getRuntime().isDoNotReverseLookupEnabled() ? recv2.getRuntime().getTrue() : recv2.getRuntime().getFalse();
    }
}

