/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.util.ByteList;

public abstract class JNAMemoryIO
implements MemoryIO {
    final Object memory;
    static final JNAMemoryIO NULL = new PointerIO(Pointer.NULL, 0L);

    static final JNAMemoryIO allocate(int size2) {
        return new BufferIO(size2);
    }

    static final JNAMemoryIO allocateDirect(int size2) {
        return new PointerIO(size2);
    }

    JNAMemoryIO(Object memory) {
        this.memory = memory;
    }

    Object getMemory() {
        return this.memory;
    }

    static final JNAMemoryIO wrap(Pointer ptr) {
        return ptr != null ? new PointerIO(ptr, 0L) : NULL;
    }

    static JNAMemoryIO wrap(ByteList buf) {
        return new BufferIO(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin(), buf.length()));
    }

    public abstract Pointer getAddress();

    public abstract Pointer getPointer(long var1);

    public abstract void putPointer(long var1, Pointer var3);

    public abstract JNAMemoryIO slice(long var1);

    public boolean equals(Object obj) {
        return obj instanceof JNAMemoryIO && ((JNAMemoryIO)obj).memory.equals(this.memory);
    }

    public int hashCode() {
        return this.memory.hashCode();
    }

    public JNAMemoryIO getMemoryIO(long offset2) {
        return JNAMemoryIO.wrap(this.getPointer(offset2));
    }

    public void putMemoryIO(long offset2, MemoryIO value2) {
        this.putPointer(offset2, ((JNAMemoryIO)value2).getAddress());
    }

    private static class BufferIO
    extends JNAMemoryIO {
        final ByteBuffer buffer;

        BufferIO(int size2) {
            this(ByteBuffer.allocate(size2).order(ByteOrder.nativeOrder()));
        }

        BufferIO(ByteBuffer buffer) {
            super(buffer);
            this.buffer = buffer;
            throw new RuntimeException("Not implemented");
        }

        public Pointer getAddress() {
            return Pointer.NULL;
        }

        public boolean isNull() {
            return false;
        }

        static ByteBuffer slice(ByteBuffer buffer, int position, int size2) {
            ByteBuffer tmp = buffer.duplicate();
            tmp.position(position).limit(position + size2);
            return tmp.slice();
        }

        public Pointer getPointer(long offset2) {
            if (Platform.getPlatform().longSize() == 32) {
                IntByReference ref = new IntByReference(this.getInt(offset2));
                return ref.getPointer().getPointer(0L);
            }
            LongByReference ref = new LongByReference(this.getLong(offset2));
            return ref.getPointer().getPointer(0L);
        }

        public void putPointer(long offset2, Pointer value2) {
            PointerByReference ref = new PointerByReference(value2);
            if (Platform.getPlatform().longSize() == 32) {
                this.putInt(offset2, ref.getPointer().getInt(0L));
            } else {
                this.putLong(offset2, ref.getPointer().getLong(0L));
            }
        }

        public byte getByte(long offset2) {
            return this.buffer.get((int)offset2);
        }

        public short getShort(long offset2) {
            return this.buffer.getShort((int)offset2);
        }

        public int getInt(long offset2) {
            return this.buffer.getInt((int)offset2);
        }

        public long getLong(long offset2) {
            return this.buffer.getLong((int)offset2);
        }

        public long getNativeLong(long offset2) {
            return NativeLong.SIZE == 4 ? (long)this.buffer.getInt((int)offset2) : this.buffer.getLong((int)offset2);
        }

        public float getFloat(long offset2) {
            return this.buffer.getFloat((int)offset2);
        }

        public double getDouble(long offset2) {
            return this.buffer.getDouble((int)offset2);
        }

        public void putByte(long offset2, byte value2) {
            this.buffer.put((int)offset2, value2);
        }

        public void putShort(long offset2, short value2) {
            this.buffer.putShort((int)offset2, value2);
        }

        public void putInt(long offset2, int value2) {
            this.buffer.putInt((int)offset2, value2);
        }

        public void putLong(long offset2, long value2) {
            this.buffer.putLong((int)offset2, value2);
        }

        public void putNativeLong(long offset2, long value2) {
            if (NativeLong.SIZE == 4) {
                this.putInt(offset2, (int)value2);
            } else {
                this.putLong(offset2, value2);
            }
        }

        public void putFloat(long offset2, float value2) {
            this.buffer.putFloat((int)offset2, value2);
        }

        public void putDouble(long offset2, double value2) {
            this.buffer.putDouble((int)offset2, value2);
        }

        public void get(long offset2, byte[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len).get(dst, off, len);
        }

        public void put(long offset2, byte[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len).put(dst, off, len);
        }

        public void get(long offset2, short[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 2).asShortBuffer().get(dst, off, len);
        }

        public void put(long offset2, short[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 2).asShortBuffer().put(dst, off, len);
        }

        public void get(long offset2, int[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 4).asIntBuffer().get(dst, off, len);
        }

        public void put(long offset2, int[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 4).asIntBuffer().put(dst, off, len);
        }

        public void get(long offset2, long[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 8).asLongBuffer().get(dst, off, len);
        }

        public void put(long offset2, long[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 8).asLongBuffer().put(dst, off, len);
        }

        public void get(long offset2, float[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 4).asFloatBuffer().get(dst, off, len);
        }

        public void put(long offset2, float[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 4).asFloatBuffer().put(dst, off, len);
        }

        public void get(long offset2, double[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 8).asDoubleBuffer().get(dst, off, len);
        }

        public void put(long offset2, double[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset2, len * 8).asDoubleBuffer().put(dst, off, len);
        }

        public int indexOf(long offset2, byte value2) {
            return this.indexOf(offset2, value2, Integer.MAX_VALUE);
        }

        public int indexOf(long offset2, byte value2, int maxlen) {
            while (offset2 > -1L) {
                if (this.buffer.get((int)offset2) == value2) {
                    return (int)offset2;
                }
                ++offset2;
            }
            return -1;
        }

        public void setMemory(long offset2, long size2, byte value2) {
            int i = 0;
            while ((long)i < size2) {
                this.buffer.put(i, value2);
                ++i;
            }
        }

        public void clear() {
            this.setMemory(0L, this.buffer.capacity(), (byte)0);
        }

        public JNAMemoryIO slice(long offset2) {
            return offset2 == 0L ? this : new BufferIO(BufferIO.slice(this.buffer, (int)offset2, this.buffer.capacity() - (int)offset2));
        }
    }

    static final class PointerIO
    extends JNAMemoryIO {
        final Pointer ptr;
        final long size;

        private PointerIO() {
            this(Pointer.NULL, 0L);
        }

        private PointerIO(long size2) {
            this(new Memory(size2), size2);
        }

        private PointerIO(Pointer ptr, long size2) {
            super(ptr);
            this.ptr = ptr;
            this.size = size2;
        }

        public Pointer getAddress() {
            return this.ptr;
        }

        public boolean isNull() {
            return this.ptr == null;
        }

        public byte getByte(long offset2) {
            return this.ptr.getByte(offset2);
        }

        public short getShort(long offset2) {
            return this.ptr.getShort(offset2);
        }

        public int getInt(long offset2) {
            return this.ptr.getInt(offset2);
        }

        public long getLong(long offset2) {
            return this.ptr.getLong(offset2);
        }

        public long getNativeLong(long offset2) {
            return this.ptr.getNativeLong(offset2).longValue();
        }

        public float getFloat(long offset2) {
            return this.ptr.getFloat(offset2);
        }

        public double getDouble(long offset2) {
            return this.ptr.getDouble(offset2);
        }

        public Pointer getPointer(long offset2) {
            return this.ptr.getPointer(offset2);
        }

        public void putByte(long offset2, byte value2) {
            this.ptr.setByte(offset2, value2);
        }

        public void putShort(long offset2, short value2) {
            this.ptr.setShort(offset2, value2);
        }

        public void putInt(long offset2, int value2) {
            this.ptr.setInt(offset2, value2);
        }

        public void putLong(long offset2, long value2) {
            this.ptr.setLong(offset2, value2);
        }

        public void putNativeLong(long offset2, long value2) {
            this.ptr.setNativeLong(offset2, new NativeLong(value2));
        }

        public void putFloat(long offset2, float value2) {
            this.ptr.setFloat(offset2, value2);
        }

        public void putDouble(long offset2, double value2) {
            this.ptr.setDouble(offset2, value2);
        }

        public void putPointer(long offset2, Pointer value2) {
            this.ptr.setPointer(offset2, value2);
        }

        public void get(long offset2, byte[] dst, int off, int len) {
            this.ptr.read(offset2, dst, off, len);
        }

        public void put(long offset2, byte[] dst, int off, int len) {
            this.ptr.write(offset2, dst, off, len);
        }

        public void get(long offset2, short[] dst, int off, int len) {
            this.ptr.read(offset2, dst, off, len);
        }

        public void put(long offset2, short[] dst, int off, int len) {
            this.ptr.write(offset2, dst, off, len);
        }

        public void get(long offset2, int[] dst, int off, int len) {
            this.ptr.read(offset2, dst, off, len);
        }

        public void put(long offset2, int[] dst, int off, int len) {
            this.ptr.write(offset2, dst, off, len);
        }

        public void get(long offset2, long[] dst, int off, int len) {
            this.ptr.read(offset2, dst, off, len);
        }

        public void put(long offset2, long[] dst, int off, int len) {
            this.ptr.write(offset2, dst, off, len);
        }

        public void get(long offset2, float[] dst, int off, int len) {
            this.ptr.read(offset2, dst, off, len);
        }

        public void put(long offset2, float[] dst, int off, int len) {
            this.ptr.write(offset2, dst, off, len);
        }

        public void get(long offset2, double[] dst, int off, int len) {
            this.ptr.read(offset2, dst, off, len);
        }

        public void put(long offset2, double[] dst, int off, int len) {
            this.ptr.write(offset2, dst, off, len);
        }

        public int indexOf(long offset2, byte value2) {
            return (int)this.ptr.indexOf(offset2, value2);
        }

        public int indexOf(long offset2, byte value2, int maxlen) {
            return (int)this.ptr.indexOf(offset2, value2);
        }

        public void setMemory(long offset2, long size2, byte value2) {
            this.ptr.setMemory(offset2, size2, value2);
        }

        public void clear() {
            this.setMemory(0L, this.size, (byte)0);
        }

        public JNAMemoryIO slice(long offset2) {
            return offset2 == 0L ? this : new PointerIO(this.ptr.share(offset2), this.size - offset2);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PointerIO other = (PointerIO)obj;
            return this.ptr == other.ptr || this.ptr != null && this.ptr.equals(other.ptr);
        }

        public int hashCode() {
            return this.ptr == null ? 0 : this.ptr.hashCode();
        }
    }
}

