/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Native;
import java.nio.channels.ByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.jna.FileDescriptorByteChannel;
import org.jruby.ext.ffi.jna.JNABuffer;
import org.jruby.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.ext.ffi.jna.JNAPlatform;
import org.jruby.ext.ffi.jna.JNAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAFactory
extends Factory {
    private final JNAPlatform platform = new JNAPlatform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule module) {
        super.init(runtime2, module);
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (module.fastGetClass("MemoryPointer") == null) {
                JNAMemoryPointer.createMemoryPointerClass(runtime2);
            }
            if (module.fastGetClass("Buffer") == null) {
                JNABuffer.createBufferClass(runtime2);
            }
        }
    }

    @Override
    protected FFIProvider newProvider(Ruby runtime2) {
        return new JNAProvider(runtime2);
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        return libraryClass.cast(Native.loadLibrary(libraryName, libraryClass));
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public ByteChannel newByteChannel(int fd) {
        return new FileDescriptorByteChannel(fd);
    }
}

