/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.compiler.impl.FieldBasedCacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.util.CodegenUtils;

public class InheritedCacheCompiler
extends FieldBasedCacheCompiler {
    public static final int MAX_INHERITED_CALL_SITES = 50;
    public static final int MAX_INHERITED_SYMBOLS = 50;
    public static final int MAX_INHERITED_FIXNUMS = 50;
    int callSiteCount = 0;
    int inheritedSymbolCount = 0;
    int inheritedFixnumCount = 0;
    Map<String, String> inheritedSymbols = new HashMap<String, String>();
    Map<Long, String> inheritedFixnums = new HashMap<Long, String>();

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        super(scriptCompiler);
    }

    public void cacheCallSite(StandardASMCompiler.AbstractMethodCompiler method2, String name2, CallType callType) {
        String fieldName = "site" + this.callSiteCount;
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        method2.loadThis();
        initMethod.ldc(name2);
        if (callType.equals(CallType.NORMAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        if (this.callSiteCount >= 50) {
            this.scriptCompiler.getNewField(CodegenUtils.ci(CallSite.class), fieldName, null);
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method2.method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        } else {
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method2.method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        }
        ++this.callSiteCount;
    }

    public void cacheSymbol(StandardASMCompiler.AbstractMethodCompiler method2, String symbol) {
        String methodName = this.inheritedSymbols.get(symbol);
        if (methodName == null && this.inheritedSymbolCount < 50) {
            methodName = "getSymbol" + this.inheritedSymbolCount++;
            this.inheritedSymbols.put(symbol, methodName);
        }
        if (methodName == null) {
            super.cacheSymbol(method2, symbol);
        } else {
            method2.loadThis();
            method2.loadRuntime();
            method2.method.ldc(symbol);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubySymbol.class, Ruby.class, String.class));
        }
    }

    public void cacheFixnum(StandardASMCompiler.AbstractMethodCompiler method2, long value2) {
        String methodName = this.inheritedFixnums.get(value2);
        if (methodName == null && this.inheritedFixnumCount < 50) {
            methodName = "getFixnum" + this.inheritedFixnumCount++;
            this.inheritedFixnums.put(value2, methodName);
        }
        if (methodName == null) {
            super.cacheFixnum(method2, value2);
        } else {
            method2.loadThis();
            method2.loadRuntime();
            method2.method.ldc(value2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubyFixnum.class, Ruby.class, Long.TYPE));
        }
    }
}

