/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.FutureThread;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject {
    private ThreadLike threadImpl;
    private RubyFixnum priority;
    private transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private IRubyObject receivedException;
    private RubyThreadGroup threadGroup;
    private final ThreadService threadService;
    private volatile boolean isStopped = false;
    private volatile boolean isDead = false;
    public Object stopLock = new Object();
    private volatile boolean killed = false;
    public Object killLock = new Object();
    public final ReentrantLock lock = new ReentrantLock();
    private static final boolean DEBUG = false;
    private Selector currentSelector;

    protected RubyThread(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.threadService = runtime2.getThreadService();
        this.finalResult = runtime2.getNil();
    }

    public void dispose() {
        this.threadGroup.remove(this);
    }

    public static RubyClass createThreadClass(Ruby runtime2) {
        RubyClass threadClass = runtime2.defineClass("Thread", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setThread(threadClass);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime2, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime2.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, true, block);
    }

    @JRubyMethod(name={"start"}, rest=true, frame=true, meta=true)
    public static RubyThread start(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, false, block);
    }

    public static RubyThread adopt(IRubyObject recv2, Thread t) {
        return RubyThread.adoptThread(recv2, t, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject recv2, Thread t, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime2, (RubyClass)recv2);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        ThreadContext context = runtime2.getThreadService().registerNewThread(rubyThread);
        context.preAdoptThread();
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        if (!block.isGiven()) {
            throw runtime2.newThreadError("must be called with a block");
        }
        RubyRunnable runnable = new RubyRunnable(this, args2, block);
        if (RubyInstanceConfig.POOLING_ENABLED) {
            this.threadImpl = new FutureThread(this, runnable);
        } else {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            this.threadImpl = new NativeThread(this, thread);
        }
        runtime2.getDefaultThreadGroup().addDirectly(this);
        this.threadImpl.start();
        Thread.yield();
        return this;
    }

    private static RubyThread startThread(IRubyObject recv2, IRubyObject[] args2, boolean callInit, Block block) {
        RubyThread rubyThread = new RubyThread(recv2.getRuntime(), (RubyClass)recv2);
        if (callInit) {
            rubyThread.callInit(args2, block);
        } else {
            rubyThread.initialize(args2, block);
        }
        return rubyThread;
    }

    private void ensureNotCurrent() {
        if (this == this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    public synchronized void cleanTerminate(IRubyObject result) {
        this.finalResult = result;
        this.isStopped = true;
        this.isDead = true;
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext context) {
        this.threadService.waitForCritical();
        if (this.killed) {
            this.throwThreadKill();
        }
        if (this.receivedException != null) {
            this.receivedAnException(context);
        }
    }

    private void throwThreadKill() {
        throw new ThreadKill();
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return runtime2.isGlobalAbortOnExceptionEnabled() ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject recv2, IRubyObject value2) {
        recv2.getRuntime().setGlobalAbortOnExceptionEnabled(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"current"}, meta=true)
    public static RubyThread current(IRubyObject recv2) {
        return recv2.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(name={"main"}, meta=true)
    public static RubyThread main(IRubyObject recv2) {
        return recv2.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(name={"pass"}, meta=true)
    public static IRubyObject pass(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        ThreadService ts = runtime2.getThreadService();
        boolean critical2 = ts.getCritical();
        ts.setCritical(false);
        Thread.yield();
        ts.setCritical(critical2);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static RubyArray list(IRubyObject recv2) {
        IRubyObject[] activeThreads = recv2.getRuntime().getThreadService().getActiveRubyThreads();
        return recv2.getRuntime().newArrayNoCopy(activeThreads);
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        if (originalKey instanceof RubyString) {
            return this.getRuntime().newSymbol(originalKey.asJavaString());
        }
        if (originalKey instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "Do not use Fixnums as Symbols", new Object[0]);
            throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
        }
        throw this.getRuntime().newTypeError(originalKey + " is not a symbol");
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals() {
        if (this.threadLocalVariables == null) {
            this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.threadLocalVariables;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject key) {
        IRubyObject value2 = this.getThreadLocals().get(this.getSymbolKey(key));
        if (value2 != null) {
            return value2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(IRubyObject key, IRubyObject value2) {
        key = this.getSymbolKey(key);
        this.getThreadLocals().put(key, value2);
        return value2;
    }

    @JRubyMethod(name={"abort_on_exception"})
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return !this.isDead && this.threadImpl.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"join"}, optional=1, backtrace=true)
    public IRubyObject join(IRubyObject[] args2) {
        block16: {
            long timeoutMillis = Long.MAX_VALUE;
            if (args2.length > 0) {
                if (args2.length > 1) {
                    throw this.getRuntime().newArgumentError(args2.length, 1);
                }
                timeoutMillis = (long)(1000.0 * args2[0].convertToFloat().getValue());
                if (timeoutMillis <= 0L) {
                    if (this.threadImpl.isAlive()) {
                        return this.getRuntime().getNil();
                    }
                    return this;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            try {
                if (this.threadService.getCritical()) {
                    Object object = this.stopLock;
                    synchronized (object) {
                        this.stopLock.notify();
                    }
                }
                RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
                long timeToWait = Math.min(timeoutMillis, 200L);
                long start2 = System.currentTimeMillis();
                do {
                    currentThread.pollThreadEvents();
                    this.threadImpl.join(timeToWait);
                } while (this.threadImpl.isAlive() && System.currentTimeMillis() - start2 <= timeoutMillis);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                assert (false) : ie;
            }
            catch (ExecutionException ie) {
                ie.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)ie);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        if (this.threadImpl.isAlive()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"value"})
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod(name={"group"})
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                part.append(this.getRuntime().newString(" sleep"));
            } else if (this.killed) {
                part.append(this.getRuntime().newString(" aborting"));
            } else {
                part.append(this.getRuntime().newString(" run"));
            }
        } else {
            part.append(" dead");
        }
        part.append(">");
        return this.getRuntime().newString(part.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject key) {
        key = this.getSymbolKey(key);
        return this.getRuntime().newBoolean(this.getThreadLocals().containsKey(key));
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        IRubyObject[] keys2 = new IRubyObject[this.getThreadLocals().size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.getThreadLocals().keySet().toArray(keys2));
    }

    @JRubyMethod(name={"critical="}, required=1, meta=true)
    public static IRubyObject critical_set(IRubyObject receiver, IRubyObject value2) {
        receiver.getRuntime().getThreadService().setCritical(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"critical"}, meta=true)
    public static IRubyObject critical(IRubyObject receiver) {
        return receiver.getRuntime().newBoolean(receiver.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"stop"}, meta=true)
    public static IRubyObject stop(IRubyObject receiver) {
        Object stopLock;
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        Object object = stopLock = rubyThread.stopLock;
        synchronized (object) {
            rubyThread.pollThreadEvents();
            try {
                rubyThread.isStopped = true;
                receiver.getRuntime().getThreadService().setCritical(false);
                stopLock.wait();
            }
            catch (InterruptedException ie) {
                rubyThread.pollThreadEvents();
            }
            rubyThread.isStopped = false;
        }
        return receiver.getRuntime().getNil();
    }

    @JRubyMethod(name={"kill"}, required=1, frame=true, meta=true)
    public static IRubyObject kill(IRubyObject receiver, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver.getRuntime().newTypeError(rubyThread, receiver.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(name={"exit"}, frame=true, meta=true)
    public static IRubyObject s_exit(IRubyObject receiver, Block block) {
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        rubyThread.killed = true;
        receiver.getRuntime().getThreadService().setCritical(false);
        throw new ThreadKill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.isStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"wakeup"})
    public RubyThread wakeup() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
        return this;
    }

    @JRubyMethod(name={"priority"})
    public RubyFixnum priority() {
        return this.priority;
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject priority2) {
        int iPriority = RubyNumeric.fix2int(priority2);
        if (iPriority < 1) {
            iPriority = 1;
        } else if (iPriority > 10) {
            iPriority = 10;
        }
        this.priority = RubyFixnum.newFixnum(this.getRuntime(), iPriority);
        if (this.threadImpl.isAlive()) {
            this.threadImpl.setPriority(iPriority);
        }
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"raise"}, optional=2, frame=true)
    public IRubyObject raise(IRubyObject[] args2, Block block) {
        this.ensureNotCurrent();
        Ruby runtime2 = this.getRuntime();
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!currentThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!currentThread.lock.isHeldByCurrentThread()) continue;
                currentThread.lock.unlock();
            }
            currentThread.pollThreadEvents();
            this.receivedException = this.prepareRaiseException(runtime2, args2, block);
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
            this.interrupt();
        }
        finally {
            if (currentThread.lock.isHeldByCurrentThread()) {
                currentThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return this;
    }

    private IRubyObject prepareRaiseException(Ruby runtime2, IRubyObject[] args2, Block block) {
        IRubyObject exception2;
        if (args2.length == 0) {
            IRubyObject lastException = runtime2.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                return new RaiseException(runtime2, runtime2.getRuntimeError(), "", false).getException();
            }
            return lastException;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args2.length == 1) {
            if (args2[0] instanceof RubyString) {
                return runtime2.getRuntimeError().newInstance(context, args2, block);
            }
            if (!args2[0].respondsTo("exception")) {
                return runtime2.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception");
        } else {
            if (!args2[0].respondsTo("exception")) {
                return runtime2.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception", args2[1]);
        }
        if (!runtime2.getException().isInstance(exception2)) {
            return runtime2.newTypeError("exception object expected").getException();
        }
        if (args2.length == 3) {
            ((RubyException)exception2).set_backtrace(args2[2]);
        }
        return exception2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"run"})
    public IRubyObject run() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.isStopped) {
                this.isStopped = false;
                this.stopLock.notifyAll();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long millis) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        Object object = this.stopLock;
        synchronized (object) {
            this.pollThreadEvents();
            try {
                this.isStopped = true;
                this.stopLock.wait(millis);
            }
            finally {
                this.isStopped = false;
                this.pollThreadEvents();
            }
        }
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            if (this.isStopped || this.currentSelector != null && this.currentSelector.isOpen()) {
                return this.getRuntime().newString("sleep");
            }
            if (this.killed) {
                return this.getRuntime().newString("aborting");
            }
            return this.getRuntime().newString("run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        if (currentThread == this) {
            this.throwThreadKill();
        }
        try {
            while (!currentThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!currentThread.lock.isHeldByCurrentThread()) continue;
                currentThread.lock.unlock();
            }
            currentThread.pollThreadEvents();
            this.killed = true;
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
            this.interrupt();
        }
        finally {
            if (currentThread.lock.isHeldByCurrentThread()) {
                currentThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        try {
            this.threadImpl.join();
        }
        catch (InterruptedException ie) {
            currentThread.pollThreadEvents();
        }
        catch (ExecutionException ie) {
            currentThread.pollThreadEvents();
        }
        return this;
    }

    @JRubyMethod(name={"kill!", "exit!", "terminate!"})
    public IRubyObject kill_bang() {
        throw this.getRuntime().newNotImplementedError("Thread#kill!, exit!, and terminate! are not safe and not supported");
    }

    @JRubyMethod(name={"safe_level"})
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception2) {
        assert (this.isCurrent());
        RubyException rubyException = exception2.getException();
        Ruby runtime2 = rubyException.getRuntime();
        if (runtime2.getSystemExit().isInstance(rubyException)) {
            this.threadService.getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(runtime2)) {
                runtime2.printError(rubyException);
                RubySystemExit systemExit = RubySystemExit.newInstance(runtime2, 1);
                systemExit.message = rubyException.message;
                systemExit.set_backtrace(rubyException.backtrace());
                this.threadService.getMainThread().raise(new IRubyObject[]{systemExit}, Block.NULL_BLOCK);
                return;
            }
            if (runtime2.getDebug().isTrue()) {
                runtime2.printError(exception2.getException());
            }
        }
        this.exitingException = exception2;
    }

    private boolean abortOnException(Ruby runtime2) {
        return runtime2.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver) {
        return receiver.getRuntime().getThreadService().getMainThread();
    }

    @Deprecated
    public boolean selectForAccept(RubyIO io2) {
        return this.select(io2, 16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(RubyIO io2, int ops) {
        Channel channel = io2.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean bl;
            boolean oldBlocking;
            block24: {
                boolean bl2;
                block23: {
                    oldBlocking = selectable.isBlocking();
                    try {
                        Set<SelectionKey> keySet;
                        selectable.configureBlocking(false);
                        io2.addBlockingThread(this);
                        this.currentSelector = selectable.provider().openSelector();
                        SelectionKey key = selectable.register(this.currentSelector, ops);
                        int result = this.currentSelector.select();
                        this.pollThreadEvents();
                        if (result == 1 && (keySet = this.currentSelector.selectedKeys()).iterator().next() == key) {
                            bl2 = true;
                            break block23;
                        }
                        bl = false;
                        break block24;
                    }
                    catch (IOException ioe) {
                        throw io2.getRuntime().newRuntimeError("Error with selector: " + ioe);
                    }
                }
                return bl2;
            }
            return bl;
            finally {
                if (this.currentSelector != null) {
                    try {
                        this.currentSelector.close();
                    }
                    catch (IOException ioe) {
                        throw io2.getRuntime().newRuntimeError("Could not close selector");
                    }
                }
                this.currentSelector = null;
                io2.removeBlockingThread(this);
                try {
                    selectable.configureBlocking(oldBlocking);
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void interrupt() {
        if (this.currentSelector != null) {
            this.currentSelector.wakeup();
        }
    }

    public void beforeBlockingCall() {
        this.isStopped = true;
    }

    public void afterBlockingCall() {
        this.isStopped = false;
    }

    private void receivedAnException(ThreadContext context) {
        IRubyObject raiseException = this.receivedException;
        this.receivedException = null;
        RubyModule kernelModule = this.getRuntime().getKernel();
        kernelModule.callMethod(context, "raise", raiseException);
    }
}

