/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"NKF"})
public class RubyNKF {
    public static final NKFCharset AUTO = new NKFCharset(0, "x-JISAutoDetect");
    public static final NKFCharset JIS = new NKFCharset(1, "iso-2022-jp");
    public static final NKFCharset EUC = new NKFCharset(2, "EUC-JP");
    public static final NKFCharset SJIS = new NKFCharset(3, "Windows-31J");
    public static final NKFCharset BINARY = new NKFCharset(4, null);
    public static final NKFCharset NOCONV = new NKFCharset(4, null);
    public static final NKFCharset UNKNOWN = new NKFCharset(0, null);
    public static final NKFCharset ASCII = new NKFCharset(5, "iso-8859-1");
    public static final NKFCharset UTF8 = new NKFCharset(6, "UTF-8");
    public static final NKFCharset UTF16 = new NKFCharset(8, "UTF-16");
    public static final NKFCharset UTF32 = new NKFCharset(12, "UTF-32");
    public static final NKFCharset OTHER = new NKFCharset(16, null);

    public static void createNKF(Ruby runtime2) {
        RubyModule nkfModule = runtime2.defineModule("NKF");
        nkfModule.defineConstant("AUTO", RubyFixnum.newFixnum(runtime2, AUTO.getValue()));
        nkfModule.defineConstant("JIS", RubyFixnum.newFixnum(runtime2, JIS.getValue()));
        nkfModule.defineConstant("EUC", RubyFixnum.newFixnum(runtime2, EUC.getValue()));
        nkfModule.defineConstant("SJIS", RubyFixnum.newFixnum(runtime2, SJIS.getValue()));
        nkfModule.defineConstant("BINARY", RubyFixnum.newFixnum(runtime2, BINARY.getValue()));
        nkfModule.defineConstant("NOCONV", RubyFixnum.newFixnum(runtime2, NOCONV.getValue()));
        nkfModule.defineConstant("UNKNOWN", RubyFixnum.newFixnum(runtime2, UNKNOWN.getValue()));
        nkfModule.defineConstant("ASCII", RubyFixnum.newFixnum(runtime2, ASCII.getValue()));
        nkfModule.defineConstant("UTF8", RubyFixnum.newFixnum(runtime2, UTF8.getValue()));
        nkfModule.defineConstant("UTF16", RubyFixnum.newFixnum(runtime2, UTF16.getValue()));
        nkfModule.defineConstant("UTF32", RubyFixnum.newFixnum(runtime2, UTF32.getValue()));
        nkfModule.defineConstant("OTHER", RubyFixnum.newFixnum(runtime2, OTHER.getValue()));
        RubyString version2 = runtime2.newString("2.0.7 (JRuby 2007-05-11)");
        RubyString nkfVersion = runtime2.newString("2.0.7");
        RubyString nkfDate = runtime2.newString("2007-05-11");
        ThreadContext context = runtime2.getCurrentContext();
        version2.freeze(context);
        nkfVersion.freeze(context);
        nkfDate.freeze(context);
        nkfModule.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, required=1, module=true)
    public static IRubyObject guess(ThreadContext context, IRubyObject recv2, IRubyObject s) {
        Ruby runtime2 = context.getRuntime();
        if (!s.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + s.getMetaClass() + " into String");
        }
        ByteList bytes = s.convertToString().getByteList();
        ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin(), bytes.length());
        CharsetDecoder decoder = Charset.forName("x-JISAutoDetect").newDecoder();
        try {
            decoder.decode(buf);
        }
        catch (CharacterCodingException e) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        if (!decoder.isCharsetDetected()) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        Charset charset = decoder.detectedCharset();
        String name2 = charset.name();
        if ("Shift_JIS".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("windows-31j".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("EUC-JP".equals(name2)) {
            return runtime2.newFixnum(EUC.getValue());
        }
        if ("ISO-2022-JP".equals(name2)) {
            return runtime2.newFixnum(JIS.getValue());
        }
        return runtime2.newFixnum(UNKNOWN.getValue());
    }

    @JRubyMethod(name={"guess1"}, required=1, module=true)
    public static IRubyObject guess1(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"guess2"}, required=1, module=true)
    public static IRubyObject guess2(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"nkf"}, required=2, module=true)
    public static IRubyObject nkf(ThreadContext context, IRubyObject recv2, IRubyObject opt, IRubyObject str) {
        Ruby runtime2 = context.getRuntime();
        if (!opt.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + opt.getMetaClass() + " into String");
        }
        if (!str.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + str.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> options2 = RubyNKF.parseOpt(opt.convertToString().toString());
        NKFCharset nc = options2.get("input");
        if (nc.getValue() == AUTO.getValue()) {
            KCode kcode2 = runtime2.getKCode();
            if (kcode2 == KCode.SJIS) {
                nc = SJIS;
            } else if (kcode2 == KCode.EUC) {
                nc = EUC;
            } else if (kcode2 == KCode.UTF8) {
                nc = UTF8;
            }
        }
        String decodeCharset = nc.getCharset();
        String encodeCharset = options2.get("output").getCharset();
        return RubyNKF.convert(context, decodeCharset, encodeCharset, str);
    }

    private static IRubyObject convert(ThreadContext context, String decodeCharset, String encodeCharset, IRubyObject str) {
        CharsetEncoder encoder;
        CharsetDecoder decoder;
        Ruby runtime2 = context.getRuntime();
        try {
            decoder = Charset.forName(decodeCharset).newDecoder();
            encoder = Charset.forName(encodeCharset).newEncoder();
        }
        catch (UnsupportedCharsetException e) {
            throw runtime2.newArgumentError("invalid encoding");
        }
        ByteList bytes = str.convertToString().getByteList();
        ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin(), bytes.length());
        try {
            CharBuffer cbuf = decoder.decode(buf);
            buf = encoder.encode(cbuf);
        }
        catch (CharacterCodingException e) {
            throw runtime2.newArgumentError("invalid encoding");
        }
        byte[] arr = buf.array();
        return runtime2.newString(new ByteList(arr, 0, buf.limit()));
    }

    private static int optionUTF(String s, int i) {
        int n = 8;
        if (i + 1 < s.length() && Character.isDigit(s.charAt(i + 1))) {
            n = Character.digit(s.charAt(i + 1), 10);
            if (i + 2 < s.length() && Character.isDigit(s.charAt(i + 2))) {
                n *= 10;
                n += Character.digit(s.charAt(i + 2), 10);
            }
        }
        return n;
    }

    private static Map<String, NKFCharset> parseOpt(String s) {
        HashMap<String, NKFCharset> options2 = new HashMap<String, NKFCharset>();
        options2.put("input", AUTO);
        options2.put("output", JIS);
        block30: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'b': {
                    continue block30;
                }
                case 'u': {
                    continue block30;
                }
                case 'j': {
                    options2.put("output", JIS);
                    continue block30;
                }
                case 's': {
                    options2.put("output", SJIS);
                    continue block30;
                }
                case 'e': {
                    options2.put("output", EUC);
                    continue block30;
                }
                case 'w': {
                    int n = RubyNKF.optionUTF(s, i);
                    if (n == 32) {
                        options2.put("output", UTF32);
                        continue block30;
                    }
                    if (n == 16) {
                        options2.put("output", UTF16);
                        continue block30;
                    }
                    options2.put("output", UTF8);
                    continue block30;
                }
                case 'J': {
                    options2.put("input", JIS);
                    continue block30;
                }
                case 'S': {
                    options2.put("input", SJIS);
                    continue block30;
                }
                case 'E': {
                    options2.put("input", EUC);
                    continue block30;
                }
                case 'W': {
                    int n = RubyNKF.optionUTF(s, i);
                    if (n == 32) {
                        options2.put("input", UTF32);
                        continue block30;
                    }
                    if (n == 16) {
                        options2.put("input", UTF16);
                        continue block30;
                    }
                    options2.put("input", UTF8);
                    continue block30;
                }
                case 't': {
                    continue block30;
                }
                case 'r': {
                    continue block30;
                }
                case 'h': {
                    continue block30;
                }
                case 'm': {
                    continue block30;
                }
                case 'M': {
                    continue block30;
                }
                case 'l': {
                    continue block30;
                }
                case 'f': {
                    continue block30;
                }
                case 'F': {
                    continue block30;
                }
                case 'Z': {
                    continue block30;
                }
                case 'X': {
                    continue block30;
                }
                case 'x': {
                    continue block30;
                }
                case 'B': {
                    continue block30;
                }
                case 'T': {
                    continue block30;
                }
                case 'd': {
                    continue block30;
                }
                case 'c': {
                    continue block30;
                }
                case 'I': {
                    continue block30;
                }
                case 'L': {
                    continue block30;
                }
                case '-': {
                    if (s.charAt(i + 1) != '-') continue block30;
                }
            }
        }
        return options2;
    }

    public static class NKFCharset {
        private final int value;
        private final String charset;

        public NKFCharset(int v, String c) {
            this.value = v;
            this.charset = c;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

