/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"TrueClass", "FalseClass"})
public class RubyBoolean
extends RubyObject {
    public RubyBoolean(Ruby runtime2, boolean value2) {
        super(runtime2, value2 ? runtime2.getTrueClass() : runtime2.getFalseClass(), false);
        if (!value2) {
            this.flags = 1;
        }
    }

    @Override
    public int getNativeTypeIndex() {
        return (this.flags & 1) == 0 ? 6 : 7;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.TYPE;
    }

    public static RubyClass createFalseClass(Ruby runtime2) {
        RubyClass falseClass = runtime2.defineClass("FalseClass", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setFalseClass(falseClass);
        falseClass.index = 7;
        falseClass.defineAnnotatedMethods(False.class);
        falseClass.getMetaClass().undefineMethod("new");
        return falseClass;
    }

    public static RubyClass createTrueClass(Ruby runtime2) {
        RubyClass trueClass = runtime2.defineClass("TrueClass", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setTrueClass(trueClass);
        trueClass.index = 6;
        trueClass.defineAnnotatedMethods(True.class);
        trueClass.getMetaClass().undefineMethod("new");
        return trueClass;
    }

    public static RubyBoolean newBoolean(Ruby runtime2, boolean value2) {
        return value2 ? runtime2.getTrue() : runtime2.getFalse();
    }

    @Override
    public RubyFixnum id() {
        if ((this.flags & 1) == 0) {
            return RubyFixnum.newFixnum(this.getRuntime(), 2L);
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject freeze(ThreadContext context) {
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }

    public static class True {
        @JRubyMethod(name={"&"})
        public static IRubyObject true_and(IRubyObject t, IRubyObject oth) {
            return oth.isTrue() ? t : t.getRuntime().getFalse();
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject true_or(IRubyObject t, IRubyObject oth) {
            return t;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject true_xor(IRubyObject t, IRubyObject oth) {
            return oth.isTrue() ? t.getRuntime().getFalse() : t;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject true_to_s(IRubyObject t) {
            return t.getRuntime().newString("true");
        }
    }

    public static class False {
        @JRubyMethod(name={"&"})
        public static IRubyObject false_and(IRubyObject f, IRubyObject oth) {
            return f;
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject false_or(IRubyObject f, IRubyObject oth) {
            return oth.isTrue() ? f.getRuntime().getTrue() : f;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject false_xor(IRubyObject f, IRubyObject oth) {
            return oth.isTrue() ? f.getRuntime().getTrue() : f;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject false_to_s(IRubyObject f) {
            return f.getRuntime().newString("false");
        }
    }
}

