/*
 * Decompiled with CFR 0.152.
 */
package org.joni.util;

import org.joni.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytesHash<V>
extends Hash<V> {
    public BytesHash() {
    }

    public BytesHash(int size2) {
        super(size2);
    }

    public static int hashCode(byte[] bytes, int p2, int end2) {
        int key = 0;
        while (p2 < end2) {
            key = (key << 16) + (key << 6) - key + bytes[p2++];
        }
        key += key >> 5;
        return key;
    }

    public V put(byte[] bytes, V value2) {
        return this.put(bytes, 0, bytes.length, value2);
    }

    public V put(byte[] bytes, int p2, int end2, V value2) {
        this.checkResize();
        int hash2 = BytesHash.hashValue(BytesHash.hashCode(bytes, p2, end2));
        int i = BytesHash.bucketIndex(hash2, this.table.length);
        OniBytesHashEntry entry = (OniBytesHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(bytes, p2, end2)) {
                entry.value = value2;
                return value2;
            }
            entry = (OniBytesHashEntry)entry.next;
        }
        this.table[i] = new OniBytesHashEntry<V>(hash2, this.table[i], value2, bytes, p2, end2);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] bytes, V value2) {
        this.putDirect(bytes, 0, bytes.length, value2);
    }

    public void putDirect(byte[] bytes, int p2, int end2, V value2) {
        this.checkResize();
        int hash2 = BytesHash.hashValue(BytesHash.hashCode(bytes, p2, end2));
        int i = BytesHash.bucketIndex(hash2, this.table.length);
        this.table[i] = new OniBytesHashEntry<V>(hash2, this.table[i], value2, bytes, p2, end2);
        ++this.size;
    }

    public V get(byte[] bytes) {
        return this.get(bytes, 0, bytes.length);
    }

    public V get(byte[] bytes, int p2, int end2) {
        int hash2 = BytesHash.hashValue(BytesHash.hashCode(bytes, p2, end2));
        OniBytesHashEntry entry = (OniBytesHashEntry)this.table[BytesHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(bytes, p2, end2)) {
                return (V)entry.value;
            }
            entry = (OniBytesHashEntry)entry.next;
        }
        return null;
    }

    public V delete(byte[] bytes) {
        return this.delete(bytes, 0, bytes.length);
    }

    public V delete(byte[] bytes, int p2, int end2) {
        int hash2 = BytesHash.hashValue(BytesHash.hashCode(bytes, p2, end2));
        int i = BytesHash.bucketIndex(hash2, this.table.length);
        OniBytesHashEntry entry = (OniBytesHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash2 && entry.equals(bytes, p2, end2)) {
            this.table[i] = entry.next;
            --this.size;
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.OniHashEntry tmp = entry.next;
            if (tmp.hash == hash2 && entry.equals(bytes, p2, end2)) {
                entry.next = entry.next.next;
                --this.size;
                return tmp.value;
            }
            entry = (OniBytesHashEntry)entry.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OniBytesHashEntry<V>
    extends Hash.OniHashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public OniBytesHashEntry(int hash2, Hash.OniHashEntry<V> next2, V value2, byte[] bytes, int p2, int end2) {
            super(hash2, next2, value2);
            this.bytes = bytes;
            this.p = p2;
            this.end = end2;
        }

        public boolean equals(byte[] bytes, int p2, int end2) {
            if (this.end - this.p != end2 - p2) {
                return false;
            }
            if (this.bytes == bytes) {
                return true;
            }
            int q = this.p;
            while (q < this.end) {
                if (this.bytes[q++] == bytes[p2++]) continue;
                return false;
            }
            return true;
        }
    }
}

