/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.customizer.CustomizerSupport;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBProperties {
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String PROP_PROXY_ENABLED = "proxy_enabled";
    private static final String PROP_JAVA_PLATFORM = "java_platform";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private static final String DEF_VALUE_JAVA_OPTS = "";
    private static final boolean DEF_VALUE_PROXY_ENABLED = true;
    private final InstanceProperties ip;
    private final JBDeploymentManager manager;
    private String username = "admin";
    private String password = "admin";
    private long updateCredentialsTimestamp;
    private static final Logger LOGGER = Logger.getLogger(JBProperties.class.getName());
    private final JBPluginUtils.Version version;

    public JBProperties(JBDeploymentManager jBDeploymentManager) {
        this.manager = jBDeploymentManager;
        this.ip = jBDeploymentManager.getInstanceProperties();
        this.version = JBPluginUtils.getServerVersion(new File(this.ip.getProperty("root-dir")));
    }

    public boolean supportsJavaEE5ejb3() {
        return new File(this.getServerDir(), "deploy/ejb3.deployer").exists() || new File(this.getServerDir(), "deployers/ejb3.deployer").exists();
    }

    public boolean supportsJavaEE5web() {
        return new File(this.getServerDir(), "deploy/jboss-web.deployer").exists() || new File(this.getServerDir(), "deployers/jbossweb.deployer").exists();
    }

    public boolean supportsJavaEE5ear() {
        return this.supportsJavaEE5ejb3() && this.supportsJavaEE5web() && this.version != null && this.version.compareToIgnoreUpdate(JBPluginUtils.JBOSS_5_0_0) >= 0;
    }

    public File getServerDir() {
        return new File(this.ip.getProperty("server-dir"));
    }

    public File getRootDir() {
        return new File(this.ip.getProperty("root-dir"));
    }

    public File getLibsDir() {
        return new File(this.getServerDir(), "lib");
    }

    public boolean getProxyEnabled() {
        String string = this.ip.getProperty(PROP_PROXY_ENABLED);
        return string != null ? Boolean.valueOf(string) : true;
    }

    public void setProxyEnabled(boolean bl) {
        this.ip.setProperty(PROP_PROXY_ENABLED, Boolean.toString(bl));
    }

    public JavaPlatform getJavaPlatform() {
        String string = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string2 = (String)javaPlatformArray[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatformArray[i];
        }
        return javaPlatformManager.getDefaultPlatform();
    }

    public void setJavaPlatform(JavaPlatform javaPlatform) {
        this.ip.setProperty(PROP_JAVA_PLATFORM, (String)javaPlatform.getProperties().get(PLAT_PROP_ANT_NAME));
    }

    public String getJavaOpts() {
        String string = this.ip.getProperty("java_opts");
        return string != null ? string : DEF_VALUE_JAVA_OPTS;
    }

    public void setJavaOpts(String string) {
        this.ip.setProperty("java_opts", string);
    }

    public List<URL> getClasses() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            File file;
            File file2;
            File file3;
            File file4;
            File file5 = this.getRootDir();
            File file6 = this.getServerDir();
            File file7 = new File(file5, "client/jboss-j2ee.jar");
            if (!file7.exists()) {
                file7 = new File(file5, "client/jboss-javaee.jar");
            }
            if (file7.exists()) {
                arrayList.add(JBProperties.fileToUrl(file7));
            }
            if ((file4 = new File(file5, "client/jboss-jaxws.jar")).exists()) {
                arrayList.add(JBProperties.fileToUrl(file4));
            }
            if ((file3 = new File(file5, "client/jbossws-client.jar")).exists()) {
                arrayList.add(JBProperties.fileToUrl(file3));
            }
            this.addFiles(new File(file5, "lib"), arrayList);
            this.addFiles(new File(file6, "/lib"), arrayList);
            if (this.supportsJavaEE5ejb3()) {
                file2 = new File(file6, "/deploy/ejb3.deployer/");
                if (file2.exists()) {
                    this.addFiles(file2, arrayList);
                } else {
                    file2 = new File(file6, "/deployers/ejb3.deployer/");
                    if (file2.exists()) {
                        this.addFiles(file2, arrayList);
                    }
                }
            }
            if ((file2 = new File(file6, "/deploy/jboss-web.deployer/jsf-libs/jsf-api.jar")).exists()) {
                try {
                    arrayList.add(JBProperties.fileToUrl(file2));
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.INFO, null, malformedURLException);
                }
            } else {
                file2 = new File(file6, "/deploy/jbossweb-tomcat55.sar/jsf-libs/myfaces-api.jar");
                if (file2.exists()) {
                    try {
                        arrayList.add(JBProperties.fileToUrl(file2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.log(Level.INFO, null, malformedURLException);
                    }
                } else {
                    file2 = new File(file6, "/deployers/jbossweb.deployer/jsf-libs/jsf-api.jar");
                    if (file2.exists()) {
                        try {
                            arrayList.add(JBProperties.fileToUrl(file2));
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOGGER.log(Level.INFO, null, malformedURLException);
                        }
                    }
                }
            }
            if ((file = new File(file6, "/deploy/jboss-web.deployer/jsf-libs/jsf-impl.jar")).exists()) {
                try {
                    arrayList.add(JBProperties.fileToUrl(file));
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.INFO, null, malformedURLException);
                }
            } else {
                file = new File(file6, "/deploy/jbossweb-tomcat55.sar/jsf-libs/myfaces-impl.jar");
                if (file.exists()) {
                    try {
                        arrayList.add(JBProperties.fileToUrl(file));
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.log(Level.INFO, null, malformedURLException);
                    }
                } else {
                    file = new File(file6, "/deployers/jbossweb.deployer/jsf-libs/jsf-impl.jar");
                    if (file.exists()) {
                        try {
                            arrayList.add(JBProperties.fileToUrl(file));
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOGGER.log(Level.INFO, null, malformedURLException);
                        }
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.INFO, null, malformedURLException);
        }
        return arrayList;
    }

    private void addFiles(File file, List list) {
        File[] fileArray = file.listFiles(new FF());
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.addFiles(fileArray[i], list);
                continue;
            }
            try {
                list.add(JBProperties.fileToUrl(fileArray[i]));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger("global").log(Level.INFO, null, malformedURLException);
            }
        }
    }

    public List<URL> getSources() {
        String string = this.ip.getProperty(PROP_SOURCES);
        if (string == null) {
            return new ArrayList<URL>();
        }
        return CustomizerSupport.tokenizePath(string);
    }

    public void setSources(List<URL> list) {
        this.ip.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(list));
        this.manager.getJBPlatform().notifyLibrariesChanged();
    }

    public List<URL> getJavadocs() {
        String string = this.ip.getProperty(PROP_JAVADOCS);
        if (string == null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            try {
                File file = InstalledFileLocator.getDefault().locate("docs/javaee5-doc-api.zip", null, false);
                if (file != null) {
                    arrayList.add(JBProperties.fileToUrl(file));
                }
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger("global").log(Level.INFO, null, malformedURLException);
            }
            return arrayList;
        }
        return CustomizerSupport.tokenizePath(string);
    }

    public void setJavadocs(List<URL> list) {
        this.ip.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(list));
        this.manager.getJBPlatform().notifyLibrariesChanged();
    }

    public synchronized String getUsername() {
        this.updateCredentials();
        return this.username;
    }

    public synchronized String getPassword() {
        this.updateCredentials();
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCredentials() {
        Object object;
        File file = new File(this.getServerDir(), "/conf/props/jmx-console-users.properties");
        long l = file.lastModified();
        if (l == this.updateCredentialsTimestamp) {
            LOGGER.log(Level.FINER, "Credentials are up-to-date.");
            return;
        }
        Properties properties = new Properties();
        try {
            object = new BufferedInputStream(new FileInputStream(file));
            try {
                properties.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.WARNING, file + " not found.", fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Error while reading " + file, iOException);
            return;
        }
        object = NbCollections.checkedEnumerationByFilter(properties.propertyNames(), String.class, (boolean)false);
        if (object.hasMoreElements()) {
            this.username = (String)object.nextElement();
            this.password = properties.getProperty(this.username);
        }
        this.updateCredentialsTimestamp = l;
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    private static class FF
    implements FilenameFilter {
        private FF() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".jar") || new File(file, string).isDirectory();
        }
    }
}

