/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.ExecutionService;
import org.netbeans.modules.ruby.platform.execution.Sudo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.GemProgressPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GemRunner {
    private static final Logger LOGGER = Logger.getLogger(GemRunner.class.getName());
    private final RubyPlatform platform;
    private List<String> output;
    private File pwd;

    GemRunner(RubyPlatform rubyPlatform) {
        this.platform = rubyPlatform;
    }

    private String[] getOptions(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        if (RubyPreferences.shallFetchGemDescriptions()) {
            arrayList.add("--details");
        }
        if (!this.platform.getGemManager().hasAncientRubyGemsVersion() && RubyPreferences.shallFetchAllVersions()) {
            arrayList.add("--all");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    boolean fetchBoth() {
        return this.runGemTool("list", false, this.getOptions("--both"));
    }

    boolean fetchRemote() {
        return this.runGemTool("list", false, this.getOptions("--remote"));
    }

    boolean fetchLocal() {
        return this.runGemTool("list", false, this.getOptions("--local"));
    }

    boolean install(List<String> list, boolean bl, boolean bl2, boolean bl3, String string) {
        return this.installRemote(list, bl, bl2, bl3, string, null, null);
    }

    boolean installLocal(File file, boolean bl, boolean bl2) {
        return this.installLocal(file, bl, bl2, null, null);
    }

    boolean installAsynchronously(List<String> list, boolean bl, boolean bl2, boolean bl3, String string, Runnable runnable, Component component) {
        return this.installRemote(list, bl, bl2, bl3, string, runnable, component);
    }

    boolean installLocalAsynchronously(File file, boolean bl, boolean bl2, Runnable runnable, Component component) {
        return this.installLocal(file, bl, bl2, runnable, component);
    }

    boolean update(List<String> list, boolean bl, boolean bl2, boolean bl3) {
        return this.update(list, bl, bl2, bl3, null, null);
    }

    boolean updateAsynchronously(List<String> list, boolean bl, boolean bl2, boolean bl3, Runnable runnable, Component component) {
        return this.update(list, bl, bl2, bl3, runnable, component);
    }

    boolean uninstall(List<String> list) {
        return this.uninstall(list, null, null);
    }

    boolean uninstallAsynchronously(List<String> list, Runnable runnable, Component component) {
        return this.uninstall(list, runnable, component);
    }

    private boolean install(List<String> list, boolean bl, boolean bl2, boolean bl3, String string, Runnable runnable, Component component) {
        String string22;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string22 : list) {
            arrayList.add(string22);
        }
        if (!bl) {
            arrayList.add("--no-rdoc");
        }
        if (!bl2) {
            arrayList.add("--no-ri");
        }
        if (bl3) {
            this.includeDeps(arrayList);
        } else {
            arrayList.add("--ignore-dependencies");
        }
        if (string != null && string.length() > 0) {
            arrayList.add("--version");
            arrayList.add(string);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        string22 = "install";
        if (runnable != null) {
            String string3 = NbBundle.getMessage(GemRunner.class, (String)"Installation");
            String string4 = NbBundle.getMessage(GemRunner.class, (String)"InstallationOk");
            String string5 = NbBundle.getMessage(GemRunner.class, (String)"InstallationFailed");
            this.asynchGemRunner(component, string3, string4, string5, runnable, string22, stringArray);
            return false;
        }
        return this.runGemTool(string22, stringArray);
    }

    private boolean installRemote(List<String> list, boolean bl, boolean bl2, boolean bl3, String string, Runnable runnable, Component component) {
        return this.install(list, bl, bl2, bl3, string, runnable, component);
    }

    private boolean installLocal(File file, boolean bl, boolean bl2, Runnable runnable, Component component) {
        this.pwd = file.getParentFile();
        return this.install(Collections.singletonList(file.getName()), bl, bl2, false, null, runnable, component);
    }

    private boolean update(List<String> list, boolean bl, boolean bl2, boolean bl3, Runnable runnable, Component component) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (String string2 : list) {
                arrayList.add(string2);
            }
        }
        arrayList.add("--verbose");
        if (!bl) {
            arrayList.add("--no-rdoc");
        }
        if (!bl2) {
            arrayList.add("--no-ri");
        }
        if (bl3) {
            arrayList.add("--include-dependencies");
        }
        this.includeDeps(arrayList);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        string2 = "update";
        if (runnable != null) {
            String string3 = NbBundle.getMessage(GemRunner.class, (String)"Update");
            String string4 = NbBundle.getMessage(GemRunner.class, (String)"UpdateOk");
            String string5 = NbBundle.getMessage(GemRunner.class, (String)"UpdateFailed");
            this.asynchGemRunner(component, string3, string4, string5, runnable, string2, stringArray);
            return false;
        }
        return this.runGemTool(string2, stringArray);
    }

    private boolean uninstall(List<String> list, Runnable runnable, Component component) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = arrayList.size();
        arrayList.add("placeholder");
        arrayList.add("--all");
        arrayList.add("--executables");
        arrayList.add("--ignore-dependencies");
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String string = "uninstall";
        if (runnable != null) {
            String string2 = NbBundle.getMessage(GemRunner.class, (String)"Uninstallation");
            String string3 = NbBundle.getMessage(GemRunner.class, (String)"UninstallationOk");
            String string4 = NbBundle.getMessage(GemRunner.class, (String)"UninstallationFailed");
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string5;
                stringArray[n] = string5 = iterator.next();
                this.asynchGemRunner(component, string2, string3, string4, runnable, string, stringArray);
            }
            return false;
        }
        boolean bl = true;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string6;
            stringArray[n] = string6 = iterator.next();
            bl = this.runGemTool(string, stringArray);
        }
        return bl;
    }

    List<String> getOutput() {
        return this.output;
    }

    private void includeDeps(List<String> list) {
        if (Util.compareVersions(this.platform.getInfo().getGemVersion(), "0.9.5") < 0) {
            list.add("--include-dependencies");
        }
    }

    private boolean runGemTool(String string, boolean bl, String ... stringArray) {
        return this.runGemTool(string, bl, (GemProgressPanel)null, (Process[])null, stringArray);
    }

    private boolean runGemTool(String string, String ... stringArray) {
        return this.runGemTool(string, true, stringArray);
    }

    private boolean runGemTool(String string, boolean bl, GemProgressPanel gemProgressPanel, Process[] processArray, String ... stringArray) {
        int n;
        block19: {
            String[] stringArray2;
            List<String> list = new ArrayList<String>();
            File file = new File(this.platform.getInterpreter());
            if (!file.getName().startsWith("jruby") || RubyExecution.LAUNCH_JRUBY_SCRIPT) {
                list.add(file.getPath());
            }
            list.addAll(RubyExecution.getRubyArgs(this.platform));
            GemManager gemManager = this.platform.getGemManager();
            File file2 = new File(gemManager.getGemTool()).getParentFile().getParentFile();
            list.add("-I" + file2 + File.separator + "lib");
            list.add(gemManager.getGemTool());
            list.add(string);
            for (String object : stringArray) {
                list.add(object);
            }
            if (bl && !gemManager.isGemHomeWritable()) {
                stringArray2 = NbBundle.getMessage(GemRunner.class, (String)"GemRunner.message.for.sudo");
                Sudo sudo = new Sudo(list, (String)stringArray2);
                list = sudo.createCommand();
            }
            stringArray2 = list.toArray(new String[list.size()]);
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
            GemManager.adjustEnvironment(this.platform, processBuilder.environment());
            processBuilder.directory(this.pwd == null ? file.getParentFile() : this.pwd);
            processBuilder.redirectErrorStream(true);
            Util.adjustProxy(processBuilder);
            new RubyExecution(new ExecutionDescriptor(this.platform, "gem", processBuilder.directory()).cmd(file)).setupProcessEnvironment(processBuilder.environment());
            if (this.output == null) {
                this.output = new ArrayList<String>(40);
            }
            n = -1;
            try {
                String string2;
                String string3;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                InputStream inputStream;
                Process iOException;
                block18: {
                    ExecutionService.logProcess(processBuilder);
                    processBuilder.redirectErrorStream(true);
                    iOException = processBuilder.start();
                    if (processArray != null) {
                        processArray[0] = iOException;
                    }
                    inputStream = iOException.getInputStream();
                    if (gemProgressPanel != null) {
                        gemProgressPanel.setProcessInput(iOException.getOutputStream());
                    }
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    try {
                        while ((string3 = bufferedReader.readLine()) != null) {
                            if (gemProgressPanel != null) {
                                gemProgressPanel.appendOutput(string3);
                            }
                            this.output.add(string3);
                        }
                    }
                    catch (IOException iOException2) {
                        string2 = "*** Gem Process Killed ***\n";
                        this.output.add(string2);
                        if (gemProgressPanel == null) break block18;
                        gemProgressPanel.appendOutput(string2);
                    }
                }
                if ((n = iOException.waitFor()) == 0) break block19;
                try {
                    inputStream = iOException.getErrorStream();
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if (gemProgressPanel != null) {
                            gemProgressPanel.appendOutput(string3);
                        }
                        this.output.add(string3);
                    }
                }
                catch (IOException iOException3) {
                    string2 = "*** Gem Process Killed ***\n";
                    this.output.add(string2);
                    if (gemProgressPanel != null) {
                        gemProgressPanel.appendOutput(string2);
                    }
                }
            }
            catch (IOException interruptedException) {
                LOGGER.log(Level.SEVERE, interruptedException.getLocalizedMessage(), interruptedException);
            }
            catch (InterruptedException bl2) {
                LOGGER.log(Level.SEVERE, bl2.getLocalizedMessage(), bl2);
            }
        }
        LOGGER.finer("Process finished with exit code: " + n);
        boolean bl2 = n == 0;
        return bl2;
    }

    private void asynchGemRunner(final Component component, String string, String string2, String string3, Runnable runnable, final String string4, final String ... stringArray) {
        Serializable serializable;
        Cursor cursor;
        if (!EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)"#asynchGemRunner must be called from EDT");
        }
        if (component != null) {
            cursor = component.getCursor();
            serializable = Utilities.createProgressCursor((Component)component);
            component.setCursor((Cursor)serializable);
        } else {
            cursor = null;
        }
        serializable = new JButton(NbBundle.getMessage(GemRunner.class, (String)"CTL_Close"));
        JButton jButton = new JButton(NbBundle.getMessage(GemRunner.class, (String)"CTL_Cancel"));
        ((JButton)serializable).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemRunner.class, (String)"AD_Close"));
        Object[] objectArray = new Object[]{serializable, jButton};
        ((AbstractButton)serializable).setEnabled(false);
        final GemProgressPanel gemProgressPanel = new GemProgressPanel(NbBundle.getMessage(GemRunner.class, (String)"GemPleaseWait"));
        gemProgressPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemRunner.class, (String)"GemProgressPanel.AccessibleContext.accessibleDescription"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)gemProgressPanel, string, true, objectArray, (Object)serializable, 0, new HelpCtx(GemRunner.class), null);
        dialogDescriptor.setModal(true);
        final Process[] processArray = new Process[1];
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
                dialog.dispose();
                GemRunner.resetCursor(component, cursor);
            }
        });
        Runnable runnable2 = new Runnable((JButton)serializable, jButton, string2, string3, runnable, component, cursor){
            final /* synthetic */ JButton val$closeButton;
            final /* synthetic */ JButton val$cancelButton;
            final /* synthetic */ String val$successMessage;
            final /* synthetic */ String val$failureMessage;
            final /* synthetic */ Runnable val$successCompletionTask;
            final /* synthetic */ Component val$parent;
            final /* synthetic */ Cursor val$originalCursor;
            {
                this.val$closeButton = jButton;
                this.val$cancelButton = jButton2;
                this.val$successMessage = string2;
                this.val$failureMessage = string3;
                this.val$successCompletionTask = runnable;
                this.val$parent = component;
                this.val$originalCursor = cursor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    final boolean bl = GemRunner.this.runGemTool(string4, true, gemProgressPanel, processArray, stringArray);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            val$closeButton.setEnabled(true);
                            val$cancelButton.setEnabled(false);
                            gemProgressPanel.done(bl ? val$successMessage : val$failureMessage);
                        }
                    });
                    if (bl && this.val$successCompletionTask != null) {
                        this.val$successCompletionTask.run();
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    GemRunner.resetCursor(this.val$parent, this.val$originalCursor);
                    throw throwable;
                }
                GemRunner.resetCursor(this.val$parent, this.val$originalCursor);
            }
        };
        RequestProcessor.getDefault().post(runnable2, 50);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION || dialogDescriptor.getValue() == jButton) {
            GemRunner.resetCursor(component, cursor);
            jButton.setEnabled(false);
            Process process = processArray[0];
            if (process != null) {
                process.destroy();
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private static void resetCursor(final Component component, final Cursor cursor) {
        if (component != null) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GemRunner.resetCursor(component, cursor);
                    }
                });
                return;
            }
            component.setCursor(cursor);
        }
    }
}

