/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemListModel;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.GemUISupport;
import org.netbeans.modules.ruby.platform.gems.InstallationSettingsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GemPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GemPanel.class.getName());
    private static final String LAST_GEM_DIRECTORY = "lastLocalGemDirectory";
    private static final String LAST_PLATFORM_ID = "gemPanelLastPlatformID";
    private RequestProcessor updateTasksQueue;
    private boolean closed;
    private boolean gemsModified;
    private String filter;
    private FilterFieldListener sfl;
    private static final RequestProcessor FILTER_PROCESSOR = new RequestProcessor("rubygems-filter-processor");
    private final RequestProcessor.Task filterTask;
    private final GemListModel emptyGemListModel = new GemListModel(Collections.<Gem>emptyList(), null);
    private JCheckBox allVersionsCheckbox;
    private JButton browseGemHome;
    private JCheckBox descriptionCheckbox;
    private JLabel gemHome;
    private JTextField gemHomeValue;
    private JTabbedPane gemsTab;
    private JButton installButton;
    private JButton installLocalButton;
    private JTextPane installedDesc;
    private JList installedList;
    private JPanel installedPanel;
    private JProgressBar installedProgress;
    private JLabel installedProgressLabel;
    private JScrollPane installedSP;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JButton manageButton;
    private JTextPane newDesc;
    private JList newList;
    private JPanel newPanel;
    private JProgressBar newProgress;
    private JLabel newProgressLabel;
    private JScrollPane newSP;
    private JLabel oldRubyGemsText;
    private JComboBox platforms;
    private JButton proxyButton;
    private JButton reloadInstalledButton;
    private JButton reloadNewButton;
    private JButton reloadUpdatedButton;
    private JLabel rubyPlatformLabel;
    private JLabel searchInstLbl;
    private JTextField searchInstText;
    private JLabel searchNewLbl;
    private JTextField searchNewText;
    private JLabel searchUpdatedLbl;
    private JTextField searchUpdatedText;
    private JPanel settingsPanel;
    private JButton uninstallButton;
    private JButton updateAllButton;
    private JButton updateButton;
    private JTextPane updatedDesc;
    private JList updatedList;
    private JPanel updatedPanel;
    private JProgressBar updatedProgress;
    private JLabel updatedProgressLabel;
    private JScrollPane updatedSP;

    public GemPanel(String string) {
        this(string, null);
    }

    public GemPanel(String string, RubyPlatform rubyPlatform) {
        this.updateTasksQueue = new RequestProcessor("Gem Updater", 5);
        this.filterTask = FILTER_PROCESSOR.create(new Runnable(){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GemPanel.this.applyFilter();
                    }
                });
            }
        });
        this.initComponents();
        this.oldRubyGemsText.setForeground(UIManager.getColor("nb.errorForeground"));
        if (rubyPlatform == null) {
            Util.preselectPlatform(this.platforms, LAST_PLATFORM_ID);
        } else {
            this.platforms.setSelectedItem(rubyPlatform);
        }
        GemManager gemManager = this.getGemManager();
        if (gemManager != null) {
            this.allVersionsCheckbox.setSelected(!gemManager.hasAncientRubyGemsVersion() && RubyPreferences.shallFetchAllVersions());
        }
        this.descriptionCheckbox.setSelected(RubyPreferences.shallFetchGemDescriptions());
        this.installedList.setCellRenderer(new GemUISupport.GemListRenderer());
        this.installedList.setSelectionMode(2);
        this.installedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.installedList, this.installedDesc, this.uninstallButton));
        this.newList.setCellRenderer(new GemUISupport.GemListRenderer());
        this.newList.setSelectionMode(2);
        this.newList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.newList, this.newDesc, this.installButton));
        this.updatedList.setCellRenderer(new GemUISupport.GemListRenderer());
        this.updatedList.setSelectionMode(2);
        this.updatedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.updatedList, this.updatedDesc, this.updateButton));
        PlatformComponentFactory.addPlatformChangeListener(this.platforms, new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                GemPanel.this.platformChanged();
            }
        });
        this.platformChanged();
        if (string != null) {
            this.setFilter(string);
            this.gemsTab.setSelectedIndex(TabIndex.NEW.getPosition());
            this.applyFilter();
        } else {
            this.gemsTab.setSelectedIndex(TabIndex.INSTALLED.getPosition());
        }
    }

    private void platformChanged() {
        assert (EventQueue.isDispatchThread());
        this.cancelRunningTasks();
        boolean bl = PlatformComponentFactory.isLoadingPlatforms(this.platforms);
        if (bl || this.getSelectedPlatform() == null || !this.getSelectedPlatform().hasRubyGemsInstalled()) {
            if (!bl) {
                this.gemHomeValue.setForeground(PlatformComponentFactory.INVALID_PLAF_COLOR);
                this.gemHomeValue.setText(this.getSelectedPlatform() == null ? GemPanel.getMessage("GemPanel.select.valid.platform", new Object[0]) : GemManager.getNotInstalledMessage());
            }
            this.updateList(TabIndex.INSTALLED, Collections.<Gem>emptyList());
            this.updateList(TabIndex.NEW, Collections.<Gem>emptyList());
            this.updateList(TabIndex.UPDATED, Collections.<Gem>emptyList());
            this.setEnabledGUI(false);
            this.hideProgressBars();
            this.oldRubyGemsText.setVisible(false);
            return;
        }
        GemManager gemManager = this.getGemManager();
        this.oldRubyGemsText.setVisible(gemManager.hasOldRubyGemsVersion());
        if (gemManager.hasOldRubyGemsVersion()) {
            this.oldRubyGemsText.setText(GemPanel.getMessage("GemPanel.oldRubyGems.warning", gemManager.getRubyGemsVersion()));
        }
        assert (gemManager != null) : "gemManager must not be null";
        this.allVersionsCheckbox.setEnabled(!gemManager.hasAncientRubyGemsVersion());
        this.gemHomeValue.setText(this.getGemManager().getGemHome());
        this.gemHomeValue.setForeground(UIManager.getColor("Label.foreground"));
        this.refreshAllGems();
    }

    public void setFilter(String string) {
        assert (EventQueue.isDispatchThread());
        this.filter = string;
    }

    public String getFilter() {
        assert (EventQueue.isDispatchThread());
        return this.filter;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.sfl = new FilterFieldListener();
        this.addFilterDocumentListeners();
    }

    private void addFilterDocumentListeners() {
        this.searchInstText.getDocument().addDocumentListener(this.sfl);
        this.searchNewText.getDocument().addDocumentListener(this.sfl);
        this.searchUpdatedText.getDocument().addDocumentListener(this.sfl);
    }

    private void removeFilterDocumentListeners() {
        this.searchInstText.getDocument().removeDocumentListener(this.sfl);
        this.searchNewText.getDocument().removeDocumentListener(this.sfl);
        this.searchUpdatedText.getDocument().removeDocumentListener(this.sfl);
    }

    @Override
    public void removeNotify() {
        this.closed = true;
        this.removeFilterDocumentListeners();
        this.cancelRunningTasks();
        if (this.getSelectedPlatform() != null) {
            RubyPreferences.getPreferences().put(LAST_PLATFORM_ID, this.getSelectedPlatform().getID());
        }
        super.removeNotify();
    }

    private void cancelRunningTasks() {
        LOGGER.finer("Cancelling all running GemPanel tasks");
    }

    private static void updateGemDescription(JList jList, JTextPane jTextPane, JButton jButton) {
        Object e = jList.getSelectedValue();
        if (e instanceof Gem) {
            jButton.setEnabled(true);
            if (jTextPane != null) {
                GemPanel.updateGemDescription(jTextPane, (Gem)e);
            }
            return;
        }
        if (jTextPane != null) {
            jTextPane.setText("");
        }
        jButton.setEnabled(false);
    }

    private static void updateGemDescription(JTextPane jTextPane, Gem gem) {
        assert (EventQueue.isDispatchThread());
        if (gem == null) {
            jTextPane.setText("");
            return;
        }
        String string = "text/html";
        jTextPane.setContentType(string);
        jTextPane.setText(GemUISupport.getGemHTMLDescriptionForTextPane(gem));
        jTextPane.setCaretPosition(0);
    }

    private void setEnabledGUI(boolean bl) {
        this.setEnabledLocalsGUI(bl);
        this.setEnabledRemoteGUI(bl);
    }

    private void setEnabledLocalsGUI(boolean bl) {
        this.setEnabled(TabIndex.INSTALLED, bl);
    }

    private void setEnabledRemoteGUI(boolean bl) {
        this.setEnabled(TabIndex.NEW, bl);
        this.setEnabled(TabIndex.UPDATED, bl);
    }

    private void enableLocalReloadGUI() {
        this.reloadInstalledButton.setEnabled(true);
    }

    private void enableRemoteReloadGUI() {
        this.reloadNewButton.setEnabled(true);
        this.reloadUpdatedButton.setEnabled(true);
    }

    private void setEnabled(TabIndex tabIndex, boolean bl) {
        switch (tabIndex) {
            case NEW: {
                this.reloadNewButton.setEnabled(bl);
                if (!bl) {
                    this.installButton.setEnabled(bl);
                }
                this.installLocalButton.setEnabled(bl);
                this.newPanel.setEnabled(bl);
                this.newList.setEnabled(bl);
                this.newSP.setEnabled(bl);
                this.searchNewLbl.setEnabled(bl);
                this.searchNewText.setEnabled(bl);
                break;
            }
            case UPDATED: {
                if (!bl) {
                    this.updateButton.setEnabled(bl);
                }
                this.updateAllButton.setEnabled(bl);
                this.reloadUpdatedButton.setEnabled(bl);
                this.updatedPanel.setEnabled(bl);
                this.updatedList.setEnabled(bl);
                this.updatedSP.setEnabled(bl);
                this.searchUpdatedLbl.setEnabled(bl);
                this.searchUpdatedText.setEnabled(bl);
                break;
            }
            case INSTALLED: {
                this.reloadInstalledButton.setEnabled(bl);
                if (!bl) {
                    this.uninstallButton.setEnabled(bl);
                }
                this.installedPanel.setEnabled(bl);
                this.installedList.setEnabled(bl);
                this.installedSP.setEnabled(bl);
                this.searchInstLbl.setEnabled(bl);
                this.searchInstText.setEnabled(bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknonw tab: " + (Object)((Object)tabIndex));
            }
        }
        boolean bl2 = this.newPanel.isEnabled() && this.updatedPanel.isEnabled() && this.installedPanel.isEnabled();
        this.browseGemHome.setEnabled(bl2);
    }

    private synchronized void notifyLocalGemsUpdated() {
        assert (EventQueue.isDispatchThread());
        GemManager gemManager = this.getGemManager();
        assert (gemManager != null) : "gemManager must not be null";
        assert (!gemManager.needsLocalReload()) : "local gems are ready";
        LOGGER.finer("Updating local gems UI for: " + gemManager);
        this.hideLocalProgressBars();
        List<Gem> list = gemManager.getLocalGems();
        this.updateList(TabIndex.INSTALLED, list);
        this.refreshGemsToUpdate();
    }

    private synchronized void notifyRemoteGemsUpdated() {
        assert (EventQueue.isDispatchThread());
        GemManager gemManager = this.getGemManager();
        assert (gemManager != null) : "gemManager must not be null";
        assert (!gemManager.needsRemoteReload()) : "remote gems are ready";
        LOGGER.finer("Updating local gems UI for: " + gemManager);
        this.hideRemoteProgressBars();
        List<Gem> list = gemManager.getRemoteGems();
        this.updateList(TabIndex.NEW, list);
        this.refreshGemsToUpdate();
    }

    private void refreshGemsToUpdate() {
        assert (EventQueue.isDispatchThread());
        List<Gem> list = this.getGemManager().getLocalGems();
        if (list.isEmpty()) {
            return;
        }
        List<Gem> list2 = this.getGemManager().getRemoteGems();
        if (list2.isEmpty()) {
            return;
        }
        HashMap<String, Gem> hashMap = new HashMap<String, Gem>();
        for (Gem object2 : list) {
            hashMap.put(object2.getName(), object2);
        }
        Set set = hashMap.keySet();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        for (Gem gem : list2) {
            Gem gem2;
            String string;
            String string2;
            if (!set.contains(gem.getName()) || Util.compareVersions(string2 = gem.getLatestAvailable(), string = (gem2 = (Gem)hashMap.get(gem.getName())).getLatestInstalled()) <= 0) continue;
            Gem gem3 = new Gem(gem.getName(), gem2.getInstalledVersionsAsString(), string2);
            gem3.setDescription(gem2.getDescription());
            arrayList.add(gem3);
        }
        this.updateList(TabIndex.UPDATED, arrayList);
    }

    private void hideProgressBars() {
        this.hideLocalProgressBars();
        this.hideRemoteProgressBars();
    }

    private void hideRemoteProgressBars() {
        this.updatedProgress.setVisible(false);
        this.updatedProgressLabel.setVisible(false);
        this.newProgress.setVisible(false);
        this.newProgressLabel.setVisible(false);
    }

    private void hideLocalProgressBars() {
        this.installedProgress.setVisible(false);
        this.installedProgressLabel.setVisible(false);
    }

    private void updateList(TabIndex tabIndex, List<Gem> list) {
        JList jList;
        assert (EventQueue.isDispatchThread());
        switch (tabIndex) {
            case NEW: {
                jList = this.newList;
                break;
            }
            case UPDATED: {
                jList = this.updatedList;
                break;
            }
            case INSTALLED: {
                jList = this.installedList;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknonw tab: " + (Object)((Object)tabIndex));
            }
        }
        if (list == null) {
            return;
        }
        GemListModel gemListModel = new GemListModel(list, this.getFilter());
        jList.clearSelection();
        jList.setModel(gemListModel);
        jList.invalidate();
        jList.repaint();
        this.setTabTitle(tabIndex, gemListModel);
        this.setEnabled(tabIndex, true);
    }

    private void setTabTitle(TabIndex tabIndex, GemListModel gemListModel) {
        int n = gemListModel.getAllSize();
        int n2 = gemListModel.getSize();
        String string = n2 < n ? n2 + "/" + n : Integer.toString(n);
        String string2 = tabIndex.getTitle() + '(' + string + ')';
        this.gemsTab.setTitleAt(tabIndex.getPosition(), string2);
    }

    public boolean isModified() {
        return this.gemsModified;
    }

    private static void showProgressBar(JList jList, JTextPane jTextPane, JProgressBar jProgressBar, JLabel jLabel) {
        assert (EventQueue.isDispatchThread());
        if (jList.getSelectedIndex() != -1) {
            GemPanel.updateGemDescription(jTextPane, null);
        }
        jProgressBar.setVisible(true);
        jLabel.setVisible(true);
    }

    private void initComponents() {
        this.gemsTab = new JTabbedPane();
        this.updatedPanel = new JPanel();
        this.searchUpdatedText = new JTextField();
        this.searchUpdatedLbl = new JLabel();
        this.reloadUpdatedButton = new JButton();
        this.updatedSP = new JScrollPane();
        this.updatedList = new JList();
        this.updateButton = new JButton();
        this.updateAllButton = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.updatedDesc = new JTextPane();
        this.updatedProgress = new JProgressBar();
        this.updatedProgressLabel = new JLabel();
        this.installedPanel = new JPanel();
        this.searchInstText = new JTextField();
        this.searchInstLbl = new JLabel();
        this.reloadInstalledButton = new JButton();
        this.uninstallButton = new JButton();
        this.installedSP = new JScrollPane();
        this.installedList = new JList();
        this.jScrollPane5 = new JScrollPane();
        this.installedDesc = new JTextPane();
        this.installedProgress = new JProgressBar();
        this.installedProgressLabel = new JLabel();
        this.newPanel = new JPanel();
        this.searchNewText = new JTextField();
        this.searchNewLbl = new JLabel();
        this.reloadNewButton = new JButton();
        this.installButton = new JButton();
        this.newSP = new JScrollPane();
        this.newList = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.newDesc = new JTextPane();
        this.newProgress = new JProgressBar();
        this.newProgressLabel = new JLabel();
        this.installLocalButton = new JButton();
        this.settingsPanel = new JPanel();
        this.proxyButton = new JButton();
        this.allVersionsCheckbox = new JCheckBox();
        this.descriptionCheckbox = new JCheckBox();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.gemHome = new JLabel();
        this.gemHomeValue = new JTextField();
        this.browseGemHome = new JButton();
        this.oldRubyGemsText = new JLabel();
        FormListener formListener = new FormListener();
        this.searchUpdatedText.setColumns(14);
        this.searchUpdatedText.addActionListener(formListener);
        this.searchUpdatedLbl.setLabelFor(this.searchUpdatedText);
        Mnemonics.setLocalizedText((JLabel)this.searchUpdatedLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadUpdatedButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadUpdatedButton.text"));
        this.reloadUpdatedButton.addActionListener(formListener);
        this.updatedSP.setViewportView(this.updatedList);
        this.updatedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedList.AccessibleContext.accessibleName"));
        this.updatedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.updateAllButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateAllButton.text"));
        this.updateAllButton.addActionListener(formListener);
        this.updatedDesc.setEditable(false);
        this.jScrollPane6.setViewportView(this.updatedDesc);
        this.updatedDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedDesc.AccessibleContext.accessibleName"));
        this.updatedDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedDesc.AccessibleContext.accessibleDescription"));
        this.updatedProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.updatedProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgressLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.updatedPanel);
        this.updatedPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.reloadUpdatedButton).addPreferredGap(0, 436, Short.MAX_VALUE).add((Component)this.searchUpdatedLbl).addPreferredGap(0).add((Component)this.searchUpdatedText, -2, 156, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.updateButton).addPreferredGap(0).add((Component)this.updateAllButton).addPreferredGap(0, 362, Short.MAX_VALUE).add((Component)this.updatedProgressLabel).addPreferredGap(0).add((Component)this.updatedProgress, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.updatedSP, -1, 461, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane6, -2, 283, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.searchUpdatedLbl).add((Component)this.searchUpdatedText, -2, -1, -2).add((Component)this.reloadUpdatedButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jScrollPane6, -1, 262, Short.MAX_VALUE).add((Component)this.updatedSP, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.updateButton).add((Component)this.updateAllButton)).add((Component)this.updatedProgress, -2, -1, -2).add((Component)this.updatedProgressLabel)).addContainerGap()));
        this.searchUpdatedText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedText.AccessibleContext.accessibleDescription"));
        this.searchUpdatedLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedLbl.AccessibleContext.accessibleDescription"));
        this.reloadUpdatedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadReposButton.AccessibleContext.accessibleDescription"));
        this.updatedSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane3.AccessibleContext.accessibleDescription"));
        this.updateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateButton.AccessibleContext.accessibleDescription"));
        this.updateAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateAllButton.AccessibleContext.accessibleDescription"));
        this.jScrollPane6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane6.AccessibleContext.accessibleDescription"));
        this.updatedProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgress.AccessibleContext.accessibleDescription"));
        this.updatedProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedPanel.TabConstraints.tabTitle"), this.updatedPanel);
        this.searchInstText.setColumns(14);
        this.searchInstText.addActionListener(formListener);
        this.searchInstLbl.setLabelFor(this.searchInstText);
        Mnemonics.setLocalizedText((JLabel)this.searchInstLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchInstLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadInstalledButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.uninstallButton.text"));
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(formListener);
        this.installedSP.setViewportView(this.installedList);
        this.installedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedList.AccessibleContext.accessibleName"));
        this.installedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedList.AccessibleContext.accessibleDescription"));
        this.installedDesc.setEditable(false);
        this.jScrollPane5.setViewportView(this.installedDesc);
        this.installedDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedDesc.AccessibleContext.accessibleName"));
        this.installedDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedDesc.AccessibleContext.accessibleDescription"));
        this.installedProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.installedProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgressLabel.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.installedPanel);
        this.installedPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.reloadInstalledButton).addPreferredGap(0, 436, Short.MAX_VALUE).add((Component)this.searchInstLbl).addPreferredGap(0).add((Component)this.searchInstText, -2, 156, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.uninstallButton).addPreferredGap(0, 455, Short.MAX_VALUE).add((Component)this.installedProgressLabel).addPreferredGap(0).add((Component)this.installedProgress, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.installedSP, -1, 461, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane5, -2, 283, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.searchInstLbl).add((Component)this.reloadInstalledButton).add((Component)this.searchInstText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.installedSP, -1, 262, Short.MAX_VALUE).add((Component)this.jScrollPane5, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.uninstallButton).add((Component)this.installedProgress, -2, -1, -2).add((Component)this.installedProgressLabel)).addContainerGap()));
        this.searchInstText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchText.AccessibleContext.accessibleDescription"));
        this.searchInstLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchLbl.AccessibleContext.accessibleDescription"));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadInstalledButton.AccessibleContext.accessibleDescription"));
        this.uninstallButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.uninstallButton.AccessibleContext.accessibleDescription"));
        this.installedSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.jScrollPane5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane5.AccessibleContext.accessibleDescription"));
        this.installedProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgress.AccessibleContext.accessibleDescription"));
        this.installedProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedPanel.TabConstraints.tabTitle"), this.installedPanel);
        this.searchNewText.setColumns(14);
        this.searchNewText.addActionListener(formListener);
        this.searchNewLbl.setLabelFor(this.searchNewText);
        Mnemonics.setLocalizedText((JLabel)this.searchNewLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadNewButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadNewButton.text"));
        this.reloadNewButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(formListener);
        this.newSP.setViewportView(this.newList);
        this.newList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newList.AccessibleContext.accessibleName"));
        this.newList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newList.AccessibleContext.accessibleDescription"));
        this.newDesc.setEditable(false);
        this.jScrollPane4.setViewportView(this.newDesc);
        this.newDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newDesc.AccessibleContext.accessibleName"));
        this.newDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newDesc.AccessibleContext.accessibleDescription"));
        this.newProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.newProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgressLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installLocalButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installLocalButton.text"));
        this.installLocalButton.addActionListener(formListener);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.newPanel);
        this.newPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.reloadNewButton).addPreferredGap(0, 436, Short.MAX_VALUE).add((Component)this.searchNewLbl).addPreferredGap(0).add((Component)this.searchNewText, -2, 156, -2)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0).add((Component)this.installLocalButton).addPreferredGap(0, 348, Short.MAX_VALUE).add((Component)this.newProgressLabel).addPreferredGap(0).add((Component)this.newProgress, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.newSP, -1, 461, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane4, -2, 283, -2))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.searchNewLbl).add((Component)this.reloadNewButton).add((Component)this.searchNewText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.newSP, -1, 262, Short.MAX_VALUE).add((Component)this.jScrollPane4, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.installButton).add((Component)this.installLocalButton)).add((Component)this.newProgress, -2, -1, -2).add((Component)this.newProgressLabel)).addContainerGap()));
        this.searchNewText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewText.AccessibleContext.accessibleDescription"));
        this.searchNewLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewLbl.AccessibleContext.accessibleDescription"));
        this.reloadNewButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadNewButton.AccessibleContext.accessibleDescription"));
        this.installButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installButton.AccessibleContext.accessibleDescription"));
        this.newSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane2.AccessibleContext.accessibleDescription"));
        this.jScrollPane4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane4.AccessibleContext.accessibleDescription"));
        this.newProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgress.AccessibleContext.accessibleDescription"));
        this.newProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newPanel.TabConstraints.tabTitle"), this.newPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.allVersionsCheckbox, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.allVersionsCheckbox.text"));
        this.allVersionsCheckbox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.descriptionCheckbox, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.descriptionCheckbox.text"));
        this.descriptionCheckbox.addActionListener(formListener);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.settingsPanel);
        this.settingsPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.descriptionCheckbox).add((Component)this.proxyButton).add((Component)this.allVersionsCheckbox)).addContainerGap(459, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).add(18, 18, 18).add((Component)this.allVersionsCheckbox).addPreferredGap(1).add((Component)this.descriptionCheckbox).addContainerGap(243, Short.MAX_VALUE)));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.settingsPanel.TabConstraints.tabTitle"), this.settingsPanel);
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.rubyPlatformLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.manageButton.text"));
        this.manageButton.addActionListener(formListener);
        this.gemHome.setLabelFor(this.gemHomeValue);
        Mnemonics.setLocalizedText((JLabel)this.gemHome, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHome.text"));
        this.gemHomeValue.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseGemHome, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.browseGemHome.text"));
        this.browseGemHome.addActionListener(formListener);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(2).add(1, (Component)this.gemsTab, -1, 791, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((GroupLayout.Group)groupLayout5.createParallelGroup(1, false).add((Component)this.gemHome, -1, -1, Short.MAX_VALUE).add((Component)this.rubyPlatformLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (Component)this.gemHomeValue, -1, 591, Short.MAX_VALUE).add(2, (Component)this.platforms, 0, 591, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (Component)this.manageButton).add(2, (Component)this.browseGemHome, -2, 80, -2))).add(1, (Component)this.oldRubyGemsText, -1, 791, Short.MAX_VALUE)).addContainerGap()));
        groupLayout5.linkSize(new Component[]{this.browseGemHome, this.manageButton}, 1);
        groupLayout5.linkSize(new Component[]{this.gemHome, this.rubyPlatformLabel}, 1);
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.gemHome).add((Component)this.browseGemHome).add((Component)this.gemHomeValue, -2, -1, -2)).addPreferredGap(1).add((Component)this.gemsTab, -1, 375, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.oldRubyGemsText).addContainerGap()));
        this.gemsTab.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemsTab.AccessibleContext.accessibleName"));
        this.gemsTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemsTab.AccessibleContext.accessibleDescription"));
        this.platforms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.platforms.AccessibleContext.accessibleName"));
        this.platforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.platforms.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.manageButton.AccessibleContext.accessibleDescription"));
        this.gemHomeValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHomeValue.AccessibleContext.accessibleName"));
        this.gemHomeValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHomeValue.AccessibleContext.accessibleDescription"));
        this.browseGemHome.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.browseGemHome.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.AccessibleContext.accessibleDescription"));
    }

    private void reloadNewButtonActionPerformed(ActionEvent actionEvent) {
        this.getGemManager().resetRemote();
        this.refreshRemoteGems();
    }

    private void proxyButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void applyFilter() {
        assert (EventQueue.isDispatchThread());
        this.removeFilterDocumentListeners();
        this.applyFilter(TabIndex.NEW, this.searchNewText, this.newList, this.newDesc, this.installButton);
        this.applyFilter(TabIndex.UPDATED, this.searchUpdatedText, this.updatedList, this.updatedDesc, this.updateButton);
        this.applyFilter(TabIndex.INSTALLED, this.searchInstText, this.installedList, this.installedDesc, this.uninstallButton);
        this.addFilterDocumentListeners();
    }

    private void applyFilter(TabIndex tabIndex, JTextField jTextField, JList jList, JTextPane jTextPane, JButton jButton) {
        int n = jTextField.getCaretPosition();
        String string = this.getFilter();
        jTextField.setText(string);
        jTextField.setCaretPosition(n > string.length() ? string.length() : n);
        GemListModel gemListModel = (GemListModel)jList.getModel();
        gemListModel.applyFilter(this.getFilter());
        this.setTabTitle(tabIndex, gemListModel);
        if (jList.getSelectedValue() == null) {
            jList.setSelectedIndex(0);
        }
        GemPanel.updateGemDescription(jList, jTextPane, jButton);
    }

    private void reloadUpdatedButtonActionPerformed(ActionEvent actionEvent) {
        this.getGemManager().reset();
        this.refreshAllGems();
    }

    private void installButtonActionPerformed(ActionEvent actionEvent) {
        Gem gem;
        Object object;
        assert (EventQueue.isDispatchThread());
        int[] nArray = this.newList.getSelectedIndices();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        for (int n : nArray) {
            object = this.newList.getModel().getElementAt(n);
            if (!(object instanceof Gem)) continue;
            gem = (Gem)object;
            arrayList.add(gem);
        }
        if (!arrayList.isEmpty()) {
            Object object2 = arrayList.iterator();
            while (object2.hasNext()) {
                Gem gem2 = (Gem)object2.next();
                InstallationSettingsPanel installationSettingsPanel = new InstallationSettingsPanel(gem2);
                installationSettingsPanel.getAccessibleContext().setAccessibleDescription(GemPanel.getMessage("InstallationSettingsPanel.AccessibleContext.accessibleDescription", new Object[0]));
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)installationSettingsPanel, GemPanel.getMessage("ChooseGemSettings", new Object[0]));
                dialogDescriptor.setOptionType(2);
                dialogDescriptor.setModal(true);
                dialogDescriptor.setHelpCtx(new HelpCtx(GemPanel.class));
                object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (!object.equals(NotifyDescriptor.OK_OPTION)) continue;
                gem = new Gem(installationSettingsPanel.getGemName(), null, null);
                GemListRefresher gemListRefresher = new GemListRefresher();
                this.getGemManager().install(new Gem[]{gem}, this, false, false, installationSettingsPanel.getVersion(), installationSettingsPanel.getIncludeDepencies(), true, gemListRefresher);
            }
        }
    }

    private void updateAllButtonActionPerformed(ActionEvent actionEvent) {
        GemListRefresher gemListRefresher = new GemListRefresher();
        this.getGemManager().update(null, this, false, false, false, true, gemListRefresher);
    }

    private void updateButtonActionPerformed(ActionEvent actionEvent) {
        assert (EventQueue.isDispatchThread());
        int[] nArray = this.updatedList.getSelectedIndices();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        if (nArray != null) {
            for (int n : nArray) {
                assert (n >= 0);
                Object e = this.updatedList.getModel().getElementAt(n);
                if (!(e instanceof Gem)) continue;
                Gem gem = (Gem)e;
                arrayList.add(gem);
            }
        }
        if (!arrayList.isEmpty()) {
            GemListRefresher gemListRefresher = new GemListRefresher();
            this.getGemManager().update(arrayList.toArray(new Gem[arrayList.size()]), this, false, false, false, true, gemListRefresher);
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent actionEvent) {
        assert (EventQueue.isDispatchThread());
        int[] nArray = this.installedList.getSelectedIndices();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        if (nArray != null) {
            for (int n : nArray) {
                assert (n >= 0);
                Object e = this.installedList.getModel().getElementAt(n);
                if (!(e instanceof Gem)) continue;
                Gem gem = (Gem)e;
                arrayList.add(gem);
            }
        }
        if (!arrayList.isEmpty()) {
            GemListRefresher gemListRefresher = new GemListRefresher();
            this.getGemManager().uninstall(arrayList.toArray(new Gem[arrayList.size()]), this, true, gemListRefresher);
        }
    }

    private void reloadInstalledButtonActionPerformed(ActionEvent actionEvent) {
        this.getGemManager().resetLocal();
        this.refreshLocalGems();
    }

    private void manageButtonActionPerformed(ActionEvent actionEvent) {
        RubyPlatformCustomizer.manage(this.platforms);
    }

    private void browseGemHomeActionPerformed(ActionEvent actionEvent) {
        boolean bl = GemPanel.chooseAndSetGemHome(this, this.getSelectedPlatform());
        if (bl) {
            this.platformChanged();
        }
    }

    private void installLocalButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(RubyPreferences.getPreferences().get(LAST_GEM_DIRECTORY, ""));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase(Locale.US).endsWith(".gem");
            }

            public String getDescription() {
                return GemPanel.getMessage("GemPanel.rubygems.files.filter", new Object[0]);
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            RubyPreferences.getPreferences().put(LAST_GEM_DIRECTORY, file.getParentFile().getAbsolutePath());
            GemListRefresher gemListRefresher = new GemListRefresher();
            this.getGemManager().installLocal(file, this, false, false, true, gemListRefresher);
        }
    }

    private void allVersionsCheckboxActionPerformed(ActionEvent actionEvent) {
        RubyPreferences.setFetchAllVersions(this.allVersionsCheckbox.isSelected());
    }

    private void descriptionCheckboxActionPerformed(ActionEvent actionEvent) {
        RubyPreferences.setFetchGemDescriptions(this.descriptionCheckbox.isSelected());
    }

    private void searchUpdatedTextActionPerformed(ActionEvent actionEvent) {
    }

    private void searchInstTextActionPerformed(ActionEvent actionEvent) {
    }

    private void searchNewTextActionPerformed(ActionEvent actionEvent) {
    }

    public static File chooseGemRepository(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            if (GemManager.isValidGemHome(file)) {
                return file;
            }
            if (!file.exists() || file.isDirectory() && file.list().length == 0) {
                if (Util.confirmLocalized(GemPanel.class, "GemPanel.empty.create.gemrepo", file.getAbsolutePath())) {
                    try {
                        GemManager.initializeRepository(file);
                        return file;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                    }
                }
            } else {
                Util.notifyLocalized(GemPanel.class, "GemPanel.invalid.gemHome", file.getAbsolutePath());
            }
        }
        return null;
    }

    public static boolean chooseAndSetGemHome(Component component, RubyPlatform rubyPlatform) {
        if (rubyPlatform == null) {
            return false;
        }
        assert (rubyPlatform.hasRubyGemsInstalled()) : "has RubyGems installed";
        File file = GemPanel.chooseGemRepository(component);
        if (file != null) {
            rubyPlatform.setGemHome(file);
            return true;
        }
        return false;
    }

    private void showGemErrors(List<String> list) {
        assert (EventQueue.isDispatchThread());
        this.getGemManager().reset();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append('\n');
        }
        Util.notifyLocalized(GemPanel.class, "GemPanel.GemsFetchingFailed", 0, new Object[]{stringBuilder.toString()});
    }

    private void refreshAllGems() {
        assert (EventQueue.isDispatchThread());
        this.refreshLocalGems();
        this.refreshRemoteGems();
    }

    private void refreshLocalGems() {
        assert (EventQueue.isDispatchThread());
        this.setEnabledLocalsGUI(false);
        GemPanel.showProgressBar(this.installedList, this.installedDesc, this.installedProgress, this.installedProgressLabel);
        this.installedList.setModel(this.emptyGemListModel);
        this.gemsTab.setTitleAt(TabIndex.INSTALLED.getPosition(), TabIndex.INSTALLED.getTitle() + "(-)");
        final GemManager gemManager = this.getGemManager();
        Runnable runnable = new Runnable(){

            public void run() {
                LOGGER.finer("Update of local gems for " + gemManager + " scheduled");
                assert (!EventQueue.isDispatchThread());
                final List<String> list = gemManager.reloadLocalIfNeeded();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        boolean bl;
                        LOGGER.finer("Update of local gems for " + gemManager + " finished");
                        if (GemPanel.this.closed) {
                            return;
                        }
                        boolean bl2 = bl = !gemManager.equals(GemPanel.this.getGemManager());
                        if (!list.isEmpty()) {
                            GemPanel.this.showGemErrors(list);
                            if (!bl) {
                                GemPanel.this.hideLocalProgressBars();
                                GemPanel.this.enableLocalReloadGUI();
                            }
                            return;
                        }
                        if (!bl) {
                            GemPanel.this.notifyLocalGemsUpdated();
                        } else {
                            LOGGER.finer("Gem Manager has changed from " + gemManager + " to " + GemPanel.this.getGemManager() + ". Ignoring local gems update.");
                        }
                    }
                });
            }
        };
        LOGGER.finer("Submitting refreshing of gems for: " + gemManager);
        this.updateTasksQueue.post(runnable);
    }

    private void refreshRemoteGems() {
        assert (EventQueue.isDispatchThread());
        this.setEnabledRemoteGUI(false);
        GemPanel.showProgressBar(this.newList, this.newDesc, this.newProgress, this.newProgressLabel);
        GemPanel.showProgressBar(this.updatedList, this.updatedDesc, this.updatedProgress, this.updatedProgressLabel);
        this.newList.setModel(this.emptyGemListModel);
        this.updatedList.setModel(this.emptyGemListModel);
        this.gemsTab.setTitleAt(TabIndex.NEW.getPosition(), TabIndex.NEW.getTitle() + "(-)");
        this.gemsTab.setTitleAt(TabIndex.UPDATED.getPosition(), TabIndex.UPDATED.getTitle() + "(-)");
        final GemManager gemManager = this.getGemManager();
        Runnable runnable = new Runnable(){

            public void run() {
                LOGGER.finer("Update of remote gems for " + gemManager + " scheduled");
                assert (!EventQueue.isDispatchThread());
                final List<String> list = gemManager.reloadRemoteIfNeeded();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        boolean bl;
                        LOGGER.finer("Update of remote gems for " + gemManager + " finished");
                        if (GemPanel.this.closed) {
                            return;
                        }
                        boolean bl2 = bl = !gemManager.equals(GemPanel.this.getGemManager());
                        if (!list.isEmpty()) {
                            GemPanel.this.showGemErrors(list);
                            if (!bl) {
                                GemPanel.this.hideRemoteProgressBars();
                                GemPanel.this.enableRemoteReloadGUI();
                            }
                            return;
                        }
                        if (!bl) {
                            GemPanel.this.notifyRemoteGemsUpdated();
                        } else {
                            LOGGER.finer("Gem Manager has changed from " + gemManager + " to " + GemPanel.this.getGemManager() + ". Ignoring remote gems update.");
                        }
                    }
                });
            }
        };
        LOGGER.finer("Submitting refreshing of gems for: " + gemManager);
        this.updateTasksQueue.post(runnable);
    }

    private RubyPlatform getSelectedPlatform() {
        if (!EventQueue.isDispatchThread()) {
            Exceptions.printStackTrace((Throwable)((Object)new AssertionError((Object)"getSelectedPlatform() must be called from EDT")));
        }
        return PlatformComponentFactory.getPlatform(this.platforms);
    }

    private GemManager getGemManager() {
        RubyPlatform rubyPlatform;
        if (!EventQueue.isDispatchThread()) {
            Exceptions.printStackTrace((Throwable)((Object)new AssertionError((Object)"getGemManager() must be called from EDT")));
        }
        return (rubyPlatform = this.getSelectedPlatform()) == null ? null : rubyPlatform.getGemManager();
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(GemPanel.class, (String)string, (Object[])objectArray);
    }

    private final class FilterFieldListener
    implements DocumentListener {
        private FilterFieldListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                String string = documentEvent.getDocument().getText(0, document.getLength());
                GemPanel.this.setFilter(string);
                GemPanel.this.filterTask.schedule(350);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private class GemListRefresher
    implements Runnable {
        private GemListRefresher() {
        }

        public void run() {
            GemPanel.this.gemsModified = true;
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
            } else {
                GemPanel.this.refreshAllGems();
            }
        }
    }

    private static class MyListSelectionListener
    implements ListSelectionListener {
        private final JButton button;
        private final JTextPane pane;
        private final JList list;

        private MyListSelectionListener(JList jList, JTextPane jTextPane, JButton jButton) {
            this.list = jList;
            this.pane = jTextPane;
            this.button = jButton;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            GemPanel.updateGemDescription(this.list, this.pane, this.button);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GemPanel.this.reloadUpdatedButton) {
                GemPanel.this.reloadUpdatedButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.updateButton) {
                GemPanel.this.updateButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.updateAllButton) {
                GemPanel.this.updateAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.reloadInstalledButton) {
                GemPanel.this.reloadInstalledButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.uninstallButton) {
                GemPanel.this.uninstallButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.reloadNewButton) {
                GemPanel.this.reloadNewButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.installButton) {
                GemPanel.this.installButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.installLocalButton) {
                GemPanel.this.installLocalButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.proxyButton) {
                GemPanel.this.proxyButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.allVersionsCheckbox) {
                GemPanel.this.allVersionsCheckboxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.descriptionCheckbox) {
                GemPanel.this.descriptionCheckboxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.manageButton) {
                GemPanel.this.manageButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.browseGemHome) {
                GemPanel.this.browseGemHomeActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.searchUpdatedText) {
                GemPanel.this.searchUpdatedTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.searchInstText) {
                GemPanel.this.searchInstTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.searchNewText) {
                GemPanel.this.searchNewTextActionPerformed(actionEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TabIndex {
        UPDATED(0, "GemPanel.updatedPanel.TabConstraints.tabTitle"),
        INSTALLED(1, "GemPanel.installedPanel.TabConstraints.tabTitle"),
        NEW(2, "GemPanel.newPanel.TabConstraints.tabTitle");

        private final int position;
        private final String title;

        private TabIndex(int n2, String string2) {
            this.position = n2;
            this.title = GemPanel.getMessage(string2, new Object[0]);
        }

        private int getPosition() {
            return this.position;
        }

        private String getTitle() {
            return this.title;
        }
    }
}

