/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.RegexpOutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.StopAction;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutputForwarder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(OutputForwarder.class.getName());
    static final Pattern RANGE_ERROR_RE = Pattern.compile("#<RangeError: 0x[0-9a-f]+ is recycled object>");
    private StopAction stopAction;
    private InputStream str;
    private OutputWriter writer;
    private FileLocator fileLocator;
    private List<OutputRecognizer> recognizers;
    private String encoding;
    private final int readMaxWaitTime;
    private final boolean runBeforeFinishHook;

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction) {
        this(inputStream, outputWriter, fileLocator, list, stopAction, null, 50);
    }

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction, String string, int n) {
        this(inputStream, outputWriter, fileLocator, list, stopAction, null, n, false);
    }

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction, String string, int n, boolean bl) {
        this.str = inputStream;
        this.writer = outputWriter;
        this.fileLocator = fileLocator;
        this.recognizers = list;
        this.stopAction = stopAction;
        this.encoding = string;
        this.readMaxWaitTime = n;
        this.runBeforeFinishHook = bl;
    }

    void processLine(String string) throws IOException {
        if (RANGE_ERROR_RE.matcher(string).matches()) {
            LOGGER.log(Level.FINE, "Filtering line from Output Window (issue #110763): " + string);
            return;
        }
        if (Util.containsAnsiColors(string)) {
            string = Util.stripAnsiColors(string);
        }
        OutputRecognizer.FileLocation fileLocation = null;
        boolean bl = false;
        for (OutputRecognizer outputRecognizer : this.recognizers) {
            String[] stringArray;
            OutputRecognizer.RecognizedOutput recognizedOutput = outputRecognizer.processLine(string);
            if (recognizedOutput instanceof OutputRecognizer.FileLocation) {
                fileLocation = (OutputRecognizer.FileLocation)recognizedOutput;
                continue;
            }
            if (recognizedOutput instanceof OutputRecognizer.ActionText) {
                Object object;
                int n;
                int n2;
                Object[] objectArray;
                stringArray = (String[])recognizedOutput;
                String[] stringArray2 = stringArray.getPlainLinesPre();
                if (stringArray2 != null) {
                    objectArray = stringArray2;
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        object = objectArray[n];
                        this.writer.println((String)object);
                    }
                }
                if ((stringArray2 = stringArray.getActionLines()) != null) {
                    objectArray = stringArray.getActions();
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        String string2 = stringArray2[n2];
                        this.writer.println(string2, (OutputListener)new ActionHandler((Runnable)objectArray[n2]));
                    }
                }
                if ((stringArray2 = stringArray.getPlainLinesPost()) != null) {
                    objectArray = stringArray2;
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        object = objectArray[n];
                        this.writer.println((String)object);
                    }
                }
                bl = true;
                continue;
            }
            if (!(recognizedOutput instanceof OutputRecognizer.FilteredOutput)) continue;
            stringArray = ((OutputRecognizer.FilteredOutput)recognizedOutput).getLinesToPrint();
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    boolean bl2 = false;
                    for (RegexpOutputRecognizer regexpOutputRecognizer : RubyExecution.getStandardRubyRecognizers()) {
                        OutputRecognizer.RecognizedOutput recognizedOutput2 = ((OutputRecognizer)regexpOutputRecognizer).processLine(string3);
                        if (!(recognizedOutput2 instanceof OutputRecognizer.FileLocation)) continue;
                        OutputRecognizer.FileLocation fileLocation2 = (OutputRecognizer.FileLocation)recognizedOutput2;
                        this.writer.println(string3, (OutputListener)new OutputProcessor(fileLocation2.file, fileLocation2.line, this.fileLocator));
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    this.writer.println(string3);
                }
            }
            bl = true;
        }
        if (!bl) {
            if (fileLocation != null) {
                this.writer.println(string, (OutputListener)new OutputProcessor(fileLocation.file, fileLocation.line, this.fileLocator));
            } else {
                this.writer.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        for (OutputRecognizer var2_2 : this.recognizers) {
            var2_2.start();
        }
        var1_1 = null;
        try {
            var2_3 = this.encoding == null ? new InputStreamReader(this.str) : new InputStreamReader(this.str, this.encoding);
            var1_1 = new BufferedReader(var2_3, 1200);
        }
        catch (UnsupportedEncodingException var2_4) {
            Exceptions.printStackTrace((Throwable)var2_4);
            return;
        }
        var2_5 = new StringBuilder();
        try {
            try {
                while (true) {
                    block209: {
                        block210: {
                            if (var1_1.ready()) break block209;
                            if (this.stopAction.process != null) break block210;
                            var7_14 = null;
                            ** GOTO lbl329
                        }
                        for (var4_9 = 0; !var1_1.ready() && var4_9 < this.readMaxWaitTime; var4_9 += 25) {
                            try {
                                Thread.sleep(25L);
                                continue;
                            }
                            catch (InterruptedException var5_13) {
                                block212: {
                                    var7_15 = null;
                                    try {
                                        try {
                                            if (Thread.interrupted()) {
                                                // empty if block
                                            }
                                            if (this.stopAction.process == null) {
                                                var8_23 = false;
                                            } else {
                                                try {
                                                    this.stopAction.process.exitValue();
                                                    var8_23 = false;
                                                }
                                                catch (IllegalThreadStateException var9_36) {
                                                    var8_23 = true;
                                                }
                                            }
                                            if (var8_23) {
                                                if (this.str.available() > 0) {
                                                    var9_36 = var1_1.readLine();
                                                    var2_5.append((String)var9_36);
                                                }
                                                if (var2_5.length() > 0) {
                                                    this.processLine(var2_5.toString());
                                                }
                                            } else {
                                                while ((var9_36 = var1_1.readLine()) != null) {
                                                    var2_5.append((String)var9_36);
                                                    this.processLine(var2_5.toString());
                                                    var2_5.setLength(0);
                                                }
                                            }
                                            var11_45 = null;
                                        }
                                        catch (IOException var8_24) {
                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_24.getMessage(), var8_24);
                                            var11_46 = null;
                                            try {
                                                var1_1.close();
                                            }
                                            catch (IOException var12_67) {
                                                OutputForwarder.LOGGER.log(Level.WARNING, var12_67.getMessage(), (Throwable)var12_67);
                                            }
                                            if (this.runBeforeFinishHook) {
                                                for (OutputRecognizer var13_88 : this.recognizers) {
                                                    for (String var17_172 : var13_88.beforeFinish()) {
                                                        this.writer.println(var17_172);
                                                    }
                                                }
                                            }
                                            this.writer.flush();
                                            this.writer.close();
                                            for (OutputRecognizer var13_88 : this.recognizers) {
                                                var13_88.finish();
                                            }
                                            return;
                                        }
                                    }
                                    catch (Throwable var10_190) {
                                        block211: {
                                            var11_47 = null;
                                            ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl86:
                                            // 1 sources

                                            var1_1.close();
                                            break block211;
lbl88:
                                            // 1 sources

                                            catch (IOException var12_68) {
                                                OutputForwarder.LOGGER.log(Level.WARNING, var12_68.getMessage(), (Throwable)var12_68);
                                            }
                                        }
                                        if (this.runBeforeFinishHook) {
                                            for (OutputRecognizer var13_89 : this.recognizers) {
                                                for (String var17_173 : var13_89.beforeFinish()) {
                                                    this.writer.println(var17_173);
                                                }
                                            }
                                        }
                                        this.writer.flush();
                                        this.writer.close();
                                        var12_68 = this.recognizers.iterator();
                                        while (true) {
                                            if (!var12_68.hasNext()) {
                                                throw var10_190;
                                            }
                                            var13_89 = var12_68.next();
                                            var13_89.finish();
                                        }
                                    }
                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl108:
                                    // 1 sources

                                    var1_1.close();
                                    break block212;
lbl110:
                                    // 1 sources

                                    catch (IOException var12_66) {
                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_66.getMessage(), (Throwable)var12_66);
                                    }
                                }
                                if (this.runBeforeFinishHook) {
                                    for (OutputRecognizer var13_87 : this.recognizers) {
                                        for (String var17_171 : var13_87.beforeFinish()) {
                                            this.writer.println(var17_171);
                                        }
                                    }
                                }
                                this.writer.flush();
                                this.writer.close();
                                for (OutputRecognizer var13_87 : this.recognizers) {
                                    var13_87.finish();
                                }
                                return;
                            }
                        }
                        if (var1_1.ready() || var2_5.length() <= 0) continue;
                        var5_12 = var2_5.toString();
                        var2_5.setLength(0);
                        OutputForwarder.LOGGER.log(Level.INFO, "Process seems to be stalling, emitting chars read so far: " + var5_12);
                        this.writer.print(var5_12);
                        continue;
                    }
                    while (var1_1.ready()) {
                        block213: {
                            var3_6 = -1;
                            var3_6 = var1_1.read();
                            if (var3_6 != -1) break block213;
                            var4_10 = var2_5.toString();
                            var2_5.setLength(0);
                            this.processLine(var4_10);
                            ** GOTO lbl425
                        }
                        var2_5.append((char)var3_6);
                    }
                    if (Thread.interrupted()) break;
                }
                ** GOTO lbl522
            }
            catch (IOException var3_7) {
                block218: {
                    block215: {
                        block214: {
                            OutputForwarder.LOGGER.log(Level.INFO, var3_7.getMessage(), var3_7);
                            var7_18 = null;
                            ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl154:
                            // 1 sources

                            ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl155:
                            // 1 sources

                            if (Thread.interrupted()) {
                                // empty if block
                            }
                            if (this.stopAction.process == null) {
                                var8_29 = false;
                            } else {
                                ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl161:
                                // 1 sources

                                this.stopAction.process.exitValue();
                                var8_29 = false;
                            }
                            break block214;
lbl165:
                            // 1 sources

                            catch (IllegalThreadStateException var9_39) {
                                var8_29 = true;
                            }
                        }
                        if (var8_29) {
                            if (this.str.available() > 0) {
                                var9_39 = var1_1.readLine();
                                var2_5.append((String)var9_39);
                            }
                            if (var2_5.length() > 0) {
                                this.processLine(var2_5.toString());
                            }
                            break block215;
                        } else {
                            while ((var9_39 = var1_1.readLine()) != null) {
                                var2_5.append((String)var9_39);
                                this.processLine(var2_5.toString());
                                var2_5.setLength(0);
                            }
                        }
                        break block215;
lbl183:
                        // 1 sources

                        catch (IOException var8_30) {
                            block216: {
                                OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_30.getMessage(), var8_30);
                                var11_55 = null;
                                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl188:
                                // 1 sources

                                var1_1.close();
                                break block216;
lbl190:
                                // 1 sources

                                catch (IOException var12_76) {
                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_76.getMessage(), (Throwable)var12_76);
                                }
                            }
                            if (this.runBeforeFinishHook) {
                                for (OutputRecognizer var13_97 : this.recognizers) {
                                    for (String var17_181 : var13_97.beforeFinish()) {
                                        this.writer.println(var17_181);
                                    }
                                }
                            }
                            this.writer.flush();
                            this.writer.close();
                            for (OutputRecognizer var13_97 : this.recognizers) {
                                var13_97.finish();
                            }
                            return;
                        }
lbl205:
                        // 1 sources

                        catch (Throwable var10_193) {
                            block217: {
                                var11_56 = null;
                                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl209:
                                // 1 sources

                                var1_1.close();
                                break block217;
lbl211:
                                // 1 sources

                                catch (IOException var12_77) {
                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_77.getMessage(), (Throwable)var12_77);
                                }
                            }
                            if (this.runBeforeFinishHook) {
                                for (OutputRecognizer var13_98 : this.recognizers) {
                                    for (String var17_182 : var13_98.beforeFinish()) {
                                        this.writer.println(var17_182);
                                    }
                                }
                            }
                            this.writer.flush();
                            this.writer.close();
                            var12_77 = this.recognizers.iterator();
                            while (true) {
                                if (!var12_77.hasNext()) {
                                    throw var10_193;
                                }
                                var13_98 = var12_77.next();
                                var13_98.finish();
                            }
                        }
                    }
                    var11_54 = null;
                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl232:
                    // 1 sources

                    var1_1.close();
                    break block218;
lbl234:
                    // 1 sources

                    catch (IOException var12_75) {
                        OutputForwarder.LOGGER.log(Level.WARNING, var12_75.getMessage(), (Throwable)var12_75);
                    }
                }
                if (this.runBeforeFinishHook) {
                    for (OutputRecognizer var13_96 : this.recognizers) {
                        for (String var17_180 : var13_96.beforeFinish()) {
                            this.writer.println(var17_180);
                        }
                    }
                }
                this.writer.flush();
                this.writer.close();
                for (OutputRecognizer var13_96 : this.recognizers) {
                    var13_96.finish();
                }
                return;
            }
            catch (Throwable var3_8) {
                block238: {
                    block220: {
                        block237: {
                            block234: {
                                block233: {
                                    block232: {
                                        block229: {
                                            block228: {
                                                block227: {
                                                    block224: {
                                                        block223: {
                                                            block219: {
                                                                OutputForwarder.LOGGER.log(Level.INFO, var3_8.getMessage(), var3_8);
                                                                var7_19 = null;
                                                                ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl254:
                                                                // 1 sources

                                                                ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl255:
                                                                // 1 sources

                                                                if (Thread.interrupted()) {
                                                                    // empty if block
                                                                }
                                                                if (this.stopAction.process == null) {
                                                                    var8_31 = false;
                                                                } else {
                                                                    ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl261:
                                                                    // 1 sources

                                                                    this.stopAction.process.exitValue();
                                                                    var8_31 = false;
                                                                }
                                                                break block219;
lbl265:
                                                                // 1 sources

                                                                catch (IllegalThreadStateException var9_40) {
                                                                    var8_31 = true;
                                                                }
                                                            }
                                                            if (var8_31) {
                                                                if (this.str.available() > 0) {
                                                                    var9_40 = var1_1.readLine();
                                                                    var2_5.append((String)var9_40);
                                                                }
                                                                if (var2_5.length() > 0) {
                                                                    this.processLine(var2_5.toString());
                                                                }
                                                                break block220;
                                                            } else {
                                                                while ((var9_40 = var1_1.readLine()) != null) {
                                                                    var2_5.append((String)var9_40);
                                                                    this.processLine(var2_5.toString());
                                                                    var2_5.setLength(0);
                                                                }
                                                            }
                                                            break block220;
lbl283:
                                                            // 1 sources

                                                            catch (IOException var8_32) {
                                                                block221: {
                                                                    OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_32.getMessage(), var8_32);
                                                                    var11_58 = null;
                                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl288:
                                                                    // 1 sources

                                                                    var1_1.close();
                                                                    break block221;
lbl290:
                                                                    // 1 sources

                                                                    catch (IOException var12_79) {
                                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_79.getMessage(), (Throwable)var12_79);
                                                                    }
                                                                }
                                                                if (this.runBeforeFinishHook) {
                                                                    for (OutputRecognizer var13_100 : this.recognizers) {
                                                                        for (String var17_184 : var13_100.beforeFinish()) {
                                                                            this.writer.println(var17_184);
                                                                        }
                                                                    }
                                                                }
                                                                this.writer.flush();
                                                                this.writer.close();
                                                                for (OutputRecognizer var13_100 : this.recognizers) {
                                                                    var13_100.finish();
                                                                }
                                                                return;
                                                            }
lbl305:
                                                            // 1 sources

                                                            catch (Throwable var10_194) {
                                                                block222: {
                                                                    var11_59 = null;
                                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl309:
                                                                    // 1 sources

                                                                    var1_1.close();
                                                                    break block222;
lbl311:
                                                                    // 1 sources

                                                                    catch (IOException var12_80) {
                                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_80.getMessage(), (Throwable)var12_80);
                                                                    }
                                                                }
                                                                if (this.runBeforeFinishHook) {
                                                                    for (OutputRecognizer var13_101 : this.recognizers) {
                                                                        for (String var17_185 : var13_101.beforeFinish()) {
                                                                            this.writer.println(var17_185);
                                                                        }
                                                                    }
                                                                }
                                                                this.writer.flush();
                                                                this.writer.close();
                                                                var12_80 = this.recognizers.iterator();
                                                                while (true) {
                                                                    if (!var12_80.hasNext()) {
                                                                        throw var10_194;
                                                                    }
                                                                    var13_101 = var12_80.next();
                                                                    var13_101.finish();
                                                                }
                                                            }
lbl329:
                                                            // 1 sources

                                                            ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl330:
                                                            // 1 sources

                                                            ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl331:
                                                            // 1 sources

                                                            if (Thread.interrupted()) {
                                                                // empty if block
                                                            }
                                                            if (this.stopAction.process == null) {
                                                                var8_21 = false;
                                                            } else {
                                                                ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl337:
                                                                // 1 sources

                                                                this.stopAction.process.exitValue();
                                                                var8_21 = false;
                                                            }
                                                            break block223;
lbl341:
                                                            // 1 sources

                                                            catch (IllegalThreadStateException var9_35) {
                                                                var8_21 = true;
                                                            }
                                                        }
                                                        if (var8_21) {
                                                            if (this.str.available() > 0) {
                                                                var9_35 = var1_1.readLine();
                                                                var2_5.append((String)var9_35);
                                                            }
                                                            if (var2_5.length() > 0) {
                                                                this.processLine(var2_5.toString());
                                                            }
                                                            break block224;
                                                        } else {
                                                            while ((var9_35 = var1_1.readLine()) != null) {
                                                                var2_5.append((String)var9_35);
                                                                this.processLine(var2_5.toString());
                                                                var2_5.setLength(0);
                                                            }
                                                        }
                                                        break block224;
lbl359:
                                                        // 1 sources

                                                        catch (IOException var8_22) {
                                                            block225: {
                                                                OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_22.getMessage(), var8_22);
                                                                var11_43 = null;
                                                                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl364:
                                                                // 1 sources

                                                                var1_1.close();
                                                                break block225;
lbl366:
                                                                // 1 sources

                                                                catch (IOException var12_64) {
                                                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_64.getMessage(), (Throwable)var12_64);
                                                                }
                                                            }
                                                            if (this.runBeforeFinishHook) {
                                                                for (OutputRecognizer var13_85 : this.recognizers) {
                                                                    for (String var17_169 : var13_85.beforeFinish()) {
                                                                        this.writer.println(var17_169);
                                                                    }
                                                                }
                                                            }
                                                            this.writer.flush();
                                                            this.writer.close();
                                                            for (OutputRecognizer var13_85 : this.recognizers) {
                                                                var13_85.finish();
                                                            }
                                                            return;
                                                        }
lbl381:
                                                        // 1 sources

                                                        catch (Throwable var10_189) {
                                                            block226: {
                                                                var11_44 = null;
                                                                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl385:
                                                                // 1 sources

                                                                var1_1.close();
                                                                break block226;
lbl387:
                                                                // 1 sources

                                                                catch (IOException var12_65) {
                                                                    OutputForwarder.LOGGER.log(Level.WARNING, var12_65.getMessage(), (Throwable)var12_65);
                                                                }
                                                            }
                                                            if (this.runBeforeFinishHook) {
                                                                for (OutputRecognizer var13_86 : this.recognizers) {
                                                                    for (String var17_170 : var13_86.beforeFinish()) {
                                                                        this.writer.println(var17_170);
                                                                    }
                                                                }
                                                            }
                                                            this.writer.flush();
                                                            this.writer.close();
                                                            var12_65 = this.recognizers.iterator();
                                                            while (true) {
                                                                if (!var12_65.hasNext()) {
                                                                    throw var10_189;
                                                                }
                                                                var13_86 = var12_65.next();
                                                                var13_86.finish();
                                                            }
                                                        }
                                                    }
                                                    var11_42 = null;
                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl408:
                                                    // 1 sources

                                                    var1_1.close();
                                                    break block227;
lbl410:
                                                    // 1 sources

                                                    catch (IOException var12_63) {
                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_63.getMessage(), (Throwable)var12_63);
                                                    }
                                                }
                                                if (this.runBeforeFinishHook) {
                                                    for (OutputRecognizer var13_84 : this.recognizers) {
                                                        for (String var17_168 : var13_84.beforeFinish()) {
                                                            this.writer.println(var17_168);
                                                        }
                                                    }
                                                }
                                                this.writer.flush();
                                                this.writer.close();
                                                for (OutputRecognizer var13_84 : this.recognizers) {
                                                    var13_84.finish();
                                                }
                                                return;
lbl425:
                                                // 1 sources

                                                var7_16 = null;
                                                ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl427:
                                                // 1 sources

                                                ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl428:
                                                // 1 sources

                                                if (Thread.interrupted()) {
                                                    // empty if block
                                                }
                                                if (this.stopAction.process == null) {
                                                    var8_25 = false;
                                                } else {
                                                    ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl434:
                                                    // 1 sources

                                                    this.stopAction.process.exitValue();
                                                    var8_25 = false;
                                                }
                                                break block228;
lbl438:
                                                // 1 sources

                                                catch (IllegalThreadStateException var9_37) {
                                                    var8_25 = true;
                                                }
                                            }
                                            if (var8_25) {
                                                if (this.str.available() > 0) {
                                                    var9_37 = var1_1.readLine();
                                                    var2_5.append((String)var9_37);
                                                }
                                                if (var2_5.length() > 0) {
                                                    this.processLine(var2_5.toString());
                                                }
                                                break block229;
                                            } else {
                                                while ((var9_37 = var1_1.readLine()) != null) {
                                                    var2_5.append((String)var9_37);
                                                    this.processLine(var2_5.toString());
                                                    var2_5.setLength(0);
                                                }
                                            }
                                            break block229;
lbl456:
                                            // 1 sources

                                            catch (IOException var8_26) {
                                                block230: {
                                                    OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_26.getMessage(), var8_26);
                                                    var11_49 = null;
                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl461:
                                                    // 1 sources

                                                    var1_1.close();
                                                    break block230;
lbl463:
                                                    // 1 sources

                                                    catch (IOException var12_70) {
                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_70.getMessage(), (Throwable)var12_70);
                                                    }
                                                }
                                                if (this.runBeforeFinishHook) {
                                                    for (OutputRecognizer var13_91 : this.recognizers) {
                                                        for (String var17_175 : var13_91.beforeFinish()) {
                                                            this.writer.println(var17_175);
                                                        }
                                                    }
                                                }
                                                this.writer.flush();
                                                this.writer.close();
                                                for (OutputRecognizer var13_91 : this.recognizers) {
                                                    var13_91.finish();
                                                }
                                                return;
                                            }
lbl478:
                                            // 1 sources

                                            catch (Throwable var10_191) {
                                                block231: {
                                                    var11_50 = null;
                                                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl482:
                                                    // 1 sources

                                                    var1_1.close();
                                                    break block231;
lbl484:
                                                    // 1 sources

                                                    catch (IOException var12_71) {
                                                        OutputForwarder.LOGGER.log(Level.WARNING, var12_71.getMessage(), (Throwable)var12_71);
                                                    }
                                                }
                                                if (this.runBeforeFinishHook) {
                                                    for (OutputRecognizer var13_92 : this.recognizers) {
                                                        for (String var17_176 : var13_92.beforeFinish()) {
                                                            this.writer.println(var17_176);
                                                        }
                                                    }
                                                }
                                                this.writer.flush();
                                                this.writer.close();
                                                var12_71 = this.recognizers.iterator();
                                                while (true) {
                                                    if (!var12_71.hasNext()) {
                                                        throw var10_191;
                                                    }
                                                    var13_92 = var12_71.next();
                                                    var13_92.finish();
                                                }
                                            }
                                        }
                                        var11_48 = null;
                                        ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl505:
                                        // 1 sources

                                        var1_1.close();
                                        break block232;
lbl507:
                                        // 1 sources

                                        catch (IOException var12_69) {
                                            OutputForwarder.LOGGER.log(Level.WARNING, var12_69.getMessage(), (Throwable)var12_69);
                                        }
                                    }
                                    if (this.runBeforeFinishHook) {
                                        for (OutputRecognizer var13_90 : this.recognizers) {
                                            for (String var17_174 : var13_90.beforeFinish()) {
                                                this.writer.println(var17_174);
                                            }
                                        }
                                    }
                                    this.writer.flush();
                                    this.writer.close();
                                    for (OutputRecognizer var13_90 : this.recognizers) {
                                        var13_90.finish();
                                    }
                                    return;
lbl522:
                                    // 1 sources

                                    var7_17 = null;
                                    ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl524:
                                    // 1 sources

                                    ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl525:
                                    // 1 sources

                                    if (Thread.interrupted()) {
                                        // empty if block
                                    }
                                    if (this.stopAction.process == null) {
                                        var8_27 = false;
                                    } else {
                                        ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl531:
                                        // 1 sources

                                        this.stopAction.process.exitValue();
                                        var8_27 = false;
                                    }
                                    break block233;
lbl535:
                                    // 1 sources

                                    catch (IllegalThreadStateException var9_38) {
                                        var8_27 = true;
                                    }
                                }
                                if (var8_27) {
                                    if (this.str.available() > 0) {
                                        var9_38 = var1_1.readLine();
                                        var2_5.append((String)var9_38);
                                    }
                                    if (var2_5.length() > 0) {
                                        this.processLine(var2_5.toString());
                                    }
                                    break block234;
                                } else {
                                    while ((var9_38 = var1_1.readLine()) != null) {
                                        var2_5.append((String)var9_38);
                                        this.processLine(var2_5.toString());
                                        var2_5.setLength(0);
                                    }
                                }
                                break block234;
lbl553:
                                // 1 sources

                                catch (IOException var8_28) {
                                    block235: {
                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_28.getMessage(), var8_28);
                                        var11_52 = null;
                                        ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl558:
                                        // 1 sources

                                        var1_1.close();
                                        break block235;
lbl560:
                                        // 1 sources

                                        catch (IOException var12_73) {
                                            OutputForwarder.LOGGER.log(Level.WARNING, var12_73.getMessage(), (Throwable)var12_73);
                                        }
                                    }
                                    if (this.runBeforeFinishHook) {
                                        for (OutputRecognizer var13_94 : this.recognizers) {
                                            for (String var17_178 : var13_94.beforeFinish()) {
                                                this.writer.println(var17_178);
                                            }
                                        }
                                    }
                                    this.writer.flush();
                                    this.writer.close();
                                    for (OutputRecognizer var13_94 : this.recognizers) {
                                        var13_94.finish();
                                    }
                                    return;
                                }
lbl575:
                                // 1 sources

                                catch (Throwable var10_192) {
                                    block236: {
                                        var11_53 = null;
                                        ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl579:
                                        // 1 sources

                                        var1_1.close();
                                        break block236;
lbl581:
                                        // 1 sources

                                        catch (IOException var12_74) {
                                            OutputForwarder.LOGGER.log(Level.WARNING, var12_74.getMessage(), (Throwable)var12_74);
                                        }
                                    }
                                    if (this.runBeforeFinishHook) {
                                        for (OutputRecognizer var13_95 : this.recognizers) {
                                            for (String var17_179 : var13_95.beforeFinish()) {
                                                this.writer.println(var17_179);
                                            }
                                        }
                                    }
                                    this.writer.flush();
                                    this.writer.close();
                                    var12_74 = this.recognizers.iterator();
                                    while (true) {
                                        if (!var12_74.hasNext()) {
                                            throw var10_192;
                                        }
                                        var13_95 = var12_74.next();
                                        var13_95.finish();
                                    }
                                }
                            }
                            var11_51 = null;
                            ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl602:
                            // 1 sources

                            var1_1.close();
                            break block237;
lbl604:
                            // 1 sources

                            catch (IOException var12_72) {
                                OutputForwarder.LOGGER.log(Level.WARNING, var12_72.getMessage(), (Throwable)var12_72);
                            }
                        }
                        if (this.runBeforeFinishHook) {
                            for (OutputRecognizer var13_93 : this.recognizers) {
                                for (String var17_177 : var13_93.beforeFinish()) {
                                    this.writer.println(var17_177);
                                }
                            }
                        }
                        this.writer.flush();
                        this.writer.close();
                        for (OutputRecognizer var13_93 : this.recognizers) {
                            var13_93.finish();
                        }
                        return;
                    }
                    var11_57 = null;
                    ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl622:
                    // 1 sources

                    var1_1.close();
                    break block238;
lbl624:
                    // 1 sources

                    catch (IOException var12_78) {
                        OutputForwarder.LOGGER.log(Level.WARNING, var12_78.getMessage(), (Throwable)var12_78);
                    }
                }
                if (this.runBeforeFinishHook) {
                    for (OutputRecognizer var13_99 : this.recognizers) {
                        for (String var17_183 : var13_99.beforeFinish()) {
                            this.writer.println(var17_183);
                        }
                    }
                }
                this.writer.flush();
                this.writer.close();
                for (OutputRecognizer var13_99 : this.recognizers) {
                    var13_99.finish();
                }
                return;
            }
        }
        catch (Throwable var6_196) {
            block243: {
                block240: {
                    block239: {
                        var7_20 = null;
                        ** try [egrp 4[TRYBLOCK] [19 : 366->541)] { 
lbl643:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [18 : 366->493)] { 
lbl644:
                        // 1 sources

                        if (Thread.interrupted()) {
                            // empty if block
                        }
                        if (this.stopAction.process == null) {
                            var8_33 = false;
                        } else {
                            ** try [egrp 6[TRYBLOCK] [17 : 388->405)] { 
lbl650:
                            // 1 sources

                            this.stopAction.process.exitValue();
                            var8_33 = false;
                        }
                        break block239;
lbl654:
                        // 1 sources

                        catch (IllegalThreadStateException var9_41) {
                            var8_33 = true;
                        }
                    }
                    if (var8_33) {
                        if (this.str.available() > 0) {
                            var9_41 = var1_1.readLine();
                            var2_5.append((String)var9_41);
                        }
                        if (var2_5.length() > 0) {
                            this.processLine(var2_5.toString());
                        }
                        break block240;
                    } else {
                        while ((var9_41 = var1_1.readLine()) != null) {
                            var2_5.append((String)var9_41);
                            this.processLine(var2_5.toString());
                            var2_5.setLength(0);
                        }
                    }
                    break block240;
lbl672:
                    // 1 sources

                    catch (IOException var8_34) {
                        block241: {
                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var8_34.getMessage(), var8_34);
                            var11_61 = null;
                            ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl677:
                            // 1 sources

                            var1_1.close();
                            break block241;
lbl679:
                            // 1 sources

                            catch (IOException var12_82) {
                                OutputForwarder.LOGGER.log(Level.WARNING, var12_82.getMessage(), (Throwable)var12_82);
                            }
                        }
                        if (this.runBeforeFinishHook) {
                            for (OutputRecognizer var13_103 : this.recognizers) {
                                for (String var17_187 : var13_103.beforeFinish()) {
                                    this.writer.println(var17_187);
                                }
                            }
                        }
                        this.writer.flush();
                        this.writer.close();
                        for (OutputRecognizer var13_103 : this.recognizers) {
                            var13_103.finish();
                        }
                        throw var6_196;
                    }
lbl694:
                    // 1 sources

                    catch (Throwable var10_195) {
                        block242: {
                            var11_62 = null;
                            ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl698:
                            // 1 sources

                            var1_1.close();
                            break block242;
lbl700:
                            // 1 sources

                            catch (IOException var12_83) {
                                OutputForwarder.LOGGER.log(Level.WARNING, var12_83.getMessage(), (Throwable)var12_83);
                            }
                        }
                        if (this.runBeforeFinishHook) {
                            for (OutputRecognizer var13_104 : this.recognizers) {
                                for (String var17_188 : var13_104.beforeFinish()) {
                                    this.writer.println(var17_188);
                                }
                            }
                        }
                        this.writer.flush();
                        this.writer.close();
                        var12_83 = this.recognizers.iterator();
                        while (true) {
                            if (!var12_83.hasNext()) {
                                throw var10_195;
                            }
                            var13_104 = var12_83.next();
                            var13_104.finish();
                        }
                    }
                }
                var11_60 = null;
                ** try [egrp 7[TRYBLOCK] [22 : 551->558)] { 
lbl721:
                // 1 sources

                var1_1.close();
                break block243;
lbl723:
                // 1 sources

                catch (IOException var12_81) {
                    OutputForwarder.LOGGER.log(Level.WARNING, var12_81.getMessage(), (Throwable)var12_81);
                }
            }
            if (this.runBeforeFinishHook) {
                for (OutputRecognizer var13_102 : this.recognizers) {
                    for (String var17_186 : var13_102.beforeFinish()) {
                        this.writer.println(var17_186);
                    }
                }
            }
            this.writer.flush();
            this.writer.close();
            for (OutputRecognizer var13_102 : this.recognizers) {
                var13_102.finish();
            }
            throw var6_196;
        }
    }

    private class ActionHandler
    implements OutputListener {
        private final Runnable runnable;

        private ActionHandler(Runnable runnable) {
            this.runnable = runnable;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.runnable.run();
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

