/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.ExecutionService;
import org.netbeans.modules.ruby.platform.execution.RegexpOutputRecognizer;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyExecution
extends ExecutionService {
    private static final String WINDOWS_DRIVE = "(?:\\S{1}:[\\\\/])";
    private static final String FILE_CHAR = "[^\\s\\[\\]\\:\\\"]";
    private static final String FILE = "((?:[^\\s\\[\\]\\:\\\"]*))";
    private static final String FILE_WIN = "((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))";
    private static final String LINE = "([1-9][0-9]*)";
    private static final String ROL = ".*\\s?";
    private static final String SEP = "\\:";
    private static final String STD_SUFFIX = "((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?";
    private static List<RegexpOutputRecognizer> stdRubyRecognizers;
    private static final RegexpOutputRecognizer RUBY_COMPILER;
    private static final RegexpOutputRecognizer RUBY_COMPILER_WIN_MY;
    private static final RegexpOutputRecognizer RUBY_COMPILER_WIN;
    private static final RegexpOutputRecognizer RAILS_RECOGNIZER;
    public static final RegexpOutputRecognizer RUBY_TEST_OUTPUT;
    private static final boolean SYNC_RUBY_STDIO;
    private static final boolean SKIP_KCODE = true;
    public static final boolean LAUNCH_JRUBY_SCRIPT;
    private String charsetName;

    public RubyExecution(ExecutionDescriptor executionDescriptor) {
        super(executionDescriptor);
        assert (executionDescriptor != null) : "null descriptor";
        if (executionDescriptor.getCmd() == null) {
            executionDescriptor.cmd(executionDescriptor.getPlatform().getInterpreterFile());
        }
        executionDescriptor.addBinPath(true);
    }

    public RubyExecution(ExecutionDescriptor executionDescriptor, String string) {
        this(executionDescriptor);
        this.charsetName = string;
    }

    public static synchronized List<? extends RegexpOutputRecognizer> getStandardRubyRecognizers() {
        if (stdRubyRecognizers == null) {
            stdRubyRecognizers = new LinkedList<RegexpOutputRecognizer>();
            stdRubyRecognizers.add(RAILS_RECOGNIZER);
            stdRubyRecognizers.add(RUBY_COMPILER_WIN_MY);
            stdRubyRecognizers.add(RUBY_COMPILER);
            stdRubyRecognizers.add(RUBY_COMPILER_WIN);
        }
        return stdRubyRecognizers;
    }

    public static List<? extends String> getRubyArgs(RubyPlatform rubyPlatform) {
        return new RubyExecution(new ExecutionDescriptor(rubyPlatform)).getRubyArgs(rubyPlatform.getHome().getAbsolutePath(), rubyPlatform.getInterpreterFile().getName(), null);
    }

    private List<? extends String> getRubyArgs(String string, String string2, ExecutionDescriptor executionDescriptor) {
        int n;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!LAUNCH_JRUBY_SCRIPT && string2.startsWith("jruby")) {
            String[] stringArray;
            String string3 = RubyExecution.getJavaHome();
            arrayList.add(string3 + File.separator + "bin" + File.separator + "java");
            arrayList.add("-Xverify:none");
            arrayList.add("-da");
            object2 = "-Xmx512m";
            object = "-Xss1024k";
            String[] stringArray2 = stringArray = executionDescriptor == null ? null : executionDescriptor.getJVMArguments();
            if (stringArray != null) {
                for (String string4 : stringArray) {
                    if (string4.contains("-Xmx")) {
                        object2 = null;
                    }
                    if (string4.contains("-Xss")) {
                        object = null;
                    }
                    arrayList.add(string4);
                }
            }
            if (object2 != null) {
                arrayList.add(object2);
            }
            if (object != null) {
                arrayList.add(object);
            }
            arrayList.add("-classpath");
            Object object3 = null;
            try {
                object3 = new File(string);
                object3 = ((File)object3).getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (!((File)object3).isDirectory()) {
                throw new IllegalArgumentException(((File)object3).getAbsolutePath() + " does not exist.");
            }
            File file = new File((File)object3, "lib");
            if (!file.isDirectory()) {
                throw new AssertionError((Object)('\"' + file.getAbsolutePath() + "\" exists (\"" + executionDescriptor.getCmd() + "\" is not valid JRuby executable?)"));
            }
            arrayList.add(RubyExecution.computeJRubyClassPath(executionDescriptor == null ? null : executionDescriptor.getClassPath(), file));
            arrayList.add("-Djruby.base=" + object3);
            arrayList.add("-Djruby.home=" + object3);
            arrayList.add("-Djruby.lib=" + file);
            if (Utilities.isWindows()) {
                arrayList.add("-Djruby.shell=\"cmd.exe\"");
                arrayList.add("-Djruby.script=jruby.bat");
            } else {
                arrayList.add("-Djruby.shell=/bin/sh");
                arrayList.add("-Djruby.script=jruby");
            }
            arrayList.add("org.jruby.Main");
        }
        if (SYNC_RUBY_STDIO && string2.startsWith("ruby") && ((n = string2.indexOf(46)) == -1 || n == 4 || n == 5)) {
            object2 = InstalledFileLocator.getDefault();
            object = object2.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
            if (object == null) {
                throw new RuntimeException("Can't find cluster");
            }
            object = new File(((File)object).getParentFile().getParentFile().getAbsolutePath() + File.separator + "sync-stdio.rb");
            try {
                object = ((File)object).getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            arrayList.add("-r" + ((File)object).getAbsolutePath());
        }
        return arrayList;
    }

    @Override
    protected List<? extends String> buildArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.descriptor.getCmd().getParentFile().getParent();
        String string2 = this.descriptor.getCmd().getName();
        arrayList.addAll(this.getRubyArgs(string, string2, this.descriptor));
        arrayList.addAll(super.buildArgs());
        return arrayList;
    }

    public static String getJavaHome() {
        String string = System.getProperty("jruby.java.home");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        return string;
    }

    static String computeJRubyClassPath(String string, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        File[] fileArray = file.listFiles();
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(".jar")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(file2.getAbsolutePath());
        }
        if (string != null && File.pathSeparatorChar != ':') {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ':' && n != 1) {
                    stringBuilder2.append(File.pathSeparatorChar);
                    n = 0;
                    continue;
                }
                ++n;
                stringBuilder2.append(c);
            }
            string = stringBuilder2.toString();
        }
        if (string == null) {
            string = System.getenv("JRUBY_EXTRA_CLASSPATH");
        }
        if (string != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(string);
        }
        return Utilities.isWindows() ? "\"" + stringBuilder.toString() + "\"" : stringBuilder.toString();
    }

    static {
        RUBY_COMPILER = new RegexpOutputRecognizer(".*?((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
        RUBY_COMPILER_WIN_MY = new RegexpOutputRecognizer(".*?((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))\\:([1-9][0-9]*).*\\s?");
        RUBY_COMPILER_WIN = new RegexpOutputRecognizer("^(?:(?:\\[|\\]|\\-|\\:|[0-9]|\\s|\\,)*)(?:\\s*from )?((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))\\:([1-9][0-9]*).*\\s?");
        RAILS_RECOGNIZER = new RegexpOutputRecognizer(".*#\\{RAILS_ROOT\\}/((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
        RUBY_TEST_OUTPUT = new RegexpOutputRecognizer("\\s*test.*\\[((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
        SYNC_RUBY_STDIO = System.getProperty("ruby.no.sync-stdio") == null;
        LAUNCH_JRUBY_SCRIPT = System.getProperty("ruby.use.jruby.script") != null;
    }
}

