/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.ui.RemoveClassPathRootAction;
import org.netbeans.modules.java.j2seproject.ui.ShowJavadocAction;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class ProjectNode
extends AbstractNode {
    private static final String PROJECT_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/projectDependencies.gif";
    private final AntArtifact antArtifact;
    private final URI artifactLocation;
    private Image cachedIcon;

    ProjectNode(AntArtifact antArtifact, URI uRI, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string, String string2) {
        super(Children.LEAF, ProjectNode.createLookup(antArtifact, uRI, updateHelper, referenceHelper, string, string2));
        this.antArtifact = antArtifact;
        this.artifactLocation = uRI;
    }

    public String getDisplayName() {
        ProjectInformation projectInformation = this.getProjectInformation();
        if (projectInformation != null) {
            return MessageFormat.format(NbBundle.getMessage(ProjectNode.class, (String)"TXT_ProjectArtifactFormat"), projectInformation.getDisplayName(), this.artifactLocation.toString());
        }
        return NbBundle.getMessage(ProjectNode.class, (String)"TXT_UnknownProjectName");
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int n) {
        if (this.cachedIcon == null) {
            ProjectInformation projectInformation = this.getProjectInformation();
            if (projectInformation != null) {
                Icon icon = projectInformation.getIcon();
                this.cachedIcon = ImageUtilities.icon2Image((Icon)icon);
            } else {
                this.cachedIcon = ImageUtilities.loadImage((String)PROJECT_ICON);
            }
        }
        return this.cachedIcon;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(OpenProjectAction.class), SystemAction.get(ShowJavadocAction.class), SystemAction.get(RemoveClassPathRootAction.class)};
    }

    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    private ProjectInformation getProjectInformation() {
        Project project = this.antArtifact.getProject();
        if (project != null) {
            return ProjectUtils.getInformation((Project)project);
        }
        return null;
    }

    private static Lookup createLookup(AntArtifact antArtifact, URI uRI, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string, String string2) {
        Object[] objectArray;
        Project project = antArtifact.getProject();
        if (project == null) {
            objectArray = new Object[1];
        } else {
            objectArray = new Object[3];
            objectArray[1] = new JavadocProvider(antArtifact, uRI);
            objectArray[2] = project;
        }
        objectArray[0] = new Removable(updateHelper, referenceHelper, string, string2);
        Lookup lookup = Lookups.fixed((Object[])objectArray);
        return lookup;
    }

    private static class Removable
    implements RemoveClassPathRootAction.Removable {
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathId;
        private final String entryId;

        Removable(UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string, String string2) {
            this.helper = updateHelper;
            this.refHelper = referenceHelper;
            this.classPathId = string;
            this.entryId = string2;
        }

        public boolean canRemove() {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            return editableProperties.getProperty(this.classPathId) != null;
        }

        public void remove() {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    EditableProperties editableProperties = Removable.this.helper.getProperties("nbproject/project.properties");
                    String string = editableProperties.getProperty(Removable.this.classPathId);
                    if (string != null) {
                        String[] stringArray = PropertyUtils.tokenizePath((String)string);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (Removable.this.entryId.equals(ClassPathSupport.getAntPropertyName(stringArray[i]))) continue;
                            int n = arrayList.size();
                            if (n > 0) {
                                arrayList.set(n - 1, (String)arrayList.get(n - 1) + ':');
                            }
                            arrayList.add(stringArray[i]);
                        }
                        editableProperties.setProperty(Removable.this.classPathId, arrayList.toArray(new String[arrayList.size()]));
                        Removable.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        String string2 = "${" + Removable.this.entryId + "}";
                        if (!RemoveClassPathRootAction.isReferenced(new EditableProperties[]{editableProperties, Removable.this.helper.getProperties("nbproject/private/private.properties")}, string2)) {
                            Removable.this.refHelper.destroyReference(string2);
                        }
                        Project project = FileOwnerQuery.getOwner((FileObject)Removable.this.helper.getAntProjectHelper().getProjectDirectory());
                        assert (project != null);
                        try {
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                    }
                }
            });
        }
    }

    private static class OpenProjectAction
    extends NodeAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] nodeArray) {
            Project[] projectArray = new Project[nodeArray.length];
            for (int i = 0; i < projectArray.length; ++i) {
                Project project = OpenProjectAction.getProject(nodeArray[i]);
                if (project == null) {
                    return;
                }
                projectArray[i] = project;
            }
            OpenProjects.getDefault().open(projectArray, false);
        }

        protected boolean enable(Node[] nodeArray) {
            List<Project> list = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            for (int i = 0; i < nodeArray.length; ++i) {
                Project project = OpenProjectAction.getProject(nodeArray[i]);
                if (project == null) {
                    return false;
                }
                if (!list.contains(project)) continue;
                return false;
            }
            return true;
        }

        private static Project getProject(Node node) {
            FileObject fileObject;
            assert (node != null);
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (!(project == null || (fileObject = project.getProjectDirectory()) != null && fileObject.isValid())) {
                return null;
            }
            return project;
        }

        public String getName() {
            return NbBundle.getMessage(ProjectNode.class, (String)"CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(OpenProjectAction.class);
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final AntArtifact antArtifact;
        private final URI artifactLocation;

        JavadocProvider(AntArtifact antArtifact, URI uRI) {
            this.antArtifact = antArtifact;
            this.artifactLocation = uRI;
        }

        public boolean hasJavadoc() {
            return this.findJavadoc().size() > 0;
        }

        public void showJavadoc() {
            Set set = this.findJavadoc();
            URL[] uRLArray = set.toArray(new URL[set.size()]);
            URL uRL = ShowJavadocAction.findJavadoc("overview-summary.html", uRLArray);
            if (uRL == null) {
                uRL = ShowJavadocAction.findJavadoc("index.html", uRLArray);
            }
            ProjectInformation projectInformation = null;
            Project project = this.antArtifact.getProject();
            if (project != null) {
                projectInformation = ProjectUtils.getInformation((Project)project);
            }
            ShowJavadocAction.showJavaDoc(uRL, projectInformation == null ? NbBundle.getMessage(ProjectNode.class, (String)"TXT_UnknownProjectName") : projectInformation.getDisplayName());
        }

        private Set findJavadoc() {
            File file = this.antArtifact.getScriptLocation();
            HashSet<URL> hashSet = new HashSet<URL>();
            try {
                URL uRL = file.toURI().resolve(this.artifactLocation).normalize().toURL();
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                }
                hashSet.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)uRL).getRoots()));
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            return hashSet;
        }
    }
}

