/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;

public class ProjectReferenceUtility {
    private ProjectReferenceUtility() {
    }

    public static void addProjectReference(ReferenceHelper referenceHelper, Project project) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider != null) {
            AntArtifact[] antArtifactArray;
            for (AntArtifact antArtifact : antArtifactArray = antArtifactProvider.getBuildArtifacts()) {
                if (!antArtifact.getType().equals("war") && !antArtifact.getType().equals("jar")) continue;
                for (URI uRI : antArtifact.getArtifactLocations()) {
                    referenceHelper.addReference(antArtifact, uRI);
                }
            }
        }
    }

    public static void removeProjectReference(ReferenceHelper referenceHelper, Project project) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider != null) {
            AntArtifact[] antArtifactArray;
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            String string = "${reference." + PropertyUtils.getUsablePropertyName((String)projectInformation.getName()).replace('.', '_') + ".";
            for (AntArtifact antArtifact : antArtifactArray = antArtifactProvider.getBuildArtifacts()) {
                referenceHelper.destroyReference(string + PropertyUtils.getUsablePropertyName((String)antArtifact.getID()).replace('.', '_') + "}");
            }
        }
    }

    public static boolean hasProjectReferenceInCatalog(Project project, Project project2) {
        FileObject fileObject = project.getProjectDirectory();
        DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance(fileObject);
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project2);
        String string = PropertyUtils.getUsablePropertyName((String)projectInformation.getName()).replace('.', '_');
        try {
            CatalogWriteModel catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(fileObject);
            for (CatalogEntry catalogEntry : catalogWriteModel.getCatalogEntries()) {
                URI uRI;
                if (catalogEntry == null || catalogEntry.getTarget() == null || !defaultProjectCatalogSupport.isProjectProtocol(uRI = new URI(catalogEntry.getTarget())) || !string.equals(uRI.getSchemeSpecificPart())) continue;
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
        return false;
    }
}

