/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.project.CommandlineTransformmapCatalogModel;
import org.netbeans.modules.xslt.project.CommandlineWSDLModelRetriever;
import org.netbeans.modules.xslt.project.anttasks.AbstractJBIGenerator;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.spi.ExternalModelRetriever;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIGenerator
extends AbstractJBIGenerator {
    private Logger logger = Logger.getLogger(JBIGenerator.class.getName());
    private List<File> myDependentProjectDirs;
    private List<File> mySourceDirs;

    public JBIGenerator(List<File> depedentProjectDirs, List<File> sourceDirs, String srcDir, String buildDir) {
        super(srcDir, buildDir);
        this.myDependentProjectDirs = depedentProjectDirs;
        this.mySourceDirs = sourceDirs;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ExternalModelRetriever.class));
        Collection retrievers = null;
        if (result != null) {
            retrievers = result.allInstances();
        }
        if (retrievers != null) {
            for (ExternalModelRetriever retriever : retrievers) {
                if (!(retriever instanceof CommandlineWSDLModelRetriever)) continue;
                CommandlineWSDLModelRetriever wsdlModelRetriever = (CommandlineWSDLModelRetriever)retriever;
                if (wsdlModelRetriever.isInitialized()) break;
                wsdlModelRetriever.init(depedentProjectDirs, sourceDirs);
                break;
            }
        }
    }

    public List<File> getDepedentProjectDirs() {
        return this.myDependentProjectDirs;
    }

    public List<File> getSourceDirs() {
        return this.mySourceDirs;
    }

    @Override
    protected TMapModel getTMapModel() {
        File transformmapFile = this.getTransformmapFile();
        if (transformmapFile == null) {
            this.logger.log(Level.SEVERE, "Error encountered while processing transformmap file - " + transformmapFile.getAbsolutePath());
            throw new RuntimeException("Can't find transformation descriptor");
        }
        TMapModel tMapModel = null;
        try {
            tMapModel = CommandlineTransformmapCatalogModel.getDefault().getTMapModel(transformmapFile.toURI());
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error while creating Tramsformap Model ", ex);
            throw new RuntimeException("Error while creating Transformmap Model ", ex);
        }
        if (tMapModel == null || !Model.State.VALID.equals((Object)tMapModel.getState())) {
            this.logger.log(Level.SEVERE, "Error while creating Transformmap Model - " + (tMapModel == null ? " is null" : " is not valid"));
            throw new RuntimeException("Error while creating Transformmap Model ");
        }
        return tMapModel;
    }

    @Override
    protected <T extends ReferenceableWSDLComponent> T resolveReference(NamedComponentReference<T> ref) {
        if (ref == null) {
            return null;
        }
        return (T)((ReferenceableWSDLComponent)ref.get());
    }
}

