/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.libraries.util;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.javascript.libraries.ui.AddLibraryPanel;
import org.netbeans.modules.javascript.libraries.ui.JSLibraryModificationPanel;
import org.netbeans.modules.javascript.libraries.util.JSLibraryData;
import org.netbeans.modules.javascript.libraries.util.Log;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSLibraryProjectUtils {
    private static final String WEB_PROJECT = "org.netbeans.modules.web.project.WebProject";
    private static final String WEB_PROJECT_DEFAULT_RELATIVE_PATH = "web";
    private static final String RUBY_PROJECT = "org.netbeans.modules.ruby.railsprojects.RailsProject";
    private static final String RUBY_PROJECT_DEFAULT_RELATIVE_PATH = "public";
    private static final String PHP_PROJECT = "org.netbeans.modules.php.project";
    private static final String OTHER_PROJECT_DEFAULT_RELATIVE_PATH = "javascript";
    private static final String LIBRARY_LIST_PROP = "javascript-libraries";
    private static final String LIBRARY_LOCATION_PREFIX = "jslibs-location-";
    private static final String LIBRARY_LOCATION_TYPE_PREFIX = "jslibs-location-type-";
    static final int LIBRARY_LOCATION_WEBROOT = 0;
    static final int LIBRARY_LOCATION_PROJECTROOT = 1;
    private static final String JS_LIBRARY_CLASSPATH = "js/library";
    private static final String LIBRARY_PROPERTIES = "library.properties";
    private static final String LIBRARY_PATH_PROP = "LibraryRoot";
    private static final String LIBRARY_DEFAULT_NAME_PROP = "DefaultLibraryDir";
    private static final String LIBRARY_ZIP_VOLUME = "scriptpath";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JSLibraryData> displayAddLibraryDialog(Project project, LibraryChooser.Filter filter) {
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(AddLibraryPanel.class, (String)"OK_BUTTON"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(AddLibraryPanel.class, (String)"CANCEL_BUTTON"));
        final AddLibraryPanel addLibraryPanel = new AddLibraryPanel(project, filter, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addLibraryPanel, NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_DialogTitle"), true, new Object[]{jButton, jButton2}, (Object)jButton2, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{jButton2});
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        final boolean[] blArray = new boolean[]{false};
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<JSLibraryData> list = addLibraryPanel.getSelectedLibraries();
                boolean bl = true;
                for (JSLibraryData jSLibraryData : list) {
                    String string = jSLibraryData.getLibraryLocation();
                    File file = FileUtil.normalizeFile((File)new File(string));
                    if (file.exists() && file.isFile()) {
                        addLibraryPanel.folderCreationFailed();
                        bl = false;
                        break;
                    }
                    if (file.exists()) continue;
                    try {
                        FileUtil.createFolder((File)file);
                    }
                    catch (IOException iOException) {
                        addLibraryPanel.folderCreationFailed();
                        break;
                    }
                }
                blArray[0] = bl;
                if (bl) {
                    dialog.setVisible(false);
                }
            }
        });
        try {
            dialog.setVisible(true);
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        return blArray[0] ? addLibraryPanel.getSelectedLibraries() : null;
    }

    public static void modifyJSLibraries(final Project project, final boolean bl, final Collection<JSLibraryData> collection) {
        final Set<String> set = JSLibraryProjectUtils.getJSLibraryNames(project);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                String string22;
                Preferences preferences = ProjectUtils.getPreferences((Project)project, JSLibraryProjectUtils.class, (boolean)true);
                assert (preferences != null);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                boolean bl2 = false;
                for (Object object : collection) {
                    string22 = ((JSLibraryData)object).getLibraryName();
                    if (bl && set.contains(string22)) {
                        bl2 = true;
                        set.remove(string22);
                        arrayList.add(object);
                        continue;
                    }
                    if (bl || set.contains(string22)) continue;
                    bl2 = true;
                    set.add(string22);
                    arrayList.add(object);
                }
                if (bl2) {
                    Object object;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string22 : set) {
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append(string22);
                            continue;
                        }
                        stringBuffer.append(";");
                        stringBuffer.append(string22);
                    }
                    preferences.put(JSLibraryProjectUtils.LIBRARY_LIST_PROP, stringBuffer.toString());
                    object = JSLibraryProjectUtils.getJSLibrarySourcePath(project);
                    string22 = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
                    for (JSLibraryData jSLibraryData : arrayList) {
                        int n;
                        String string3 = JSLibraryProjectUtils.LIBRARY_LOCATION_PREFIX + jSLibraryData.getLibraryName();
                        String string4 = JSLibraryProjectUtils.LIBRARY_LOCATION_TYPE_PREFIX + jSLibraryData.getLibraryName();
                        String string5 = jSLibraryData.getLibraryLocation();
                        if (bl || string5 == null) {
                            preferences.remove(string3);
                            preferences.remove(string4);
                            continue;
                        }
                        if (string5.startsWith((String)object)) {
                            string5 = string5.substring(((String)object).length());
                            n = 0;
                        } else if (string5.startsWith(string22)) {
                            string5 = string5.substring(string22.length());
                            n = 1;
                        } else {
                            Log.getLogger().severe("Invalid path being saved to project store");
                            string5 = "";
                            n = 0;
                        }
                        string5 = string5.replaceAll("[\\\\]", "/");
                        if (string5.startsWith("/")) {
                            string5 = string5.substring(1);
                        }
                        preferences.put(string3, string5);
                        preferences.putInt(string4, n);
                    }
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException backingStoreException) {
                        Log.getLogger().log(Level.SEVERE, "Could not write to project preferences", backingStoreException);
                    }
                }
            }
        });
    }

    public static Set<JSLibraryData> getJSLibraryData(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, JSLibraryProjectUtils.class, (boolean)true);
        assert (preferences != null);
        String string = preferences.get(LIBRARY_LIST_PROP, "");
        String[] stringArray = JSLibraryProjectUtils.removeEmptyStrings(string.split(";"));
        LinkedHashSet<JSLibraryData> linkedHashSet = new LinkedHashSet<JSLibraryData>();
        String string2 = JSLibraryProjectUtils.getJSLibrarySourcePath(project);
        String string3 = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
        for (String string4 : stringArray) {
            String string5 = preferences.get(LIBRARY_LOCATION_PREFIX + string4, null);
            int n = preferences.getInt(LIBRARY_LOCATION_TYPE_PREFIX + string4, 0);
            String string6 = n == 0 ? string2 : string3;
            string5 = string5 != null ? FileUtil.normalizeFile((File)new File(string6, string5)).getAbsolutePath() : null;
            linkedHashSet.add(new JSLibraryData(string4, string5, n));
        }
        return linkedHashSet;
    }

    public static Set<String> getJSLibraryNames(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, JSLibraryProjectUtils.class, (boolean)true);
        assert (preferences != null);
        String string = preferences.get(LIBRARY_LIST_PROP, "");
        String[] stringArray = JSLibraryProjectUtils.removeEmptyStrings(string.split(";"));
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : stringArray) {
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    public static Object displayLibraryOverwriteDialog(Library library) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"ExtractLibraries_Overwrite_Msg", (Object)library.getDisplayName()), NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"ExtractLibraries_Overwrite_Title"), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
    }

    public static Object displayLibraryDeleteConfirm(Library library) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"DeleteLibraries_Delete_Msg", (Object)library.getDisplayName()), NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"DeleteLibraries_Delete_Title"), 1);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
    }

    private static OverwriteOption displayFileOverwriteDialog(String string, String string2) {
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        JButton jButton4 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"LBL_YesToAll_Button"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"LBL_NoToAll_Button"));
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"LBL_Yes_Button"));
        Mnemonics.setLocalizedText((AbstractButton)jButton4, (String)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"LBL_No_Button"));
        Object[] objectArray = new Object[]{jButton3, jButton, jButton4, jButton2};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"ExtractLibraries_File_Overwrite_Msg", (Object)string, (Object)string2), NbBundle.getMessage(JSLibraryProjectUtils.class, (String)"ExtractLibraries_File_Overwrite_Title"), true, objectArray, (Object)jButton4, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == jButton3) {
            return OverwriteOption.OVERWRITE_ONCE;
        }
        if (object == jButton4) {
            return OverwriteOption.SKIP_ONCE;
        }
        if (object == jButton) {
            return OverwriteOption.OVERWRITE;
        }
        if (object == jButton2) {
            return OverwriteOption.SKIP;
        }
        return OverwriteOption.SKIP_ONCE;
    }

    public static LibraryChooser.Filter createDefaultFilter() {
        return new LibraryChooser.Filter(){

            public boolean accept(Library library) {
                return library.getType().equals(JSLibraryProjectUtils.OTHER_PROJECT_DEFAULT_RELATIVE_PATH);
            }
        };
    }

    public static LibraryChooser.Filter createDefaultFilter(final Set<Library> set) {
        return new LibraryChooser.Filter(){

            public boolean accept(Library library) {
                return library.getType().equals(JSLibraryProjectUtils.OTHER_PROJECT_DEFAULT_RELATIVE_PATH) && !set.contains(library);
            }
        };
    }

    public static LibraryManager getLibraryManager(Project project) {
        return LibraryManager.getDefault();
    }

    public static List<Library> getJSLibraries(Project project) {
        Set<String> set = JSLibraryProjectUtils.getJSLibraryNames(project);
        ArrayList<Library> arrayList = new ArrayList<Library>();
        LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(project);
        for (String string : set) {
            Library library = libraryManager.getLibrary(string);
            if (library == null) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    public static String getJSLibrarySourcePath(Project project) {
        try {
            FileObject fileObject = project.getProjectDirectory();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)JS_LIBRARY_CLASSPATH);
            return FileUtil.toFile((FileObject)classPath.getRoots()[0]).getAbsolutePath();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Unexpected exception retrieving web source root", exception);
            return JSLibraryProjectUtils.getDefaultSourcePath(project);
        }
    }

    public static String getProjectClassName(Project project) {
        Project project2 = (Project)project.getLookup().lookup(Project.class);
        if (project2 == null) {
            project2 = project;
        }
        return project2.getClass().getName();
    }

    public static String getDefaultRelativeLibraryPath(Project project, Library library) {
        String string;
        String string2 = JSLibraryProjectUtils.getProjectClassName(project);
        String string3 = "resources";
        if (string2.equals(RUBY_PROJECT)) {
            string3 = "";
        }
        String string4 = (string = JSLibraryProjectUtils.getLibraryDefaultDir(library)) == null ? "" : (string.length() == 0 ? string3 + File.separator + library.getName() : string3 + File.separator + string);
        return JSLibraryProjectUtils.getJSLibrarySourcePath(project) + File.separator + string4;
    }

    public static void addJSLibraryMetadata(Project project, Collection<JSLibraryData> collection) {
        JSLibraryProjectUtils.modifyJSLibraries(project, false, collection);
    }

    public static void removeJSLibraryMetadata(Project project, Collection<JSLibraryData> collection) {
        JSLibraryProjectUtils.modifyJSLibraries(project, true, collection);
    }

    private static String getDefaultSourcePath(Project project) {
        String string;
        Project project2 = (Project)project.getLookup().lookup(Project.class);
        if (project2 == null) {
            project2 = project;
        }
        if ((string = project2.getClass().getName()).startsWith(PHP_PROJECT)) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project2).getSourceGroups("PHPSOURCE");
            if (sourceGroupArray.length > 0) {
                File file = FileUtil.toFile((FileObject)sourceGroupArray[0].getRootFolder());
                return file.getAbsolutePath();
            }
            File file = FileUtil.toFile((FileObject)project2.getProjectDirectory());
            return new File(file, OTHER_PROJECT_DEFAULT_RELATIVE_PATH).getAbsolutePath();
        }
        if (string.equals(WEB_PROJECT)) {
            File file = FileUtil.toFile((FileObject)project2.getProjectDirectory());
            return new File(file, WEB_PROJECT_DEFAULT_RELATIVE_PATH).getAbsolutePath();
        }
        if (string.equals(RUBY_PROJECT)) {
            File file = FileUtil.toFile((FileObject)project2.getProjectDirectory());
            return new File(file, RUBY_PROJECT_DEFAULT_RELATIVE_PATH).getAbsolutePath();
        }
        File file = FileUtil.toFile((FileObject)project2.getProjectDirectory());
        return new File(file, OTHER_PROJECT_DEFAULT_RELATIVE_PATH).getAbsolutePath();
    }

    public static boolean extractLibrariesWithProgress(Project project, final Collection<JSLibraryData> collection) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot invoke JSLibraryProjectUtils.extractLibrariesWithProgress() outside event dispatch thread");
        }
        final LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(project);
        ResourceBundle resourceBundle = NbBundle.getBundle(JSLibraryProjectUtils.class);
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)resourceBundle.getString("LBL_Add_Libraries_progress"));
        final JDialog jDialog = JSLibraryProjectUtils.createProgressDialog(progressHandle, resourceBundle.getString("LBL_Add_Libraries_Msg"), resourceBundle.getString("LBL_Add_Libraries_Title"));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    HashMap hashMap = new HashMap();
                    int n = JSLibraryProjectUtils.initializeZipTable(libraryManager, collection, hashMap);
                    progressHandle.start(n);
                    int n2 = 0;
                    for (JSLibraryData jSLibraryData : collection) {
                        Collection collection2 = (Collection)hashMap.get(jSLibraryData);
                        if (jSLibraryData.getLibraryLocation() == null) {
                            Log.getLogger().severe("No location set for library: " + jSLibraryData.getLibraryName());
                        }
                        for (ZipFile zipFile : collection2) {
                            try {
                                String string = JSLibraryProjectUtils.getLibraryRoot(zipFile);
                                Library library = libraryManager.getLibrary(jSLibraryData.getLibraryName());
                                n2 = JSLibraryProjectUtils.extractZip(library.getDisplayName(), jSLibraryData, zipFile, progressHandle, n2, string);
                            }
                            catch (IOException iOException) {
                                Log.getLogger().log(Level.SEVERE, "Unable to extract zip file", iOException);
                            }
                        }
                    }
                    progressHandle.finish();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jDialog.setVisible(false);
                            jDialog.dispose();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        jDialog.setVisible(true);
        return true;
    }

    public static boolean deleteLibrariesWithProgress(final Project project, final Collection<JSLibraryData> collection) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot invoke JSLibraryProjectUtils.deleteLibrariesWithProgress() outside event dispatch thread");
        }
        final LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(project);
        ResourceBundle resourceBundle = NbBundle.getBundle(JSLibraryProjectUtils.class);
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)resourceBundle.getString("LBL_Remove_Libraries_progress"));
        final JDialog jDialog = JSLibraryProjectUtils.createProgressDialog(progressHandle, resourceBundle.getString("LBL_Remove_Libraries_Msg"), resourceBundle.getString("LBL_Remove_Libraries_Title"));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    HashMap hashMap = new HashMap();
                    int n = JSLibraryProjectUtils.initializeZipTable(libraryManager, collection, hashMap);
                    progressHandle.start(n);
                    int n2 = 0;
                    for (JSLibraryData jSLibraryData : collection) {
                        File file = new File(jSLibraryData.getLibraryLocation());
                        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                        Collection collection2 = (Collection)hashMap.get(jSLibraryData);
                        List list = JSLibraryProjectUtils.getSortedFilenamesInZips(collection2);
                        Collections.reverse(list);
                        try {
                            n2 = JSLibraryProjectUtils.deleteFiles(project, fileObject, list, progressHandle, n2);
                        }
                        catch (IOException iOException) {
                            Log.getLogger().log(Level.SEVERE, "Unable to delete files", iOException);
                        }
                    }
                    progressHandle.finish();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jDialog.setVisible(false);
                            jDialog.dispose();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        jDialog.setVisible(true);
        return true;
    }

    private static int initializeZipTable(LibraryManager libraryManager, Collection<JSLibraryData> collection, Map<JSLibraryData, Collection<ZipFile>> map) {
        int n = 0;
        for (JSLibraryData jSLibraryData : collection) {
            Library library = libraryManager.getLibrary(jSLibraryData.getLibraryName());
            if (library == null) {
                Log.getLogger().severe("JavaScript library not found: " + jSLibraryData.getLibraryName());
                continue;
            }
            List<ZipFile> list = JSLibraryProjectUtils.getJSLibraryZips(library);
            map.put(jSLibraryData, list);
            for (ZipFile zipFile : list) {
                n += zipFile.size();
            }
        }
        return n;
    }

    private static JDialog createProgressDialog(ProgressHandle progressHandle, String string, String string2) {
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        Frame frame = WindowManager.getDefault().getMainWindow();
        JDialog jDialog = new JDialog(frame, string2, true);
        JSLibraryModificationPanel jSLibraryModificationPanel = new JSLibraryModificationPanel(jComponent, string);
        jDialog.getContentPane().add(jSLibraryModificationPanel);
        jDialog.setDefaultCloseOperation(0);
        jDialog.pack();
        Rectangle rectangle = frame.getBounds();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        Dimension dimension = jDialog.getPreferredSize();
        jDialog.setBounds(n - dimension.width / 2, n2 - dimension.height / 2, dimension.width, dimension.height);
        return jDialog;
    }

    public static boolean isLibraryFolderEmpty(Project project, Library library, String string) {
        List<String> list = JSLibraryProjectUtils.getSortedFilenamesInZips(JSLibraryProjectUtils.getJSLibraryZips(library));
        for (String string2 : list) {
            File file = new File(string, string2);
            if (!file.exists() || !file.isFile()) continue;
            return false;
        }
        return true;
    }

    public static List<ZipFile> getJSLibraryZips(Library library) {
        ArrayList<ZipFile> arrayList = new ArrayList<ZipFile>();
        try {
            for (URL uRL : library.getContent(LIBRARY_ZIP_VOLUME)) {
                URL uRL2 = FileUtil.isArchiveFile((URL)uRL) ? uRL : FileUtil.getArchiveFile((URL)uRL);
                FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
                File file = fileObject != null ? FileUtil.toFile((FileObject)fileObject) : null;
                if (file == null) continue;
                arrayList.add(new ZipFile(file));
            }
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Unable to load zip file", iOException);
        }
        return arrayList;
    }

    private static int deleteFiles(Project project, FileObject fileObject, List<String> list, ProgressHandle progressHandle, int n) throws IOException {
        if (fileObject != null) {
            Object object;
            String string2;
            for (String string2 : list) {
                object = fileObject.getFileObject(string2);
                if (object == null) continue;
                if (object.isFolder() && object.getChildren().length > 0) {
                    Log.getLogger().warning("Skipping attempt to delete non-empty folder");
                    continue;
                }
                try {
                    object.delete();
                    progressHandle.progress(++n);
                }
                catch (IOException iOException) {
                    Log.getLogger().log(Level.WARNING, "Could not delete file: " + FileUtil.getFileDisplayName((FileObject)object));
                }
            }
            String string3 = JSLibraryProjectUtils.getJSLibrarySourcePath(project);
            string2 = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
            String string4 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
            if (string4.startsWith(string3)) {
                object = string3;
            } else if (string4.startsWith(string2)) {
                object = string2;
            } else {
                Log.getLogger().severe("Deleted library path does not correspond to a project folder");
                return n;
            }
            for (FileObject fileObject2 = fileObject; fileObject2 != null && fileObject2.getChildren().length == 0 && FileUtil.getFileDisplayName((FileObject)fileObject).startsWith((String)object); fileObject2 = fileObject2.getParent()) {
                try {
                    fileObject2.delete();
                    continue;
                }
                catch (IOException iOException) {
                    Log.getLogger().log(Level.SEVERE, "Could not delete folder: " + FileUtil.getFileDisplayName((FileObject)fileObject2), iOException);
                    break;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int extractZip(String string, JSLibraryData jSLibraryData, ZipFile zipFile, ProgressHandle progressHandle, int n, String string2) throws IOException {
        File file = new File(jSLibraryData.getLibraryLocation());
        try {
            FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Unable to find or create root folder", iOException);
            return 0;
        }
        try {
            OverwriteOption overwriteOption = OverwriteOption.PROMPT;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                File file2;
                String string3;
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = string3 = zipEntry.getName();
                if (string2 != null) {
                    if (!string3.startsWith(string2)) continue;
                    string4 = string4.substring(string2.length());
                }
                if (string4.length() == 0) {
                    ++n;
                    continue;
                }
                if (zipEntry.isDirectory()) {
                    file2 = new File(file, string4);
                    FileUtil.createFolder((File)file2);
                    progressHandle.progress(++n);
                    continue;
                }
                file2 = new File(file, string4);
                boolean bl = file2.exists();
                if (bl && file2.isDirectory()) {
                    throw new IOException("Cannot write normal file to existing directory with the same path");
                }
                if (overwriteOption == OverwriteOption.PROMPT && bl) {
                    object = JSLibraryProjectUtils.displayFileOverwriteDialog(file2.getAbsolutePath(), string);
                    if (object == OverwriteOption.SKIP_ONCE) continue;
                    if (object == OverwriteOption.SKIP) {
                        overwriteOption = object;
                        continue;
                    }
                    if (object == OverwriteOption.OVERWRITE) {
                        overwriteOption = object;
                    }
                } else if (bl && overwriteOption == OverwriteOption.SKIP) continue;
                FileUtil.createData((File)file2);
                object = new BufferedOutputStream(new FileOutputStream(file2));
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    int n2;
                    byte[] byArray = new byte[4096];
                    while ((n2 = inputStream.read(byArray)) >= 0) {
                        ((BufferedOutputStream)object).write(byArray, 0, n2);
                    }
                }
                finally {
                    ((FilterOutputStream)object).close();
                    inputStream.close();
                    progressHandle.progress(++n);
                }
            }
        }
        finally {
            zipFile.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLibraryDefaultDir(Library library) {
        List<ZipFile> list = JSLibraryProjectUtils.getJSLibraryZips(library);
        if (list.size() == 0) {
            return null;
        }
        ZipFile zipFile = list.get(0);
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry = zipFile.getEntry(LIBRARY_PROPERTIES);
            if (zipEntry != null) {
                String string;
                Properties properties = new Properties();
                inputStream = zipFile.getInputStream(zipEntry);
                properties.load(inputStream);
                String string2 = string = properties.getProperty(LIBRARY_DEFAULT_NAME_PROP);
                return string2;
            }
            String string = "";
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLibraryRoot(ZipFile zipFile) {
        Properties properties;
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry = zipFile.getEntry(LIBRARY_PROPERTIES);
            if (zipEntry != null) {
                properties = new Properties();
                inputStream = zipFile.getInputStream(zipEntry);
                properties.load(inputStream);
                String string = properties.getProperty(LIBRARY_PATH_PROP);
                if (string == null) {
                    String string2 = null;
                    return string2;
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                String string3 = string;
                return string3;
            }
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            properties = null;
            return properties;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static List<String> getSortedFilenamesInZips(Collection<ZipFile> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ZipFile zipFile : collection) {
            String string = JSLibraryProjectUtils.getLibraryRoot(zipFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (string != null) {
                    string2 = string2.startsWith(string) ? string2.substring(string.length()) : "";
                }
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static String[] removeEmptyStrings(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OverwriteOption {
        PROMPT,
        OVERWRITE,
        SKIP,
        OVERWRITE_ONCE,
        SKIP_ONCE;

    }
}

