/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;

public class Text
extends NodeImpl
implements Node,
org.w3c.dom.Text {
    private static final Pattern AMPERSAND_PATTERN = Pattern.compile("&amp;");
    private static final Pattern LESS_THAN_PATTERN = Pattern.compile("&lt;");
    private static final Pattern GREATER_THAN_PATTERN = Pattern.compile("&gt;");

    public void accept(XMLNodeVisitor xMLNodeVisitor) {
        xMLNodeVisitor.visit(this);
    }

    Text() {
    }

    Text(String string) {
        this();
        this.setText(string);
    }

    public String getNodeValue() {
        return this.getText();
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : this.getTokens()) {
            if (token.getType() != TokenType.TOKEN_CHARACTER_DATA) continue;
            stringBuilder.append(token.getValue());
        }
        return this.removeEntityReference(stringBuilder.toString());
    }

    public void setText(String string) {
        this.checkNotInTree();
        List<Token> list = this.getTokensForWrite();
        if (!list.isEmpty()) {
            list.clear();
        }
        if (string == null) {
            string = "";
        }
        string = this.insertEntityReference(string);
        list.add(Token.create(string, TokenType.TOKEN_CHARACTER_DATA));
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public org.w3c.dom.Text replaceWholeText(String string) {
        return null;
    }

    public org.w3c.dom.Text splitText(int n) {
        return null;
    }

    public String getWholeText() {
        return null;
    }

    public void setData(String string) {
        this.checkNotInTree();
        List<Token> list = this.getTokensForWrite();
        if (!list.isEmpty()) {
            list.clear();
        }
        if (string == null) {
            string = "";
        }
        list.add(Token.create(string, TokenType.TOKEN_CHARACTER_DATA));
    }

    public void appendData(String string) {
    }

    public void replaceData(int n, int n2, String string) {
    }

    public void insertData(int n, String string) {
    }

    public String substringData(int n, int n2) {
        return null;
    }

    public String getData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : this.getTokens()) {
            if (token.getType() != TokenType.TOKEN_CHARACTER_DATA) continue;
            stringBuilder.append(token.getValue());
        }
        return stringBuilder.toString();
    }

    public void deleteData(int n, int n2) {
    }

    private String insertEntityReference(String string) {
        String string2 = this.removeEntityReference(string);
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        return string2;
    }

    private String removeEntityReference(String string) {
        String string2 = string;
        string2 = AMPERSAND_PATTERN.matcher(string2).replaceAll("&");
        string2 = LESS_THAN_PATTERN.matcher(string2).replaceAll("<");
        string2 = GREATER_THAN_PATTERN.matcher(string2).replaceAll(">");
        return string2;
    }
}

